<?php
if (!defined('_VIS_'))
    die('Error: Call from undefined function');
class report
{
    var $error;
    
    function report()
    {
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $object = new class_setting($database);
        if (!defined("VIS_TIMEZONE")) {
            $dom_vars = $object->get_domain(VIS_TABLE_PREFIX . 'domain.is_enabled=1', '', 0, '', 0, 4);
            if ($dom_vars)
                list($dinfo, $domain) = $dom_vars;
            if ($domain != -1)
                $domain = $domain[0];
            
            if ($domain['timezone_dst'] == 1)
                $domain['timezone'] += 3600;
            define('VIS_TIMEZONE', $domain['timezone']);
        } else {
            //
        }
    }
    /*function report_list($operation) {
    $database=new class_database();
    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'report.php');
    $object=new class_report($database);
    $report=$object->get_report('', VIS_STAFF_ID, VIS_LOCATION_AREA);
    $database->database_disconnect();
    include(VIS_PATH_TEMPLATE.'report.php');
    return true;
    }*/
    
    function add_report($operation)
    {
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $ticket       = new class_ticket($database);
        $client       = new class_client($database);
        $setting      = new class_setting($database);
        $ticket_types = $ticket->get_type_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
        $user_groups  = $client->get_client_group('is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $departments  = $ticket->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $status       = $ticket->get_status_list('is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $priorities   = $ticket->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
        $flags        = $ticket->get_flags_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
        list($oinfo, $owner) = $setting->get_staff('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($sinfo, $sla) = $setting->get_sla(VIS_TABLE_PREFIX . 'sla.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE . 'report_add.php');
        return true;
    }
    
    function save_report($operation)
    {
        global $vis_language;
        $data = parse_form_array($operation['vis_action']);
        if (!isset($data['vis_report_title']) || $data['vis_report_title'] == '') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGREQFLDTIT'] . '"); </script>';
            return false;
        }
        $fields = array();
        if ($data['vis_report_module'] == 0) {
            if (isset($data['vis_ticket_hash']) && $data['vis_ticket_hash'] == 1)
                $fields['ticket_hash'] = 1;
            if (isset($data['vis_ticket_id']) && $data['vis_ticket_id'] == 1)
                $fields['ticket_id'] = 1;
            if (isset($data['vis_ticket_subject']) && $data['vis_ticket_subject'] == 1)
                $fields['ticket_subject'] = 1;
            if (isset($data['vis_ticket_type']) && $data['vis_ticket_type'] == 1)
                $fields['ticket_type'] = 1;
            if (isset($data['vis_ticket_domain']) && $data['vis_ticket_domain'] == 1)
                $fields['ticket_domain'] = 1;
            if (isset($data['vis_ticket_department']) && $data['vis_ticket_department'] == 1)
                $fields['ticket_department'] = 1;
            if (isset($data['vis_ticket_status']) && $data['vis_ticket_status'] == 1)
                $fields['ticket_status'] = 1;
            if (isset($data['vis_ticket_priority']) && $data['vis_ticket_priority'] == 1)
                $fields['ticket_priority'] = 1;
            if (isset($data['vis_ticket_createdon']) && $data['vis_ticket_createdon'] == 1)
                $fields['ticket_receive_date'] = 1;
            if (isset($data['vis_ticket_modifiedon']) && $data['vis_ticket_modifiedon'] == 1)
                $fields['ticket_modify_date'] = 1;
            if (isset($data['vis_ticket_duetime']) && $data['vis_ticket_duetime'] == 1)
                $fields['ticket_due_time'] = 1;
            if (isset($data['vis_ticket_reslove_time']) && $data['vis_ticket_reslove_time'] == 1)
                $fields['ticket_resolution_time'] = 1;
            if (isset($data['vis_ticket_slaplan']) && $data['vis_ticket_slaplan'] == 1)
                $fields['ticket_slaplan'] = 1;
            if (isset($data['vis_ticket_sla_id']) && $data['vis_ticket_sla_id'] == 1)
                $fields['ticket_sla_id'] = 1;
            
            if (isset($data['vis_ticket_reply_count']) && $data['vis_ticket_reply_count'] == 1)
                $fields['ticket_post_count'] = 1;
            if (isset($data['vis_ticket_count']) && $data['vis_ticket_count'] == 1)
                $fields['ticket_count'] = 1;
            
        }
        if ($data['vis_report_module'] == 2 || $data['vis_report_module'] == 0) {
            if (isset($data['vis_client_first_name']) && $data['vis_client_first_name'] == 1)
                $fields['client_first_name'] = 1;
            if (isset($data['vis_client_last_name']) && $data['vis_client_last_name'] == 1)
                $fields['client_last_name'] = 1;
            if (isset($data['vis_client_email']) && $data['vis_client_email'] == 1)
                $fields['client_email'] = 1;
            if (isset($data['vis_client_contact']) && $data['vis_client_contact'] == 1)
                $fields['client_contact_number'] = 1;
            if (isset($data['vis_client_jobtitle']) && $data['vis_client_jobtitle'] == 1)
                $fields['client_job_title'] = 1;
            if (isset($data['vis_client_company']) && $data['vis_client_company'] == 1)
                $fields['client_office_name'] = 1;
            if (isset($data['vis_client_city']) && $data['vis_client_city'] == 1)
                $fields['client_city'] = 1;
            if (isset($data['vis_client_state']) && $data['vis_client_state'] == 1)
                $fields['client_state'] = 1;
            if (isset($data['vis_client_country']) && $data['vis_client_country'] == 1)
                $fields['client_country'] = 1;
            if (isset($data['vis_client_zipcode']) && $data['vis_client_zipcode'] == 1)
                $fields['client_zip_code'] = 1;
            if (isset($data['vis_client_group']) && $data['vis_client_group'] == 1)
                $fields['client_group'] = 1;
            if (isset($data['vis_client_domain']) && $data['vis_client_domain'] == 1)
                $fields['domain_name'] = 1;
            if (isset($data['vis_client_isspam']) && $data['vis_client_isspam'] == 1)
                $fields['client_is_spam'] = 1;
            if (isset($data['vis_client_isban']) && $data['vis_client_isban'] == 1)
                $fields['client_is_banned'] = 1;
            if (isset($data['vis_client_credit']) && $data['vis_client_credit'] == 1)
                $fields['client_credit'] = 1;
            if (isset($data['vis_client_debit']) && $data['vis_client_debit'] == 1)
                $fields['client_debit'] = 1;
            if (isset($data['vis_client_group_credit']) && $data['vis_client_group_credit'] == 1)
                $fields['client_group_credit'] = 1;
            if (isset($data['client_group_debit']) && $data['client_group_debit'] == 1)
                $fields['client_group_debit'] = 1;
            if (isset($data['vis_client_paid_invocie']) && $data['vis_client_paid_invocie'] == 1)
                $fields['client_paid_invoice_count'] = 1;
            if (isset($data['vis_client_unpaid_invocie']) && $data['vis_client_unpaid_invocie'] == 1)
                $fields['client_unpaid_invoice_count'] = 1;
            if (isset($data['vis_ticket_escalation_time']) && $data['vis_ticket_escalation_time'] == 1)
                $fields['escalated_time'] = 1;
            if (isset($data['vis_ticket_escalation_level']) && $data['vis_ticket_escalation_level'] == 1)
                $fields['escalation_count'] = 1;
        }
        if ($data['vis_report_module'] == 1) {
            if (isset($data['vis_staff_first_name']) && $data['vis_staff_first_name'] == 1)
                $fields['staff_first_name'] = 1;
            if (isset($data['vis_staff_last_name']) && $data['vis_staff_last_name'] == 1)
                $fields['staff_last_name'] = 1;
            if (isset($data['vis_staff_email']) && $data['vis_staff_email'] == 1)
                $fields['staff_email'] = 1;
            if (isset($data['vis_staff_job_title']) && $data['vis_staff_job_title'] == 1)
                $fields['staff_job_title'] = 1;
            if (isset($data['vis_staff_contact']) && $data['vis_staff_contact'] == 1)
                $fields['staff_contact_number'] = 1;
            if (isset($data['vis_staff_mobile']) && $data['vis_staff_mobile'] == 1)
                $fields['staff_mobile_number'] = 1;
            if (isset($data['vis_staff_avg_response']) && $data['vis_staff_avg_response'] == 1)
                $fields['avg_response'] = 1;
            if (isset($data['vis_staff_num_response']) && $data['vis_staff_num_response'] == 1)
                $fields['staff_post_count'] = 1;
        }
        
        if (count($fields) == 0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGFLDNTSEL'] . '"); </script>';
            return false;
        }
        $data['field_list'] = $fields;
        $database           = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        $report = $object->set_report($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if (!$report)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
        else
            echo '<script> $(this).visInterface("remove_tab", "vis_module_report_div"); $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_global_msg_div").visExecution("load_module", "' . $data['vis_report_title'] . '", {"vis_module":"report", "vis_operation":"view_report", "vis_report_id":' . $report . '}); </script>';
        return true;
    }
    
    function view_report($operation)
    {
        if (isset($operation['vis_report_id']) && is_numeric($operation['vis_report_id']))
            $report_id = $operation['vis_report_id'];
        else
            return false;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        $report = $object->get_report_details($report_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if ($report['report_type'] == 0)
            return $this->view_tabular_report($operation, $report, $report['module'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        elseif ($report['report_type'] == 1)
            return $this->view_summary_report($operation, $report, VIS_STAFF_ID, VIS_LOCATION_AREA);
        else
            return false;
    }
    
    function view_tabular_report($operation, $report, $module, $userid, $user)
    {
        $page    = (isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
        //$sort_by=(isset($operation['vis_sort_by']))?$operation['vis_sort_by']:'';
        $sort_by = '';
        $sort_a  = array(
            0 => 'subject',
            4 => 'first_name',
            5 => 'email',
            6 => 'client_group',
            7 => VIS_TABLE_PREFIX . 'ticket.department_id',
            8 => VIS_TABLE_PREFIX . 'ticket.status_id',
            9 => VIS_TABLE_PREFIX . 'ticket.priority_id',
            21 => VIS_TABLE_PREFIX . 'ticket.type_id',
            11 => VIS_TABLE_PREFIX . 'ticket.flag_id',
            12 => 'ticket_modify_date',
            16 => 'ticket_receive_date',
            15 => 'ticket_sla_id',
            17 => 'ticket_due_time',
            19 => 'attachment_count'
        );
        
        if ($report['sortby_1'] != -1 && isset($sort_a[$report['sortby_1']]))
            $sort_by = $sort_a[$report['sortby_1']] . ',';
        if ($report['sortby_2'] != -1 && isset($sort_a[$report['sortby_2']]))
            $sort_by .= $sort_a[$report['sortby_2']] . ',';
        if ($report['sortby_3'] != -1 && isset($sort_a[$report['sortby_3']]))
            $sort_by .= $sort_a[$report['sortby_3']] . ',';
        if ($sort_by != '')
            $sort_by = substr($sort_by, 0, -1);
        $limit    = ($page * $report['page_count']) . ',' . $report['page_count'];
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        //$report_fields=$object->get_report_fields($report['report_id'], $userid, $user);
        if ($module == 0)
            list($report_fields, $report_info, $report_result) = $object->get_ticket_report_result($report, $limit, $page, $sort_by, $userid, $user);
        elseif ($module == 1)
            list($report_fields, $report_info, $report_result) = $object->get_staff_report_result($report, $limit, $page, $sort_by, $userid, $user);
        elseif ($module == 2)
            list($report_fields, $report_info, $report_result) = $object->get_client_report_result($report, $limit, $page, $sort_by, $userid, $user);
        else
            return false;
        $page_count = ($report_info['total'] == 0) ? 0 : ceil($report_info['total'] / $report['page_count']);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE . 'tabular_report.php');
        return true;
    }
    
    function view_summary_report($data, $report, $userid, $user)
    {
        include(VIS_PATH_TEMPLATE . 'summary_report.php');
        return true;
    }
    
    function edit_report($operation)
    {
        if (isset($operation['vis_report_id']) && is_numeric($operation['vis_report_id']))
            $report_id = $operation['vis_report_id'];
        else
            return false;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $ticket       = new class_ticket($database);
        $client       = new class_client($database);
        $object       = new class_report($database);
        $setting      = new class_setting($database);
        $ticket_types = $ticket->get_type_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
        $user_groups  = $client->get_client_group('is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $departments  = $ticket->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $status       = $ticket->get_status_list('is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $priorities   = $ticket->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
        $flags        = $ticket->get_flags_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
        $report       = $object->get_report_details($report_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $fields       = $object->get_report_fields($report_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
        for ($i = 0; $i < count($fields); $i++)
            $report_fields[$fields[$i]['field_name']] = 1;
        $criteria = $object->get_criteria($report_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($oinfo, $owner) = $setting->get_staff('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($sinfo, $sla) = $setting->get_sla(VIS_TABLE_PREFIX . 'sla.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE . 'report_edit.php');
        return true;
    }
    
    function update_report($operation)
    {
        global $vis_language;
        $data = parse_form_array($operation['vis_action']);
        if (!isset($data['vis_report_title']) || $data['vis_report_title'] == '') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGREQFLDTIT'] . '"); </script>';
            return false;
        }
        $fields = array();
        if ($data['vis_report_module'] == 0) {
            if (isset($data['vis_ticket_hash']) && $data['vis_ticket_hash'] == 1)
                $fields['ticket_hash'] = 1;
            if (isset($data['vis_ticket_id']) && $data['vis_ticket_id'] == 1)
                $fields['ticket_id'] = 1;
            if (isset($data['vis_ticket_subject']) && $data['vis_ticket_subject'] == 1)
                $fields['ticket_subject'] = 1;
            if (isset($data['vis_ticket_type']) && $data['vis_ticket_type'] == 1)
                $fields['ticket_type'] = 1;
            if (isset($data['vis_ticket_domain']) && $data['vis_ticket_domain'] == 1)
                $fields['ticket_domain'] = 1;
            if (isset($data['vis_ticket_department']) && $data['vis_ticket_department'] == 1)
                $fields['ticket_department'] = 1;
            if (isset($data['vis_ticket_status']) && $data['vis_ticket_status'] == 1)
                $fields['ticket_status'] = 1;
            if (isset($data['vis_ticket_priority']) && $data['vis_ticket_priority'] == 1)
                $fields['ticket_priority'] = 1;
            if (isset($data['vis_ticket_createdon']) && $data['vis_ticket_createdon'] == 1)
                $fields['ticket_receive_date'] = 1;
            if (isset($data['vis_ticket_modifiedon']) && $data['vis_ticket_modifiedon'] == 1)
                $fields['ticket_modify_date'] = 1;
            if (isset($data['vis_ticket_duetime']) && $data['vis_ticket_duetime'] == 1)
                $fields['ticket_due_time'] = 1;
            if (isset($data['vis_ticket_reslove_time']) && $data['vis_ticket_reslove_time'] == 1)
                $fields['ticket_resolution_time'] = 1;
            if (isset($data['vis_ticket_slaplan']) && $data['vis_ticket_slaplan'] == 1)
                $fields['ticket_slaplan'] = 1;
            if (isset($data['vis_ticket_sla_id']) && $data['vis_ticket_sla_id'] == 1)
                $fields['ticket_sla_id'] = 1;
            
            if (isset($data['vis_ticket_reply_count']) && $data['vis_ticket_reply_count'] == 1)
                $fields['ticket_post_count'] = 1;
            if (isset($data['vis_ticket_count']) && $data['vis_ticket_count'] == 1)
                $fields['ticket_count'] = 1;
            
        }
        if ($data['vis_report_module'] == 2 || $data['vis_report_module'] == 0) {
            if (isset($data['vis_client_first_name']) && $data['vis_client_first_name'] == 1)
                $fields['client_first_name'] = 1;
            if (isset($data['vis_client_last_name']) && $data['vis_client_last_name'] == 1)
                $fields['client_last_name'] = 1;
            if (isset($data['vis_client_email']) && $data['vis_client_email'] == 1)
                $fields['client_email'] = 1;
            if (isset($data['vis_client_contact']) && $data['vis_client_contact'] == 1)
                $fields['client_contact_number'] = 1;
            if (isset($data['vis_client_jobtitle']) && $data['vis_client_jobtitle'] == 1)
                $fields['client_job_title'] = 1;
            if (isset($data['vis_client_company']) && $data['vis_client_company'] == 1)
                $fields['client_office_name'] = 1;
            if (isset($data['vis_client_city']) && $data['vis_client_city'] == 1)
                $fields['client_city'] = 1;
            if (isset($data['vis_client_state']) && $data['vis_client_state'] == 1)
                $fields['client_state'] = 1;
            if (isset($data['vis_client_country']) && $data['vis_client_country'] == 1)
                $fields['client_country'] = 1;
            if (isset($data['vis_client_zipcode']) && $data['vis_client_zipcode'] == 1)
                $fields['client_zip_code'] = 1;
            if (isset($data['vis_client_group']) && $data['vis_client_group'] == 1)
                $fields['client_group'] = 1;
            if (isset($data['vis_client_domain']) && $data['vis_client_domain'] == 1)
                $fields['domain_name'] = 1;
            if (isset($data['vis_client_isspam']) && $data['vis_client_isspam'] == 1)
                $fields['client_is_spam'] = 1;
            if (isset($data['vis_client_isban']) && $data['vis_client_isban'] == 1)
                $fields['client_is_banned'] = 1;
            if (isset($data['vis_client_credit']) && $data['vis_client_credit'] == 1)
                $fields['client_credit'] = 1;
            if (isset($data['vis_client_debit']) && $data['vis_client_debit'] == 1)
                $fields['client_debit'] = 1;
            if (isset($data['vis_client_group_credit']) && $data['vis_client_group_credit'] == 1)
                $fields['client_group_credit'] = 1;
            if (isset($data['client_group_debit']) && $data['client_group_debit'] == 1)
                $fields['client_group_debit'] = 1;
            if (isset($data['vis_client_paid_invocie']) && $data['vis_client_paid_invocie'] == 1)
                $fields['client_paid_invoice_count'] = 1;
            if (isset($data['vis_client_unpaid_invocie']) && $data['vis_client_unpaid_invocie'] == 1)
                $fields['client_unpaid_invoice_count'] = 1;
            if (isset($data['vis_ticket_escalation_time']) && $data['vis_ticket_escalation_time'] == 1)
                $fields['escalated_time'] = 1;
            if (isset($data['vis_ticket_escalation_level']) && $data['vis_ticket_escalation_level'] == 1)
                $fields['escalation_count'] = 1;
        }
        if ($data['vis_report_module'] == 1) {
            if (isset($data['vis_staff_first_name']) && $data['vis_staff_first_name'] == 1)
                $fields['staff_first_name'] = 1;
            if (isset($data['vis_staff_last_name']) && $data['vis_staff_last_name'] == 1)
                $fields['staff_last_name'] = 1;
            if (isset($data['vis_staff_email']) && $data['vis_staff_email'] == 1)
                $fields['staff_email'] = 1;
            if (isset($data['vis_staff_job_title']) && $data['vis_staff_job_title'] == 1)
                $fields['staff_job_title'] = 1;
            if (isset($data['vis_staff_contact']) && $data['vis_staff_contact'] == 1)
                $fields['staff_contact_number'] = 1;
            if (isset($data['vis_staff_mobile']) && $data['vis_staff_mobile'] == 1)
                $fields['staff_mobile_number'] = 1;
            if (isset($data['vis_staff_avg_response']) && $data['vis_staff_avg_response'] == 1)
                $fields['avg_response'] = 1;
            if (isset($data['vis_staff_num_response']) && $data['vis_staff_num_response'] == 1)
                $fields['staff_post_count'] = 1;
        }
        
        if (count($fields) == 0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGFLDNTSEL'] . '"); </script>';
            return false;
        }
        $data['field_list'] = $fields;
        $database           = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        $report = $object->update_report($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if (!$report)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
        else
            echo '<script> $(this).visInterface("remove_tab", "vis_module_report_div"); $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");  </script>';
        return true;
    }
    
    function get_delete_report($operation)
    {
        global $vis_language;
        $message_info['vis_form_title'] = $vis_language['TXTDELETEREPORT'];
        $message_info['vis_message']    = $vis_language['MSGSURE'];
        $message_info['vis_event']      = "$(this).visExecution('load_operations', {'vis_module':'report', 'vis_operation':'delete_report', 'vis_report_id':" . $operation['vis_report_id'] . "})";
        include(VIS_PATH_TEMPLATE . 'confirm_delete.php');
        return true;
    }
    
    function delete_report($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        $result = $object->delete_report($operation['vis_report_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if (!$result)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); $("#vis_report_delete_area").dialog("close"); </script>';
        else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_report_delete_area").dialog("close"); $("#vis_module_report_div").tabs("load", $("#vis_module_report_div").tabs("option","selected")) </script>';
        return $result;
    }
    
    function report_list($operation)
    {  
	    global $vis_language;
        $operation['view_title'] = $vis_language['TXTREPORTS'];
        $hideHeader              = 0;
        if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
            $data = parse_form_array($operation['vis_action']);
        }
        if (isset($operation['show_report'])) {
            $hideHeader = 1;
        }
        $filter   = "";
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
		
		$staff       = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $setting = new class_setting($database);
        list($info, $modules) = $setting->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        foreach ($modules as $var)
           $module[$var['module']] = 1;
        $report      = $object->get_report('', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $domain      = $tkt_object->get_domain('', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $currentdate = date('Y-m-d 00:00:00');
		if ($operation['show_report'] == 1) {
            if ($data['criteria'] == 1) // previous 1 month
            {
				$currentdate = date('Y-m-d h:i:s');
				$prevDt1 = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                $prevDt2 = strtotime($currentdate);
                $filter    = VIS_TABLE_PREFIX . 'ticket.receive_date between "' . $prevDt1 . '" AND "' . $prevDt2 . '" and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0';
                $filter2   = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
                //$filter3   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $prevDt1 . ' AND ' . $prevDt2 . ' and is_spam=0 and is_deleted=0 and ' . VIS_TABLE_PREFIX . 'ticket.domain_id = ' . $data['domain_id'];
				$filter3 = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$prevDt1.' AND '.$prevDt2.' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51)';
				$filter4 =  VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $prevDt1 . ' AND ' . $prevDt2 .' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'];
            } elseif ($data['criteria'] == 2) // previous 1 week
            {
             	$start_week = strtotime("-1 week ") - VIS_TIMEZONE;
                $end_week   = strtotime(date('Y-m-d h:i:s'));
                $filter     = VIS_TABLE_PREFIX . 'ticket.receive_date between "' . $start_week . '" AND "' . $end_week . '" and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0';
                $filter2    = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
                //$filter3    = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $start_week. ' AND ' . $end_week . ' and is_spam=0 and is_deleted=0 and ' . VIS_TABLE_PREFIX . 'ticket.domain_id = ' . $data['domain_id'];
				$filter3 = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$start_week.' AND '.$end_week.' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51)';
				$filter4    = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $start_week . ' AND ' . $end_week .' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'];
            } 
            else if($data['criteria'] == 3) //previous 1 day
            {
				$d   = strtotime("-1 day ") - VIS_TIMEZONE;
                $currentdate = strtotime(date('Y-m-d h:i:s'));
                $filter    = VIS_TABLE_PREFIX . 'ticket.receive_date between "' . $d . '" AND "' . $currentdate . '" and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0';
                $filter2   = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
                //$filter3   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $d . ' AND ' . $currentdate. ' and is_spam=0 and is_deleted=0 and ' . VIS_TABLE_PREFIX . 'ticket.domain_id = ' . $data['domain_id'];
				$filter3 = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$d.' AND '.$currentdate.' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51)';
				$filter4   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $d . ' AND ' . $currentdate .' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'];
            }
            elseif ($data['criteria'] == 4) // custom date range
			{
				$from = strtotime($data['from_date']) - VIS_TIMEZONE;
				$to = strtotime($data['to_date']) - VIS_TIMEZONE;
				$filter    = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0';
                $filter2   = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
                //$filter3   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and is_spam=0 and is_deleted=0 and ' . VIS_TABLE_PREFIX . 'ticket.domain_id = ' . $data['domain_id'];
				$filter3 = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51)';
				$filter4   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to .' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'];
												
			}
			
			if (isset($data['domain_id']) && $data['domain_id'] != 0) 
			{
                if ($data['domain_id'] != 0) {
                    $filter = $filter . " and " . VIS_TABLE_PREFIX . "ticket.domain_id = " . $data['domain_id'];
                }
            } else {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGPLSSELECTDOMAIN'] . '");</script>';
                return false;
            }
           
		   	if(isset($operation['vis_tab']) && $operation['vis_tab']!=1){
            	$graphReport = $object->get_graphical_ticket_overview($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, $data['criteria']);
			}else{
				$report      = $object->get_ticket_overview($filter, $filter2, VIS_STAFF_ID, VIS_LOCATION_AREA, $data['criteria']);
			}
            //include(VIS_PATH_TEMPLATE.'report_overview.php');
        } elseif ($operation['show_report'] == 2 || $data['show_report'] == 2) {
            include(VIS_PATH_TEMPLATE . 'report_list.php');
            return true;
        } elseif ($operation['show_report'] == 3 || $data['show_report'] == 3) {
            include(VIS_PATH_TEMPLATE . 'report_list_graphical.php');
            return true;
        } elseif ($operation['show_report'] == 4) {
            include(VIS_PATH_TEMPLATE . 'download_report.php');
            return true;
        } elseif ($operation['show_report'] == 5) {
            include(VIS_PATH_TEMPLATE . 'itil_report_list.php');
            return true;
        } else {
            $start_week = strtotime("-1 week ");
            $end_week = strtotime(date('Y-m-d h:i:s'));
            $filter      = VIS_TABLE_PREFIX . 'ticket.receive_date between "' . $start_week . '" AND "' . $end_week . '" and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and    is_deleted=0 and ' . VIS_TABLE_PREFIX . 'ticket.domain_id = ' . $domain[0]['domain_id'];
            $filter2     = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
            //$filter3     = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $start_week. ' AND ' . $end_week. ' and '.VIS_TABLE_PREFIX.'client.is_spam=0 and is_deleted=0 and ' . VIS_TABLE_PREFIX . 'ticket.domain_id = ' . $domain[0]['domain_id'];
			$filter3 = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$start_week.' AND '.$end_week.' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51)';
												
			if(isset($operation['vis_tab']) && $operation['vis_tab']!=1){
				 $graphReport = $object->get_graphical_ticket_overview($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, $data['criteria']);
			}else{
$report      = $object->get_ticket_overview($filter, $filter2, VIS_STAFF_ID, VIS_LOCATION_AREA, 2);
			}//check tab
			
            //include(VIS_PATH_TEMPLATE.'report_overview.php');
        }
								
		if((isset($operation['vis_tab']) && $operation['vis_tab']==1) || (!isset($operation['vis_tab']))){
		//code to get avg. response time starts here
		$total_post   = 0;
		$total_ticket = array();
		$total_time   = 0;
		$post_details = array();
		$post_details = $object->get_performance_report($filter3.' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if ($post_details != -1)
			for ($i = 0; $i < count($post_details); $i++) {
				// ===================== Code to calculate timestamp (Starts Here) =====================
				if($post_details[$i]['operation_id']==0){
					$report[$post_details[$i]['ticket_id']]['post_date']=$post_details[$i]['entry_date'];
				}else if($post_details[$i]['operation_id']==50){
					$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
				}else if($post_details[$i]['operation_id']==51){
					$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
					$report[$post_details[$i]['ticket_id']]['slapasue_diff']= $report[$post_details[$i]['ticket_id']]['resume_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
					$report[$post_details[$i]['ticket_id']]['sla_cal_date']=$report[$post_details[$i]['ticket_id']]['sla_cal_date'] + ($report[$post_details[$i]['ticket_id']]['resume_date'] - $report[$post_details[$i]['ticket_id']]['pause_date']);
					$report[$post_details[$i]['ticket_id']]['resume_date']='';
					$report[$post_details[$i]['ticket_id']]['pause_date']='';
				}else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){
					$report[$post_details[$i]['ticket_id']]['post_diff']=($post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date']);
					
					$report[$post_details[$i]['ticket_id']]['maintaint_date']=($post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date']) - ($report[$post_details[$i]['ticket_id']]['sla_cal_date']);
				}
				// ===================== Code to calculate timestamp (Ends Here) =====================
				if($post_details[$i]['reply_forward'] == 1){
					$reply_count = $reply_count+$post_details[$i]['reply_forward'];
				}
				if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
					$report[$post_details[$i]['ticket_id']]['ticket_hash']  = $post_details[$i]['ticket_hash'];
					$report[$post_details[$i]['ticket_id']]['subject']      = $post_details[$i]['subject'];
					$report[$post_details[$i]['ticket_id']]['first_name']      = $post_details[$i]['first_name'];
					$report[$post_details[$i]['ticket_id']]['last_name']      = $post_details[$i]['last_name'];
					$report[$post_details[$i]['ticket_id']]['email']      = $post_details[$i]['email'];
					$report[$post_details[$i]['ticket_id']]['group_name']      = $post_details[$i]['group_name'];
					
					$report[$post_details[$i]['ticket_id']]['timestamp']      = ($post_details[$i]['old_info'] != '' && $post_details[$i]['old_info'] != 0) ? $post_details[$i]['old_info'] - $post_details[$i]['receive_date'] : 0;
					$report[$post_details[$i]['ticket_id']]['ticket_entry'] = $post_details[$i]['ticket_entry'];
					$report[$post_details[$i]['ticket_id']]['start_time']   = $post_details[$i]['receive_date'];
					$report[$post_details[$i]['ticket_id']]['ticket_id']    = $post_details[$i]['ticket_id'];
					
					$report[$post_details[$i]['ticket_id']]['solve_time']     = 0;
					$report[$post_details[$i]['ticket_id']]['count']        = 0;
					
					$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
					$report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = 0;
					if ($post_details[$i]['operator'] == 1)
						$report[$post_details[$i]['ticket_id']]['is_posted'] = false;
					else {
						$report[$post_details[$i]['ticket_id']]['is_posted'] = true;
						$total_post++;
						$total_ticket[$post_details[$i]['ticket_id']] = $post_details[$i]['ticket_id'];
						$total_time = 0;
						$replied[$post_details[$i]['ticket_id']] = 1;
					}
				} elseif ($post_details[$i]['operator'] == 1) {
					$report[$post_details[$i]['ticket_id']]['start_time'] = $post_details[$i]['receive_date'];
				} elseif ($post_details[$i]['operation_id'] == 2) {
					$report[$post_details[$i]['ticket_id']]['solve_time']   = $post_details[$i]['entry_date'];
					$report[$post_details[$i]['ticket_id']]['resolve_time'] = $post_details[$i]['resolution_time'] == 0 ? 0 : ($post_details[$i]['resolution_time'] - $post_details[$i]['entry_date']);
				} elseif($post_details[$i]['old_info'] != '' && $post_details[$i]['old_info'] != 0) {
					$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['start_time']);
					$sla_response_time = round($report[$post_details[$i]['ticket_id']]['maintaint_date']);
					$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = $total_sla_seconds;
					$report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $sla_response_time;
					$report[$post_details[$i]['ticket_id']]['timestamp'] = $sla_response_time;																
					$report[$post_details[$i]['ticket_id']]['count']++;
					$report[$post_details[$i]['ticket_id']]['is_posted'] = true;
					$total_post++;
					$total_ticket[$post_details[$i]['ticket_id']] = $post_details[$i]['ticket_id'];
					$total_time += $sla_response_time;
					$replied[$post_details[$i]['ticket_id']] = 1;
				}
			}
			//code to get avg. response time ends here
			//code to get avg. SLA maintained starts here
			$post_details = array();
			$filters = ' and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1 and ' . VIS_TABLE_PREFIX . 'ticket.resolution_time!=0 and ' . VIS_TABLE_PREFIX . 'ticket.due_time!=0';
			$post_details = $object->get_sla_report($filter.$filters, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$report_avg   = 0;
			$report_cnt   = 0;
			$replied      = array();
			if ($post_details != -1)
				for ($i = 0; $i < count($post_details); $i++) {
					if (!isset($report2[$post_details[$i]['ticket_id']]['start_time'])) {
						$report2[$post_details[$i]['ticket_id']]['start_time']     = $post_details[$i]['entry_date'];
						$report2[$post_details[$i]['ticket_id']]['timestamp']      = ($post_details[$i]['old_info'] != '' && $post_details[$i]['old_info'] != 0) ? $post_details[$i]['old_info'] - $post_details[$i]['receive_date'] : 0;
						$report2[$post_details[$i]['ticket_id']]['ticket_hash']    = $post_details[$i]['ticket_hash'];
						$report2[$post_details[$i]['ticket_id']]['ticket_id']      = $post_details[$i]['ticket_id'];
						$report2[$post_details[$i]['ticket_id']]['status_id']      = $post_details[$i]['status_id'];
						$report2[$post_details[$i]['ticket_id']]['remain_resolve'] = $post_details[$i]['remain_resolve'];
						$report2[$post_details[$i]['ticket_id']]['subject']        = $post_details[$i]['subject'];
						$report2[$post_details[$i]['ticket_id']]['ticket_entry']   = $post_details[$i]['receive_date'];
						$report2[$post_details[$i]['ticket_id']]['count']          = 0;
						$report2[$post_details[$i]['ticket_id']]['resolve_time']   = $post_details[$i]['resolution_time'];
						$report2[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
						$report2[$post_details[$i]['ticket_id']]['used_sla_seconds'] = 0;
							
						if ($post_details[$i]['operator'] == 1) {
							$report2[$post_details[$i]['ticket_id']]['is_posted'] = false;
						} else {
							$report2[$post_details[$i]['ticket_id']]['is_posted'] = true;
							$report_avg += ($post_details[$i]['old_info'] != '' && $post_details[$i]['old_info'] != 0) ? $post_details[$i]['old_info'] - $post_details[$i]['receive_date'] : 0;
							$report_cnt++;
							$totalposts++;
							$replied[$post_details[$i]['ticket_id']] = 1;
						}
					} elseif ($post_details[$i]['operator'] == 1) {
						$report2[$post_details[$i]['ticket_id']]['start_time'] = $post_details[$i]['entry_date'];
					} elseif ($post_details[$i]['operation_id'] == 2) {
						$report2[$post_details[$i]['ticket_id']]['resolve_time'] = $post_details[$i]['resolution_time'] == 0 ? 0 : ($post_details[$i]['resolution_time'] - $post_details[$i]['entry_date']);
					} elseif ($post_details[$i]['old_info'] != '' && $post_details[$i]['old_info'] != 0) {
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report2[$post_details[$i]['ticket_id']]['start_time']);// Total SLA
						$report2[$post_details[$i]['ticket_id']]['total_sla_seconds'] = $total_sla_seconds;
						$report2[$post_details[$i]['ticket_id']]['count']++;
						$report2[$post_details[$i]['ticket_id']]['is_posted'] = true;
						$report_cnt++;
						$totalposts++;
						$replied[$post_details[$i]['ticket_id']] = 1;
					}
				}
													
				foreach ($report2 as $ticket_id => $details) {
					$isUndueSet = 0;
					if (($details['is_posted'] && $details['count'] != 0)) {
						$responseCount++;
					}
					if ($details['resolve_time'] < 0 && $details['status_id'] == 3) {
					} else if (($details['resolve_time'] < 0 || $details['remain_resolve'] < 0) && $details['status_id'] != 3) {
					} else if (($details['resolve_time'] > 0 || $details['remain_resolve'] > 0) && $details['status_id'] != 3) {
					} else {
						$resolutionCount++;
					}
				}
				//code to get avg. SLA maintained ends here 
		} 
								
        elseif((isset($operation['vis_tab']) && $operation['vis_tab']==6))
		{ 	
			list($totalTicksClosed,$post_details,$response_details,$sla_details) = $object->get_staff_leaderboard_report($filter4, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$report_avg      = 0;
            $report_cnt      = 0;
            $resolutionCount = $responseCount = 0;
            $replied         = array();
			$report_details  = array();
			foreach($staff as $key=>$Cdetails){
				$totalclosed = 0;
				$avgFirstresponse=0;
				$avgresponsetime=0;
				$avgresponsesla=0;
				foreach($totalTicksClosed as $key=>$Cntdetails)	
				{
					if($Cdetails['staff_id'] == $Cntdetails['staff_id'])
					{
						$totalclosed=  $Cntdetails['total_ticket_count']; 
					}	
				}	
				$Cdetails['total_ticket_count'] = $totalclosed;
				
				//avg first response time
				for ($i = 0; $i < count($post_details); $i++) {
					if($Cdetails['staff_id'] == $post_details[$i]['submitter_id']) 
					{
						$total_post++;
						$total_time += $post_details[$i]['receive_date'] - $post_details[$i]['ticket_entry'];
						$avgFirstresponse = count_remain_time(round($total_time/$total_post,2)) ;  
					}
				}
				$Cdetails['avgFirstresponse'] =  $avgFirstresponse;
				//avg first response time completed
				
				//avg response time
				for ($i = 0; $i < count($response_details); $i++) {
					if($Cdetails['staff_id'] == $response_details[$i]['submitter_id']){
						if (!isset($reportr[$response_details[$i]['ticket_id']]['start_time'])) {
							$reportr[$response_details[$i]['ticket_id']]['ticket_entry'] = $response_details[$i]['ticket_entry'];
							$reportr[$response_details[$i]['ticket_id']]['start_time']   = $response_details[$i]['receive_date'];
							if ($response_details[$i]['submitter'] == 1)
								$reportr[$response_details[$i]['ticket_id']]['is_posted'] = false;
							else {
								$reportr[$response_details[$i]['ticket_id']]['is_posted'] = true;
								$total_post++;
								$total_ticket[$response_details[$i]['ticket_id']] = $response_details[$i]['ticket_id'];
								$total_time += $response_details[$i]['receive_date'] - $reportr[$response_details[$i]['ticket_id']]['start_time'];
								$avgresponsetime = count_remain_time(round($total_time/$total_post)) ;
							}
						} elseif ($response_details[$i]['submitter'] == 1) {
							$reportr[$response_details[$i]['ticket_id']]['start_time'] = $response_details[$i]['receive_date'];
						} else {
							if($reportr[$response_details[$i]['ticket_id']]['slapause_time']!=''){
								$sla_pause_time = $reportr[$response_details[$i]['ticket_id']]['slapause_time'];
							}else{
								$sla_pause_time = 0;
							}
							$reportr[$response_details[$i]['ticket_id']]['timestamp'] += $response_details[$i]['receive_date'] - $reportr[$response_details[$i]['ticket_id']]['start_time'] - $sla_pause_time;
							$reportr[$response_details[$i]['ticket_id']]['count']++;
							$reportr[$response_details[$i]['ticket_id']]['is_posted'] = true;
							$total_post++;
							$total_ticket[$response_details[$i]['ticket_id']] = $response_details[$i]['ticket_id'];
							$total_time += $response_details[$i]['receive_date'] - $reportr[$response_details[$i]['ticket_id']]['start_time'];
							$avgresponsetime = count_remain_time(round($total_time/$total_post)) ;
						}
					}
				}
				$Cdetails['avgresponsetime'] =  $avgresponsetime;
				//avg response time ends here
					
				//avg sla time starts here
				for ($i = 0; $i < count($sla_details); $i++) {
					if($Cdetails['staff_id'] == $sla_details[$i]['operator_id']){
						if (!isset($reportsr[$sla_details[$i]['ticket_id']]['start_time'])) {
							$reportsr[$sla_details[$i]['ticket_id']]['ticket_entry']   = $sla_details[$i]['receive_date'];
							$reportsr[$sla_details[$i]['ticket_id']]['start_time']     = $sla_details[$i]['entry_date'];
							$reportsr[$sla_details[$i]['ticket_id']]['timestamp']      = ($sla_details[$i]['old_info'] != '' && $sla_details[$i]['old_info'] != 0) ? $sla_details[$i]['old_info'] - $sla_details[$i]['receive_date'] : 0;
						   
							$reportsr[$sla_details[$i]['ticket_id']]['remain_resolve'] = $sla_details[$i]['remain_resolve'];
							$reportsr[$sla_details[$i]['ticket_id']]['resolve_time']   = $sla_details[$i]['resolution_time'];
							$reportsr[$sla_details[$i]['ticket_id']]['solve_time']     = 0;
							
							$reportsr[$sla_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
							$reportsr[$sla_details[$i]['ticket_id']]['used_sla_seconds'] = 0;
								
							if ($sla_details[$i]['operator'] == 1) {
								$reportsr[$sla_details[$i]['ticket_id']]['is_posted'] = false;
							} else {
								$reportsr[$sla_details[$i]['ticket_id']]['is_posted'] = true;
								$report_avg += ($sla_details[$i]['old_info'] != '' && $sla_details[$i]['old_info'] != 0) ? $sla_details[$i]['old_info'] - $sla_details[$i]['receive_date'] : 0;
								$report_cnt++;
								$replied[$sla_details[$i]['ticket_id']] = 1;
								if(($reportsr[$sla_details[$i]['ticket_id']]['is_posted'] && $reportsr[$sla_details[$i]['ticket_id']]['count'] != 0)) 
								{
									$responseCount++;
								}
							 $avgresponsesla = (($report_cnt==0)?0:round((($responseCount/count($reportsr))*100), 2)).'%';
							}
						} elseif ($sla_details[$i]['operator'] == 1) {
							$reportsr[$sla_details[$i]['ticket_id']]['start_time'] = $sla_details[$i]['entry_date'];
						} elseif ($sla_details[$i]['operation_id'] == 2) {
							$reportsr[$sla_details[$i]['ticket_id']]['solve_time']   = $sla_details[$i]['entry_date'];
							$reportsr[$sla_details[$i]['ticket_id']]['resolve_time'] = $sla_details[$i]['resolution_time'] == 0 ? 0 : ($sla_details[$i]['resolution_time'] - $sla_details[$i]['entry_date']);
						} elseif ($sla_details[$i]['old_info'] != '' && $sla_details[$i]['old_info'] != 0) {
							if($reportsr[$sla_details[$i]['ticket_id']]['slapause_time']!=''){
								$sla_pause_time = $reportsr[$sla_details[$i]['ticket_id']]['slapause_time'];
							}else{
								$sla_pause_time = 0;
							}
							// ===================== Code to calculate timestamp (Start) =====================
							$total_sla_seconds = ($post_details[$i]['due_time'] - $reportsr[$sla_details[$i]['ticket_id']]['start_time']);// Total SLA
							$sla_used = $post_details[$i]['entry_date'] - $reportsr[$sla_details[$i]['ticket_id']]['start_time'] - $sla_pause_time;
							$sla_remain = ($total_sla_seconds - $sla_used);// Remaining SLA
							$sla_timestamp = round((($sla_used * 100) / $total_sla_seconds),2);// SLA Timestamp
							
							$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = $total_sla_seconds;
							$report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $sla_used;
							
							$reportsr[$sla_details[$i]['ticket_id']]['timestamp'] += $sla_used;
							// Old Calculations
							//$reportsr[$sla_details[$i]['ticket_id']]['timestamp'] += ($sla_details[$i]['entry_date'] - $reportsr[$sla_details[$i]['ticket_id']]['start_time']) * 100 / ($sla_details[$i]['old_info'] - $reportsr[$sla_details[$i]['ticket_id']]['start_time']);
							// ===================== Code to calculate timestamp (End) =======================
							
							$reportsr[$sla_details[$i]['ticket_id']]['count']++;
							$reportsr[$sla_details[$i]['ticket_id']]['is_posted'] = true;
							$report_avg += $sla_used;
							//$report_avg += ($sla_details[$i]['entry_date'] - $reportsr[$sla_details[$i]['ticket_id']]['start_time']) * 100 / ($sla_details[$i]['old_info'] - $reportsr[$sla_details[$i]['ticket_id']]['start_time']);
							$report_cnt++;
							$replied[$sla_details[$i]['ticket_id']] = 1;
							if (( $reportsr[$sla_details[$i]['ticket_id']]['is_posted'] &&  $reportsr[$sla_details[$i]['ticket_id']]['count'] != 0)) {
								$responseCount++;
							}
							$avgresponsesla = (($report_cnt==0)?0:round((($responseCount/count($reportsr))*100), 2)).'%';
						}
					}
				}
				
				$Cdetails['avgresponsesla'] =  $avgresponsesla;
				$report_details[] = $Cdetails;
			}
		}
		elseif((isset($operation['vis_tab']) && $operation['vis_tab']==7))
		{	
			global $vis_language;
			$database = new class_database();
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
			$tkt_object = new class_ticket($database);
			
			$status_list=$tkt_object->get_status_list('is_enabled=1 and status_id!=3', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$temp_arr = array();
			//$domain     = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'report.php');
			$object=new class_report($database);
			//$staff=$object->get_staff('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
			{
				$filter = $operation['filter'];
				$temp_filtr = explode('#',$filter);
				//print_r($temp_filtr);
				$filter = $temp_filtr[0];
				$filter1= $temp_filtr[1];
				$filter2= $temp_filtr[2];
				$filter3= $temp_filtr[3];
				$temp_filter = $temp_filtr[4];
			} 
			else{
				if($data['department_id']==0){
					$filter = '';
					$filter1='where b.owner_id!=0 and a.department_access!=-1';
					$filter2='';
					$filter3='';
					$temp_filter = '';
				} 
				elseif($data['department_id']!=0)
				{
					$filter = ' and (CASE a.department_access WHEN "-2" then (sg.department_access=0 OR find_in_set('.$data['department_id'].',sg.department_access)) else ( a.department_access=0 OR find_in_set('.$data['department_id'].',a.department_access)) END) and a.department_access!=-1 ';
				
					$filter1=' where  b.owner_id!=0 and (CASE a.department_access WHEN "-2" then (sg.department_access=0 OR find_in_set('.$data['department_id'].',sg.department_access)) else ( a.department_access=0 OR find_in_set('.$data['department_id'].',a.department_access)) END) and a.department_access!=-1 ';
				
					$filter2 = ' where department_id = '.$data['department_id'].' and status_id !=3 ';
					$filter3 =' where c.department_id = '.$data['department_id'];
					$temp_filter = ' and c.department_id = '.$data['department_id'];
				}
			}
			
			list($staff_details,$all_count,$multi_count,$assigned_cnt,$total_tkt_count)=$object->get_ticket_load($temp_filter,$filter,$filter1,$filter2,$filter3,0, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$page = 0;
			$all_cnt = $all_count[0]['all_cnt']-1;
			
			$total_pages = ceil($all_cnt/10);
			  //$page = $page+1;
			$total_tickets = $total_tkt_count['total'];
			$total_assigned = $assigned_cnt['assign_count'];
			
			if($multi_count!=-1){ $mul_count = $multi_count['mul_cnt']; }
			else{ $mul_count = 0; }
			
			if($staff_details!=-1)
			{
				for($i=0;$i<count($staff_details);$i++)
				{
					$temp_arr[$staff_details[$i]['staff_id']]['first_name']= $staff_details[$i]['first_name'];
					$temp_arr[$staff_details[$i]['staff_id']]['last_name']= $staff_details[$i]['last_name'];
					if($staff_details[$i]['assignc'] >= 1){
						$temp_arr[$staff_details[$i]['staff_id']]['assing_cnt']= $temp_arr[$staff_details[$i]['staff_id']]['assing_cnt']+1;
					} else{
						$temp_arr[$staff_details[$i]['staff_id']]['assing_cnt']=0;
					}
					$temp_arr[$staff_details[$i]['staff_id']]['status'][$staff_details[$i]['status_id']]=$temp_arr[$staff_details[$i]['staff_id']]['status'][$staff_details[$i]['status_id']]+1;
				}
			}
			$unassigned_cnt = $total_tickets - $total_assigned;
			
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				sort($temp_arr);
				for($j=0;$j<count($temp_arr);$j++){
					$report_exp[$j]['staff_name'] = $temp_arr[$j]['first_name'].' '.$temp_arr[$j]['last_name'];
					$report_exp[$j]['assigned_tickets'] = $temp_arr[$j]['assing_cnt'];
					for($i=0;$i<count($status_list);$i++)
					{
						$key = $status_list[$i]['status_name'];
						if(array_key_exists($status_list[$i]['status_id'],$temp_arr[$j]['status'])){
							$val= $temp_arr[$j]['status'][$status_list[$i]['status_id']];
						}
						else{
							$val = 0;
						}
						$report_exp[$j][$key]=$val;			  
					}
				}
				if($temp_arr!=-1 && count($temp_arr)>0 ) {  $totalasign = $total_assigned;} else { $totalasign=0; }
				$report_exp[$j]['total_tickets'] = $vis_language['TXTTOTALTICKETS'].": ".$total_tickets;
				$report_exp[$j]['assigned_tickets'] = $vis_language['TXTASSIGNEDTICKETS'].": ".$totalasign;
				$report_exp[$j]['unassigned_tickets'] = $vis_language['TXTTOTALUNASSIGNED'].": ".$unassigned_cnt;
				$report_exp[$j]['multiple_assigned_tickets'] = $vis_language['TXTTOTALMULASSIGNED'].": ".$mul_count;
				$completed_date = date('Y-m-d H:i:s');
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
             	if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
				
                $this->email_send_download($operation);
                return true;
			}
		}
		if(isset($operation['vis_tab'])){
			include(VIS_PATH_TEMPLATE . 'report_overviewstep.php');
		}else{
			include(VIS_PATH_TEMPLATE . 'report_overview.php');
		}
        $database->database_disconnect();
        return true;
    }
	
	function load_more_staff_details($operation)
	{   //print_r($operation);
	    global $vis_language;
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
		
		$status_list=$tkt_object->get_status_list('is_enabled=1 and status_id!=3', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$temp_arr = array();
		$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'report.php');
        $object=new class_report($database);
		
		if($data['department_id']==0){
		$filter = '';
		$filter1='where b.owner_id!=0 and a.department_access!=-1';
		$filter2='';
		$filter3='';
		$temp_filter= '';
		}
		elseif($data['department_id']!=0)
		{
		$filter = ' and (CASE a.department_access WHEN "-2" then (sg.department_access=0 OR find_in_set('.$data['department_id'].',sg.department_access)) else ( a.department_access=0 OR find_in_set('.$data['department_id'].',a.department_access)) END) and a.department_access!=-1 ';
		
		$filter1=' where  b.owner_id!=0 and (CASE a.department_access WHEN "-2" then (sg.department_access=0 OR find_in_set('.$data['department_id'].',sg.department_access)) else ( a.department_access=0 OR find_in_set('.$data['department_id'].',a.department_access)) END) and a.department_access!=-1 ';
		
		$filter2 = ' where department_id = '.$data['department_id'].' and status_id !=3 ';
		$filter3 =' where c.department_id = '.$data['department_id'];
		$temp_filter = ' and c.department_id = '.$data['department_id'];
		}
		
		$page = (isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
		list($staff_details,$all_count,$multi_count,$assigned_cnt,$total_tkt_count)=$object->get_ticket_load($temp_filter,$filter,$filter1,$filter2,$filter3,$page, VIS_STAFF_ID, VIS_LOCATION_AREA);
        
	    //$total_pages = ceil($all_count[0]['all_cnt']/1);
        //$page=$page+1;
		
		$total_tickets = $total_tkt_count['total'];
		$total_assigned = $assigned_cnt['assign_count'];
		
		if($multi_count!=-1){ $mul_count = $multi_count['mul_cnt']; }
		else{ $mul_count = 0; }
		
		if($staff_details!=-1)
		{
		for($i=0;$i<count($staff_details);$i++)
		 {
	    $temp_arr[$staff_details[$i]['staff_id']]['first_name']= $staff_details[$i]['first_name'];
		$temp_arr[$staff_details[$i]['staff_id']]['last_name']= $staff_details[$i]['last_name'];
		if($staff_details[$i]['assignc'] >= 1){
    	$temp_arr[$staff_details[$i]['staff_id']]['assing_cnt']= $temp_arr[$staff_details[$i]['staff_id']]['assing_cnt']+1;
		} else{
		$temp_arr[$staff_details[$i]['staff_id']]['assing_cnt']=0;
		}
        //$total_assigned = $total_assigned+1;
		$temp_arr[$staff_details[$i]['staff_id']]['status'][$staff_details[$i]['status_id']]=$temp_arr[$staff_details[$i]['staff_id']]['status'][$staff_details[$i]['status_id']]+1;
		 }
		}
		$unassigned_cnt = $total_tickets - $total_assigned;
		
		foreach($temp_arr as $report)
		{   
			$html_data = '<tr> <td class="txt_nowrap">'.$report['first_name'].' '.$report['last_name'].'</td><td class="txt_nowrap">'.$report['assing_cnt'].'</td>';
			for($i=0;$i<count($status_list);$i++)
			{   $html_data.= '<td class="txt_nowrap">';
	if(array_key_exists($status_list[$i]['status_id'],$report['status'])){
	$html_data.= $report['status'][$status_list[$i]['status_id']];
	}
	else{
		$html_data.= '0';
	    }
	    $html_data.= '</td>';
			}
        $html_data.= '</tr>';
	    }
		
		echo $html_data;
		
	    //include(VIS_PATH_TEMPLATE . 'report_overviewstep.php');
	}
    
    /**** Staticstics report */
    
    function download_queue_list($operation)
    {
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $database = new class_database();
        $object   = new class_setting($database);
		
        list($info, $modules) = $object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
		foreach ($modules as $var)
            $module[$var['module']] = 1;
        //include('../slaveconfig.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $report_object = new class_report($database);
        if (isset($operation['vis_page']))
            $page = $operation['vis_page'];
        else
            $page = 0;
        $view_info['page_count'] = 10;
        $limit                   = ' limit ' . ($page * $view_info['page_count']) . ',' . $view_info['page_count'];
        list($report_count, $download_list) = $report_object->download_queue_list($limit);
								$downloadcounts=$report_object->download_queue_list_counts('',VIS_STAFF_ID);
        $view_info['page_count'] = ($report_count == 0) ? 0 : ceil($report_count / $view_info['page_count']);
        $view_info['page']       = $page;
        if (!isset($operation['vis_change']))
            include(VIS_PATH_TEMPLATE . 'download_report.php');
        else
            include(VIS_PATH_TEMPLATE . 'download_report_list.php');
    }
    
    function delete_queue_link($operation)
    {
        $message_info['vis_form_title'] = 'Delete Download Queue';
        $message_info['vis_message']    = 'Are you sure you want to delete?';
        $message_info['vis_event']      = "$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'report', 'vis_operation':'delete_download_queue', 'vis_export_id':" . $operation['vis_export_id'] . "})";
        include(VIS_PATH_TEMPLATE . 'confirm_delete.php');
        return true;
    }
    
    function delete_download_queue($operation)
    {
        global $vis_language;
        $database = new class_database();
        //include('../slaveconfig.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $report_object = new class_report($database);
        $delete_report = $report_object->delete_download_queue($operation['vis_export_id']);
        if ($delete_report)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");$("#vis_workpanel_div").visExecution("load_module","' . $vis_language['TXTREPORTS'] . '",{"vis_module":"report", "vis_operation":"download_queue_list"}); </script>';
        
    }
    
    function add_report_inqueue($operation)
    {   
	    global $vis_language;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
								if(isset($operation['report_type']) && $operation['report_type']==14)
								{
									if(isset($operation['vis_filter_id']) && $operation['vis_filter_id']!=0)
								{
										$filter=$ticket_object->get_filter($operation['vis_filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
										if($filter != ""){
											$operation['vis_title']=$filter['filter_name'];
										}
								}
								}
        $message_info['vis_form_title'] = $vis_language['TXTSAVEREPORT'];
        $message_info['vis_message']    = $vis_language['MSGSURE'];
        include(VIS_PATH_TEMPLATE . 'request_report.php');
        return true;
    }
    
    function request_report($data)
    {
		global $vis_language;
        $currentdate = date('Y-m-d h:i:s');
        $database    = new class_database();
        $report_id   = $data['report_type'];
        if ($data['export_filename'] == '') {
            
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGREPORTNAME'] . '"); </script>';
            return false;
        }
       	if ($data['send_email'] == 1) {
			
       	
			
				$char=substr(trim($data['email_id']), -1);
				if($char==',')
				{
					$data['email_id']=substr(trim($data['email_id']), 0, -1);
				}
				$email=array();
				if(strpos($data['email_id'],','))
				{
					$email=explode(',', $data['email_id']);
				}
				else 
				{
					$email[0]= $data['email_id'];
					if((isset($data['email_id']) || trim($data['email_id'])!=''))
					{
						list($message, $flag) = check_email_validation($data['email_id']);
						if(!$flag) {
							echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
							return false;
						} 
					}
				}
				 foreach($email as $key=>$val)
				{
						if(isset($val) && trim($val)!='')
							 {
								list($message, $flag) = check_email_validation($val);
								if(!$flag) {
									echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
									return false;
								} 
							 }
				}
	
			
		 
	}
		
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object  = new class_ticket($database);
        $departments = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        $object_staff = new class_staff($database);
        $staff_filter  = "staff_id =" . VIS_STAFF_ID;
        $staff_details = $object_staff->get_staff($staff_filter, $userid, $user);
        $dept_ids    = '';
        for ($d = 0; $d < count($departments); $d++) {
            $dept_ids .= $departments[$d]['department_id'] . ',';
        }
        if ($dept_ids != '') {
            $dept_ids = substr($dept_ids, 0, -1);
        }
        $dept_id  = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
		
        switch ($report_id) {
            case 1: // Work report
                if ($data['duration'] == 1) //if select Last 30 days duration
				{
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = ' operation_id!=9 AND operation_id<100 AND entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and operator!=1 and operator_id=' . $data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
				{
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = ' operation_id!=9 AND operation_id<100 AND entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and operator!=1 and operator_id=' . $data['staff_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = ' operation_id!=9 AND operation_id<100 AND entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and operator!=1 and operator_id=' . $data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = ' operation_id!=9 AND operation_id<100 and entry_date between ' . $from . ' AND ' . $to . ' and operator!=1 and operator_id=' . $data['staff_id'];
                }
                break;
            case 2: // Department SLA
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'operation_id<=2 and receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.department_id=' . $data['department_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'operation_id<=2 and receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.department_id=' . $data['department_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'operation_id<=2 and receive_date between  ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.department_id=' . $data['department_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'operation_id<=2 and receive_date between ' . $from . ' AND ' . $to . ' and ' . VIS_TABLE_PREFIX . 'ticket.department_id=' . $data['department_id'];
                }
                
                break;
            case 3: // response
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX . 'ticket.department_id=' . $data['department_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX . 'ticket.department_id=' . $data['department_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX . 'ticket.department_id=' . $data['department_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX . 'ticket.department_id=' . $data['department_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                }
                break;
            case 4: // Response
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                }
                break;
            case 6: //Client SLA Report
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'operation_id<=2 and receive_date between  ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'ticket.client_id=' . $data['vis_client_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'operation_id<=2 and receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'ticket.client_id=' . $data['vis_client_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'operation_id<=2 and receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'ticket.client_id=' . $data['vis_client_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'operation_id<=2 and receive_date between ' . $from . ' AND ' . $to . ' and '. VIS_TABLE_PREFIX .'ticket.client_id=' . $data['vis_client_id'];
                }
                break;
            case 7: // Billing Report					
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = ' entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = ' entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = ' entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = ' entry_date between ' . $from . ' AND ' . $to;
                }
                $data['department_id'] = $data['domain_id'];
                break;
            case 8: // Rating Report per department   
               if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'receive_date between  ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $from . ' AND ' . $to . ' and department_id=' . $data['department_id']. ' and avis_customfield_data.content!=" "';
                }
                break;
            case 9: // Time tracking per staff
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'created_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and staff_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'domain.domain_id=' . $data['domain_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'created_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and staff_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'domain.domain_id=' . $data['domain_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and staff_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'domain.domain_id=' . $data['domain_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $from . ' AND ' . $to . ' and staff_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'domain.domain_id=' . $data['domain_id'];
                }
				 $filter .= ' AND  avis_ticket.is_deleted=0 AND avis_ticket.is_spam=0 ';
                break;
            case 10: // Time tracking per department
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'created_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'created_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $from . ' AND ' . $to . ' and department_id=' . $data['department_id'];
                }
                break;
            case 11: // Client Group Tickets
                if ($data['domain_id'] == 0)
                    $domainId = " ";
                else
                    $domainId = ' AND ' . VIS_TABLE_PREFIX . 'client.domain_id = ' . $data['domain_id'];
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'] . ' AND ' . VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $monthDate . ' AND  ' . strtotime($currentdate) . $domainId;
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'] . ' AND ' . VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . $domainId;
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'] . ' AND ' . VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . $domainId;
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'] . ' AND ' . VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from . ' AND ' . $to . $domainId;
                }
                break;
            case 12: //Survey
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'entry_date between ' . $from . ' AND ' . $to;
                }
                $data['department_id'] = $data['survey_id'];
                break;
            case 13: //Client survey
                $filter                = VIS_TABLE_PREFIX . 'customfield_data.parent_id = ' . $data['vis_client_id'] . ' && ' . VIS_TABLE_PREFIX . 'customgroup.location = 4 group by ' . VIS_TABLE_PREFIX . 'customgroup.customgroup_id order by entry_date desc';
                $data['department_id'] = $data['vis_client_id'];
                break;
            case 14: // Ticket
                include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
                $object   = new class_ticket($database);
                $filterid = $data['vis_filter_id'];
                $filter   = $object->get_filter($filterid, VIS_STAFF_ID, VIS_LOCATION_AREA);
                $filter   = $filter['filter'];
                break;
            case 15: // client
                include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
                $object = new class_client($database);
                $filter = $object->get_client('', '', '15', 'report_type', VIS_STAFF_ID, VIS_LOCATION_AREA);
                break;
            case 16: // Rating Report per client
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'receive_date between  ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.client_id=' . $data['vis_client_id'] . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.client_id=' . $data['vis_client_id'] . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_ticket.client_id=' . $data['vis_client_id'] . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $from . ' AND ' . $to . ' and avis_ticket.client_id=' . $data['vis_client_id'] . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_customfield_data.content!=" "';
                }
				$filter .= ' AND avis_ticket.is_spam=0 '; //reject spam from report
                break;
            case 17: // Problem Report
                if ($data['department_id'] == 0) {
                    $department_Id = " ";
                } else
                    $department_Id = " AND FIND_IN_SET (" . $data['department_id'] . ", " . VIS_TABLE_PREFIX . "itil_problems.department_id)>0";
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $from . ' AND ' . $to . $department_Id;
                }
                break;
            case 18: // change report
                if ($data['department_id'] == 0) {
                    $department_Id = " ";
                } else
                    $department_Id = " AND FIND_IN_SET (" . $data['department_id'] . ", " . VIS_TABLE_PREFIX . "itil_changes.department_id)>0";
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $from . ' AND ' . $to . $department_Id;
                }
                break;
            case 19: // release report
                if ($data['department_id'] == 0) {
                    $department_Id = " ";
                } else
                    $department_Id = " AND FIND_IN_SET (" . $data['department_id'] . ", " . VIS_TABLE_PREFIX . "itil_releases.department_id)>0";
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'itil_releases.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'itil_releases.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_releases.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_releases.date_created between unix_timestamp("' . $from . '") AND unix_timestamp("' . $to . '") ' . $department_Id;
                }
                break;
            case 20: // Billing Report					
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = ' entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = ' entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = ' entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = ' entry_date between ' . $from . ' AND ' . $to;
                }
                $data['department_id'] = $data['domain_id'];
                $filter .= ' AND ' . VIS_TABLE_PREFIX . 'invoice.client_id=' . $data['vis_client_id'] . ' AND ' . VIS_TABLE_PREFIX . 'client.domain_id=' . $data['domain_id'];
                break;
            case 21: // Time tracking per Organization
			 	if($data['group_id'] == 0){
					$org_filter = '';
				}else{
					$org_filter = ' AND '. VIS_TABLE_PREFIX .'client.group_id=' . $data['group_id'];	
				}
				
                if ($data['duration'] == 1) //if select Last 30 days duration
                {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
					$group_id = $data['group_id'];
                    $filter    = 'created_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'] . $org_filter;
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'created_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'] . $org_filter;
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'] . $org_filter;
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
					$from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $from . ' AND ' . $to . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'] . $org_filter;
                }
                break;
            case 22: // Time tracking per client
           
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'created_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.client_id=' . $data['vis_client_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'created_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.client_id=' . $data['vis_client_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.client_id=' . $data['vis_client_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $from . ' AND ' . $to . ' and ' . VIS_TABLE_PREFIX . 'ticket.client_id=' . $data['vis_client_id'];
                }
                break;
            
            case 23: //  domain_report
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and domain_id=' . $data['domain_id'].'  and is_deleted=0 and is_spam=0 and draft_id=0';
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and domain_id=' . $data['domain_id'].'  and is_deleted=0 and is_spam=0 and draft_id=0';
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
                    $filter = ' receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and domain_id=' . $data['domain_id'].'  and is_deleted=0 and is_spam=0 and draft_id=0';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $from . ' AND ' . $to . ' and domain_id=' . $data['domain_id'].'  and is_deleted=0 and is_spam=0 and draft_id=0';
                    
                }
                break;
            
            case 24: //first_response_report
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1 and reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $hour          = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $from          = $data['from_date'] - VIS_TIMEZONE;
                    $to            = $data['to_date'] - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                }
                break;
            
            case 25: //Total_response_report
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1 and reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $hour          = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $from          = $data['from_date'] - VIS_TIMEZONE;
                    $to            = $data['to_date'] - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                }
                break;
            
            case 26: //billing_invoice_report
                
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'invoice.entry_date between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 3) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 3) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    $hour          = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 3) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    $from          = $data['from_date'] - VIS_TIMEZONE;
                    $to            = $data['to_date'] - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $from . ' AND ' . $to;
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 3) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                }
                break;
            
            case 27: //order_report
                
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 4) ? '' : $data['status_id'];
                    
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'order.entry_date between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 4) ? '' : $data['status_id'];
                    
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'order.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    $hour          = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'order.entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    $from          = $data['from_date'] - VIS_TIMEZONE;
                    $to            = $data['to_date'] - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'order.entry_date between ' . $from . ' AND ' . $to;
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                }
                break;
            
            case 28: //transaction_report
                
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 4) ? '' : $data['status_id'];
                    
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'balance.entry_date between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 4) ? '' : $data['status_id'];
                    
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'balance.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    $hour          = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'balance.entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
                    $status_id     = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    $from          = $data['from_date'] - VIS_TIMEZONE;
                    $to            = $data['to_date'] - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'balance.entry_date between ' . $from . ' AND ' . $to;
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                }
                break; 
            
             case 29: //client_order_report
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $status_id = ($data['status_id'] == 4) ? '' : $data['status_id'];
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'invoice.entry_date between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    $filter .= ' AND ' . VIS_TABLE_PREFIX . 'client.client_id=' . $data['vis_client_id'];
                    $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $status_id = ($data['status_id'] == 4) ? '' : $data['status_id'];
                    $weekDate  = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    $filter .= ' AND ' . VIS_TABLE_PREFIX . 'client.client_id=' . $data['vis_client_id'];
                    $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $status_id = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    $hour      = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                    $filter .= ' AND ' . VIS_TABLE_PREFIX . 'client.client_id=' . $data['vis_client_id'];
                    $filter .= ($data['status_id'] == 4) ? '' : ' and ' . VIS_TABLE_PREFIX . 'invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $status_id = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    $from      = $data['from_date'] - VIS_TIMEZONE;
                    $to        = $data['to_date'] - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $from . ' AND ' . $to;
                    $filter .= ' AND ' . VIS_TABLE_PREFIX . 'client.client_id=' . $data['vis_client_id'];
                    $filter .= ($data['status_id'] == 4) ? '' : ' and ' . VIS_TABLE_PREFIX . 'invoice.invoice_status=' . $data['status_id'];
                }
                break;
            
            case 30: //client_transaction_report
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $status_id = ($data['status_id'] == 4) ? '' : $data['status_id'];
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'balance.entry_date between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    $filter .= ' AND ' . VIS_TABLE_PREFIX . 'client.client_id=' . $data['vis_client_id'];
                    $filter .= ($data['status_id'] == 4) ? '' : ' and ' . VIS_TABLE_PREFIX . 'invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $status_id = ($data['status_id'] == 4) ? '' : $data['status_id'];
                    $weekDate  = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'balance.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    $filter .= ' AND ' . VIS_TABLE_PREFIX . 'client.client_id=' . $data['vis_client_id'];
                    $filter .= ($data['status_id'] == 4) ? '' : ' and ' . VIS_TABLE_PREFIX . 'invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $status_id = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    $hour      = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'balance.entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                    $filter .= ' AND ' . VIS_TABLE_PREFIX . 'client.client_id=' . $data['vis_client_id'];
                    $filter .= ($data['status_id'] == 4) ? '' : ' and ' . VIS_TABLE_PREFIX . 'invoice.invoice_status=' . $data['status_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    
                    $status_id = ($data['status_id'] == 3) ? '' : $data['status_id'];
                    $from      = $data['from_date'] - VIS_TIMEZONE;
                    $to        = $data['to_date'] - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'balance.entry_date between ' . $from . ' AND ' . $to;
                    $filter .= ' AND ' . VIS_TABLE_PREFIX . 'client.client_id=' . $data['vis_client_id'];
                    $filter .= ($data['status_id'] == 4) ? '' : ' and ' . VIS_TABLE_PREFIX . 'invoice.invoice_status=' . $data['status_id'];
                }
                break; 
            
             case 31: //staff_point_report
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $staff_id  = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'ticket_post.receive_date between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and staff_id=' . $data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and staff_id=' . $data['staff_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $hour     = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and staff_id=' . $data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $from     = $data['from_date'] - VIS_TIMEZONE;
                    $to       = $data['to_date'] - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to;
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and staff_id=' . $data['staff_id'];
                }
                break;
            
            case 32: //staff_bouns_point_report
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $staff_id  = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'selfhelp_article.entry_date between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'selfhelp_article.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $hour     = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'selfhelp_article.entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $from     = $data['from_date'] - VIS_TIMEZONE;
                    $to       = $data['to_date'] - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'selfhelp_article.entry_date between ' . $from . ' AND ' . $to;
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
                }
                break; 
            
             case 33: //quest1_report
                include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
                $object = new class_setting($database);
				$currentdate=date('Y-m-d H:i:s');
                list($quest_info, $questDetails) = $object->get_quest_list('quest_status !=0', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
                foreach ($questDetails as $quest_details) {
                    $quest_start_date = $quest_details['quest_start_date'];
                    $quest_duration   = $quest_details['quest_duration'];
                    //$quest_end_date   = date('Y-m-d H:i:s', strtotime($quest_duration, $quest_start_date));
                }
				 
				$quest_end_date   =  strtotime($quest_duration,$quest_start_date);
                $filter = VIS_TABLE_PREFIX . 'quest.quest_start_date between  ' . $quest_start_date . ' AND ' .$quest_end_date;
                $filter .= ' and avis_quest.quest_id=' . $data['quest_id'] . ' and avis_staff.staff_id=' . $data['staff_id'];
                break;  
            
            case 34: // Deleted Tickets Report
			    if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    if ($data['department_id'] != 0) {
                        $filter = 'entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and a.department_id=' . $data['department_id'];
                    } else {
						$filter =  'entry_date between  '.$monthDate. ' AND '.strtotime($currentdate).' and a.department_id in ('.$dept_id.')';
                        //$filter = 'entry_date between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    }
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    if ($data['department_id'] != 0) {
                        $filter = 'entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and a.department_id=' . $data['department_id'];
                    } else {
						$filter   =  'entry_date between '.$weekDate.' AND '.strtotime($currentdate).' and a.department_id in ('.$dept_id.')';
                       // $filter = 'entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    }
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    if ($data['department_id'] != 0) {
                        $filter = 'entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and a.department_id=' . $data['department_id'];
                    } else {
					 $filter =  'entry_date between '.$hour.' AND '.strtotime($currentdate).' and a.department_id in ('.$dept_id.')';
                        //$filter = 'entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                    }
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from = $data['from_date'] - VIS_TIMEZONE;
                    $to   = $data['to_date'] - VIS_TIMEZONE;
                    if ($data['department_id'] != 0) {
                        $filter = 'entry_date between ' . $from . ' AND ' . $to . ' and a.department_id=' . $data['department_id'];
                    } else {
						$filter = 'entry_date between '.$from.' AND '.$to.' and a.department_id in ('.$dept_id.')';
                       // $filter = 'entry_date between ' . $from . ' AND ' . $to;
                    }
                }
                break;
            case 35: //merged tickets report
			    
                if ($data['staff_id'] != 0) {
                    $filter = 'operator_id=' . $data['staff_id'];
                } else {
                    $filter='a.department_id in'.'('.$dept_id.')' ;
                }
                break; 
            
            case 36: //tickets grouped by channel report
				
                if ($data['department_id'] != 0) {
                    $filter = 'c.channel_id=' . $data['channel_id'] . ' and t.department_id=' . $data['department_id'];
                } else {
                    $filter = 'c.channel_id=' . $data['channel_id'] . ' and t.department_id in (' . $dept_id . ')';
					//$filter = 'c.channel_id=' . $data['channel_id'];
                }
                break;
            case 37: //ITIL - Problems solved per staff report
			    
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and operator_id=' . $data['staff_id'];
                    } else {
                        $filter = 'date_created between  ' . $monthDate . ' AND ' . strtotime($currentdate) .' and p.department_id in'.'('.$dept_id.')';
                    }
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and operator_id=' . $data['staff_id'];
                    } else {
                        $filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) .' and p.department_id in'.'('.$dept_id.')';
                    }
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and operator_id=' . $data['staff_id'];
                    } else {
                        $filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) .' and p.department_id in'.'('.$dept_id.')';
                    }
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from = $data['from_date'] - VIS_TIMEZONE;
                    $to   = $data['to_date'] - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'date_created between ' . $from . ' AND ' . $to . ' and operator_id=' . $data['staff_id'];
                    } else {
                        $filter = 'date_created between ' . $from . ' AND ' . $to .' and p.department_id in'.'('.$dept_id.')';
                    }
                }
                break;
            case 38: // get custom field data report
               if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    if ($data['department_id'] != 0 && $data['field_type'] != 0) {
                        $filter = 't.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and t.department_id=' . $data['department_id'] . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';
                    } else if ($data['department_id'] == 0 && $data['field_type'] != 0) {
                        $filter = 't.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and t.department_id in ' . '(' . $dept_id . ')' . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';
                    } else if ($data['department_id'] != 0 && $data['field_type'] == 0) {
                        $filter = 't.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and t.department_id=' . $data['department_id'].' and cf.is_enabled=1 ';
                    } else {
                        $filter = 't.receive_date between  ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and t.department_id in (' . $dept_id . ')'.' and cf.is_enabled = 1 ';
                    }
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    if ($data['department_id'] != 0 && $data['field_type'] != 0) {
                        $filter = 't.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and t.department_id=' . $data['department_id'] . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';
                    } else if ($data['department_id'] == 0 && $data['field_type'] != 0) {
                        $filter = 't.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and t.department_id in ' . '(' . $dept_id . ')' . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';
                    } else if ($data['department_id'] != 0 && $data['field_type'] == 0) {
                        $filter = 't.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and t.department_id=' . $data['department_id'].' and cf.is_enabled = 1 ';
                    } else {
                        $filter = 't.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and t.department_id in (' . $dept_id . ')'.' and cf.is_enabled = 1 ';
                    }
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    if ($data['department_id'] != 0 && $data['field_type'] != 0) {
                        $filter = 't.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and t.department_id=' . $data['department_id'] . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';
                    } else if ($data['department_id'] == 0 && $data['field_type'] != 0) {
                        $filter = 't.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and t.department_id in ' . '(' . $dept_id . ')' . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';
                    } else if ($data['department_id'] != 0 && $data['field_type'] == 0) {
                        $filter = 't.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and t.department_id=' . $data['department_id'].' and cf.is_enabled = 1 ';
                    } else {
                        $filter = 't.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and t.department_id in (' . $dept_id . ')'.' and cf.is_enabled = 1 ';
                    }
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
						
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    if ($data['department_id'] != 0 && $data['field_type'] != 0) {
                        $filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id=' . $data['department_id'] . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';
                    } else if ($data['department_id'] == 0 && $data['field_type'] != 0) {
                        $filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id in ' . '(' . $dept_id . ')' . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';
                    } else if ($data['department_id'] != 0 && $data['field_type'] == 0) {
                        $filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id=' . $data['department_id'].' and cf.is_enabled = 1 ';
                    }
                    
                    else {
                        $filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id in (' . $dept_id . ')'.' and cf.is_enabled = 1 ';
                    }
                }
                break; 
             case 39: //customfield data report for user registration
                if ($data['userfield_name'] != 0) {
                    $filter = 'cf.field_group=' . $data['userfield_name'];
                }
				break;
            
            
            case 40: //NOt answered ticket
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $from . ' AND ' . $to . ' and department_id=' . $data['department_id'];
                }
                break;
            
            case 41: // Ticket escalation group by staff ownwer
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and staff_id=' . $data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and staff_id=' . $data['staff_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and staff_id=' . $data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $from . ' AND ' . $to . ' and staff_id=' . $data['staff_id'];
                }
                break; 
             case 42: //Ticket escalation group by department
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'department.department_id=' . $data['department_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'department.department_id=' . $data['department_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'department.department_id=' . $data['department_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $from . ' AND ' . $to . ' and ' . VIS_TABLE_PREFIX . 'department.department_id=' . $data['department_id'];
                }
                break;
            case 43 : // total tickets resolved
           								if($data['department_id']!=0){
											$depfilter = ' and '.VIS_TABLE_PREFIX.'ticket.department_id='.$data['department_id'];
										}else{
											$depfilter = '';
										}
										
                                        if($data['duration'] == 1) //if select Last 30 days duration
							            {  
										$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
										$filter =  'operation_id<=2 and receive_date between '.$monthDate.' AND '.strtotime($currentdate).' '.$depfilter;
										}
									    else if($data['duration'] == 2)//if select Last 7 days duration
									    {
											 $weekDate =strtotime("-1 week ") - VIS_TIMEZONE;
											 $filter = 'operation_id<=2 and receive_date between '.$weekDate.' AND '.strtotime($currentdate).' '.$depfilter;
									    }
									    else if($data['duration'] == 3)//if select Last 24 hours duration
									    {
											 $hour=strtotime("-1 day ")- VIS_TIMEZONE;
											 $filter ='operation_id<=2 and receive_date between  '.$hour.' AND '.strtotime($currentdate).' '.$depfilter;
									    }
										 else if($data['duration'] == 4)//if select Custom duration
										 {
										 $from = $data['from_date'] - VIS_TIMEZONE;
										 $to = $data['to_date'] - VIS_TIMEZONE;
										 $filter =  'operation_id<=2 and receive_date between '.$from.' AND '.$to.' '.$depfilter;
							             } 
                                     break;		 
	         case 44:	//login activity
								        if($data['duration'] == 1) //if select Last 30 days duration
				                        {  
										 $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month')- VIS_TIMEZONE;
										 $filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$monthDate.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.module_id=4 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
								        }
										else if($data['duration'] == 2)//if select Last 7 days duration
										{
										$weekDate =strtotime("-1 week ")- VIS_TIMEZONE;
										$filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$weekDate.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.module_id=4 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id']; 
										}
										else if($data['duration'] == 3)//if select Last 24 hours duration
										{
										 $hour=strtotime("-1 day ")- VIS_TIMEZONE;
										 $filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$hour.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.module_id=4 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
										}
										else if($data['duration'] == 4)//if select Custom duration
										{                    
										$from = $data['from_date'] - VIS_TIMEZONE;
										$to = $data['to_date'] - VIS_TIMEZONE;					
										$filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from.' AND '.$to.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.module_id=4 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
										}                                        
										break;
            case 45:	//staff activities
								        if($data['duration'] == 1) //if select Last 30 days duration
				                        {  
										 $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month')- VIS_TIMEZONE;
										 $filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$monthDate.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
								        }
										else if($data['duration'] == 2)//if select Last 7 days duration
										{
										$weekDate =strtotime("-1 week ")- VIS_TIMEZONE;
										$filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$weekDate.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id']; 
										}
										else if($data['duration'] == 3)//if select Last 24 hours duration
										{
										 $hour=strtotime("-1 day ")- VIS_TIMEZONE;
										 $filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$hour.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
										}
										else if($data['duration'] == 4)//if select Custom duration
										{                    
										$from = $data['from_date'] - VIS_TIMEZONE;
										$to = $data['to_date'] - VIS_TIMEZONE;					
										$filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from.' AND '.$to.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
										}                                        
										break;	 
				case 46:	//staff activity search report
					                   if($data['duration'] == 1) //if select Last 30 days duration
										 {  
												 $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month')- VIS_TIMEZONE;
												 $filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$monthDate.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.content like "%'.urldecode($data['vis_new_ticket_list_client']).'%" and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
												 
										 }
										 else if($data['duration'] == 2)//if select Last 7 days duration
										 {
												$weekDate =strtotime("-1 week ")- VIS_TIMEZONE;
												$filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$weekDate.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.content like "%'.urldecode($data['vis_new_ticket_list_client']).'%" and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id']; 
										 }
										 else if($data['duration'] == 3)//if select Last 24 hours duration
										 {
												 $hour=strtotime("-1 day ")- VIS_TIMEZONE;
												 $filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$hour.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.content like "%'.urldecode($data['vis_new_ticket_list_client']).'%" and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
										 }
										 else if($data['duration'] == 4)//if select Custom duration
										 {                    
											$from = $data['from_date'] - VIS_TIMEZONE;
											$to = $data['to_date'] - VIS_TIMEZONE;					
											$filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from.' AND '.$to.' AND '.strtotime($currentdate).' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.content like "%'.urldecode($data['vis_new_ticket_list_client']).'%" and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
										 }	
								                                              
										break;	
                case 47: // average response report
                                         if ($data['duration'] == 1) //if select Last 30 days duration
										{
										$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
										$filter    = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
									} else if ($data['duration'] == 2) //if select Last 7 days duration
										{
										$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
										$filter   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
									} else if ($data['duration'] == 3) //if select Last 24 hours duration
										{
										$hour   = strtotime("-1 day ") - VIS_TIMEZONE;
										$filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
									} else if ($data['duration'] == 4) //if select Custom duration
										{
										$from   = $data['from_date'] - VIS_TIMEZONE;
										$to     = $data['to_date'] - VIS_TIMEZONE;
										$filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
									}
                                    break;					
                             
			    case 48: // client with maximum ticket	
					 if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . "-1 month ") - VIS_TIMEZONE;
						 
                    $filter    = 'avis_ticket.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id group by avis_client.client_id order by ticket_count DESC limit '.$data['maxcount'];
					} else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'avis_ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id group by avis_client.client_id order by ticket_count DESC limit '.$data['maxcount'];
					}
                
					else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
                    $filter = ' avis_ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id group by avis_client.client_id order by ticket_count DESC limit '.$data['maxcount'];
					} else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   =  $data['from_date'] - VIS_TIMEZONE;
                    $to     =  $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'avis_ticket.receive_date between ' . $from . ' AND ' . $to . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id group by avis_client.client_id order by ticket_count DESC limit '.$data['maxcount'];
                    
                }	
				break;
				case 49: // client wth maximum reply ticket
									 
								if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									$filter    = 'avis_ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id  and avis_ticket_post.reply_forward=1 group by avis_client.client_id order by total_ticket_reply_count DESC limit '.$data['maxcount'];
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter   = 'avis_ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id  and avis_ticket_post.reply_forward=1 group by avis_client.client_id order by total_ticket_reply_count DESC limit '.$data['maxcount'];
								}
								
								else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour = strtotime("-1 day ") - VIS_TIMEZONE;
									
									$filter = ' avis_ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id and avis_ticket_post.reply_forward=1 group by avis_client.client_id order by total_ticket_reply_count DESC limit '.$data['maxcount'];
								} else if ($data['duration'] == 4) //if select Custom duration
									{
									$from   =  $data['from_date'] - VIS_TIMEZONE;
									$to     =  $data['to_date'] - VIS_TIMEZONE;
									$filter = 'avis_ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id and avis_ticket_post.reply_forward=1 group by avis_client.client_id order by total_ticket_reply_count DESC limit '.$data['maxcount'];
									
								}
							  break;
									
				case 50://most_commented_article
								 
								/*  if ($data['duration'] == 1) //if select Last 30 days duration
								{
									$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									  $filter    = 'avis_selfhelp_comment.entry_date  between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by article_count DESC limit '.$data['maxcount'];
								} else if ($data['duration'] == 2) //if select Last 7 days duration
								{
									$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter   = 'avis_selfhelp_comment.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by article_count DESC limit '.$data['maxcount'];
								}
                
								else if ($data['duration'] == 3) //if select Last 24 hours duration
								{
									$hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
									$filter = ' avis_selfhelp_comment.entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by article_count DESC limit '.$data['maxcount'];
								} else if ($data['duration'] == 4) //if select Custom duration
								{
									$from   =   $data['from_date']  - VIS_TIMEZONE;
									$to     =   $data['to_date']  - VIS_TIMEZONE;
									$filter = 'avis_selfhelp_comment.entry_date between  ' . $from . ' AND ' . $to . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '    group by avis_selfhelp_article.article_id order by article_count DESC limit '.$data['maxcount'];
                    
								} */
								
								
								break;
				case 51://most_rated_article
				if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                   
					$filter    = 'avis_selfhelp_article.entry_date  between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '  and avis_selfhelp_article.art_likes!=0 and avis_selfhelp_article.is_enabled=1 group by avis_selfhelp_article.article_id  limit '.$data['maxcount'];
				
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                  
				  
					$filter   = 'avis_selfhelp_article.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '  and avis_selfhelp_article.art_likes!=0 and avis_selfhelp_article.is_enabled=1 group by avis_selfhelp_article.article_id  limit '.$data['maxcount'];
				  
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                
				  $filter = ' avis_selfhelp_article.entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '  and avis_selfhelp_article.art_likes!=0 and avis_selfhelp_article.is_enabled=1 group by avis_selfhelp_article.article_id  limit '.$data['maxcount'];
				  
				  
                } else if ($data['duration'] == 4) //if select Custom duration
                {
					// $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
					// $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
					$from   = $data['from_date'] - VIS_TIMEZONE;
					$to     = $data['to_date'] - VIS_TIMEZONE;
					
					$filter = 'avis_selfhelp_article.entry_date between ' . $from . ' AND ' . $to . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '    and avis_selfhelp_article.art_likes!=0 and avis_selfhelp_article.is_enabled=1 group by avis_selfhelp_article.article_id  limit '.$data['maxcount'];
				   
                }
				break;
								
				case 52:// most_view_article
								
				
				
								 if ($data['duration'] == 1) //if select Last 30 days duration
								{
									$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									$filter    = 'avis_selfhelp_article.entry_date  between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by view_count DESC limit '.$data['maxcount'];
								} else if ($data['duration'] == 2) //if select Last 7 days duration
								{
									$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter   = 'avis_selfhelp_article.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by view_count DESC limit '.$data['maxcount'];
								}
                
								else if ($data['duration'] == 3) //if select Last 24 hours duration
								{
									$hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
									$filter = ' avis_selfhelp_article.entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by view_count DESC limit '.$data['maxcount'];
								} else if ($data['duration'] == 4) //if select Custom duration
								{
									$from   = $data['from_date'] - VIS_TIMEZONE;
									$to     = $data['to_date'] - VIS_TIMEZONE;
									$filter = 'avis_selfhelp_article.entry_date between ' . $from . ' AND ' . $to . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '    group by avis_selfhelp_article.article_id order by view_count DESC limit '.$data['maxcount'];
                    
								} break;
				 	case 53: //itil problems group by status    
					            if ($data['duration'] == 1) //if select Last 30 days duration
								{
									$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									if($data['vis_status_condition']==0)
									{
									$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id='.$data['vis_status'];
									}
									else{
									$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
									}
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
									if($data['vis_status_condition']==0)
									{
									$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems. status_id='.$data['vis_status'];
									}
									else{
									$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
									}
									
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour = strtotime("-1 day ") - VIS_TIMEZONE;
									if($data['vis_status_condition']==0)
									{
									$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id='.$data['vis_status'];
									}
									else{
									$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
									}
								   
								}
								 else if ($data['duration'] == 4) //if select Custom duration
									{
									$from = $data['from_date'] - VIS_TIMEZONE;
									$to   = $data['to_date'] - VIS_TIMEZONE;
									if($data['vis_status_condition']==0)
									{
									$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id='.$data['vis_status'];
									}
									else{
									$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
									}
								}
					            break;
					
					case 54: // itil problems group by priority  
					             if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									if($data['vis_priority_condition']==0)
									{
									$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
									}
									else{
									$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
									}
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
									if($data['vis_priority_condition']==0)
									{
									$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
									}
									else{
									$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
									}
									
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour = strtotime("-1 day ") - VIS_TIMEZONE;
									if($data['vis_priority_condition']==0)
									{
									$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
									}
									else{
									$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
									}
								   
								}
								 else if ($data['duration'] == 4) //if select Custom duration
									{
									$from = $data['from_date'] - VIS_TIMEZONE;
									$to   = $data['to_date'] - VIS_TIMEZONE;
									if($data['vis_priority_condition']==0)
									{
									$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
									}
									else{
									$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
									}
								}
					            break;
					
					case 55: // itil problems group by impact
					             if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									if($data['vis_impact_condition']==0)
									{
									$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
									}
									else{
									$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
									}
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
									if($data['vis_impact_condition']==0)
									{
									$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
									}
									else{
									$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
									}
									
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour = strtotime("-1 day ") - VIS_TIMEZONE;
									if($data['vis_impact_condition']==0)
									{
									$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
									}
									else{
									$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
									}
								   
								}
								 else if ($data['duration'] == 4) //if select Custom duration
									{
									$from = $data['from_date'] - VIS_TIMEZONE;
									$to   = $data['to_date'] - VIS_TIMEZONE;
									if($data['vis_impact_condition']==0)
									{
									$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
									}
									else{
									$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
									}
								}
					            break; 
								case 56:   
									 $from   =  $data['from_date'] - VIS_TIMEZONE;
									$filter = 'avis_task.startdate  >' . $from . ' and avis_task_assign.owner_id=' .$data['staff_id'];
									break;
								case 57 :  //overdue_task
									 if ($data['duration'] == 1) //if select Last 30 days duration
											{
											$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
											$staff_id = ($data['staff_id'] == 0) ? '':$data['staff_id'] ;
											$filter =($data['staff_id'] == -2) ? ' INNER JOIN avis_task_assign on avis_task_assign.task_id!=avis_task.task_id ' : ' INNER JOIN avis_task_assign on avis_task_assign.task_id=avis_task.task_id ';
											 $filter .= ' where  avis_task.startdate between ' . $monthDate . ' AND ' . strtotime($currentdate);
											$filter .= ($data['staff_id'] != 0 && $data['staff_id'] != -2) ? ' and avis_task_assign.owner_id=' . $data['staff_id'] : ' ';
											 
											$filter .=" and (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ;
											$filter .=($data['staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM avis_task_assign  where avis_task_assign.task_id = avis_task.task_id)' : '';
										} else if ($data['duration'] == 2) //if select Last 7 days duration
											{
											$staff_id = ($data['staff_id'] == 0) ? '':$data['staff_id'] ;
											$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
											$filter =($data['staff_id'] == -2) ? ' INNER JOIN avis_task_assign on avis_task_assign.task_id!=avis_task.task_id ' : ' INNER JOIN avis_task_assign on avis_task_assign.task_id=avis_task.task_id ';
											$filter  .= ' where avis_task.startdate between ' . $weekDate . ' AND ' . strtotime($currentdate) ;
											$filter .= ($data['staff_id'] != 0 && $data['staff_id'] != -2) ? ' and avis_task_assign.owner_id=' . $data['staff_id'] : ' ';
											$filter.=" and (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ;
											$filter .=($data['staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM avis_task_assign  where avis_task_assign.task_id = avis_task.task_id)' : '';
									   }
										
										else if ($data['duration'] == 3) //if select Last 24 hours duration
											{
											$hour = strtotime("-1 day ") - VIS_TIMEZONE;
											$staff_id = ($data['staff_id'] == 0) ? '':$data['staff_id'] ;
											$filter =($data['staff_id'] == -2) ? ' INNER JOIN avis_task_assign on avis_task_assign.task_id!=avis_task.task_id ' : ' INNER JOIN avis_task_assign on avis_task_assign.task_id=avis_task.task_id ';
											$filter  .= ' where  avis_task.startdate between ' . $hour . ' AND ' . strtotime($currentdate) ;
											$filter .= ($data['staff_id'] != 0 && $data['staff_id'] != -2) ? ' and avis_task_assign.owner_id=' . $data['staff_id'] : ' ';
											$filter.=" and (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ;
											$filter .=($data['staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM avis_task_assign  where avis_task_assign.task_id = avis_task.task_id)' : '';
										} else if ($data['duration'] == 4) //if select Custom duration
											{
											$from   = $data['from_date'] - VIS_TIMEZONE;
											$to     = $data['to_date'] - VIS_TIMEZONE;
											$staff_id = ($data['staff_id'] == 0) ? '':$data['staff_id'] ;
											$filter =($data['staff_id'] == -2) ? ' INNER JOIN avis_task_assign on avis_task_assign.task_id!=avis_task.task_id ' : ' INNER JOIN avis_task_assign on avis_task_assign.task_id=avis_task.task_id ';
										   $filter .= ' where  avis_task.startdate between ' . $from . ' AND ' . $to ;
										   $filter .= ($data['staff_id'] != 0 && $data['staff_id'] != -2) ? ' and avis_task_assign.owner_id=' . $data['staff_id'] : ' ';
										   $filter.=" and (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ; 
										   $filter .=($data['staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM avis_task_assign  where avis_task_assign.task_id = avis_task.task_id)' : '';
										}
								break;

				

                            case 58://assets used by client
							
							
									 $client_email = str_replace("%40","@",$data['vis_usedby']);
				
			             if ($data['asset_name'] != '' && $client_email != '' && $data['vis_ci_type'] != '') {
							$filter = 'cmast.name like "%' . $data['asset_name'].'%" and cmast.usedby like "%'.$client_email.'%" and cmast.ci_type_id = '.$data['vis_ci_type'];
							$filter1 =' where avis_customfield.customgroup_id ='.$data['vis_ci_type']. ' and  avis_itil_cmdb_assets.name="'.$data['asset_name'].'"';
                           }
						   $filter = $filter.'#'.$filter1;
							   
							break;
							
							case 59:
							         if($data['staff_id'] != 0 && $data['vis_ci_type'] != '') {
										if($data['staff_id'] == -2){
											$filter = ' cmast.staff_id = "" and cmast.ci_type_id = '.$data['vis_ci_type'];
										}else{
											$filter = ' cmast.staff_id = '.$data['staff_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'];
										}	
									 }else{
									 	if($data['staff_id'] == -2){
											$filter = ' cmast.staff_id = "" and cmast.ci_type_id = '.$data['vis_ci_type'];
										}else{
											$filter = ' cmast.ci_type_id = '.$data['vis_ci_type'];
										}
									 }
									 
									 if($data['staff_id'] == -2){
									 	$filter1 =' where  avis_customfield.customgroup_id ='.$data['vis_ci_type'].' and  avis_itil_cmdb_assets.staff_id=""';
									 }else{
									 	$filter1 =' where  avis_customfield.customgroup_id ='.$data['vis_ci_type'].' and  avis_itil_cmdb_assets.staff_id='.$data['staff_id'];
									 }
									  
									 $filter = $filter.'#'.$filter1;									  
							break;
								case 60://ticket linking
					     if ($data['duration'] == 1) //if select Last 30 days duration
								{
									$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									$filter    = ' receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and link_type=' .$data['vis_link_type'] . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'];
								} else if ($data['duration'] == 2) //if select Last 7 days duration
								{
									$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter   = 'receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and link_type=' .$data['vis_link_type'] . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'];
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
								{
									$hour   = strtotime("-1 day ") - VIS_TIMEZONE;
									$filter = 'receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and link_type=' .$data['vis_link_type'] . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'];
								} else if ($data['duration'] == 4) //if select Custom duration
								{
									$from   =  $data['from_date'] - VIS_TIMEZONE;
									$to     =  $data['to_date'] - VIS_TIMEZONE;
								  	$filter = ' receive_date between ' . $from . ' AND ' . $to . ' and link_type=' .$data['vis_link_type'] . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'];
								}
						break;
						case 61://task_commented_report
						
						 if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'avis_task_comment.entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_task_comment.owner=' .$data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                     $filter    = 'avis_task_comment.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_task_comment.owner=' .$data['staff_id'];
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
                    $filter    = 'avis_task_comment.entry_date  between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_task_comment.owner=' .$data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   =  $data['from_date'] - VIS_TIMEZONE;
                    $to     =  $data['to_date'] - VIS_TIMEZONE;
                     $filter = 'avis_task_comment.entry_date  between ' . $from . ' AND ' . $to . ' and avis_task_comment.owner=' .$data['staff_id'];
                }
							break;
                        
					case 62: //assets_linkedto_tickets_report
						
						if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != '') {
                    $filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 0 and cmast.ci_type_id = '.$data['vis_ci_type'];
					$filter1 =' where  avis_customfield.customgroup_id ='.$data['vis_ci_type']. ' and  avis_itil_cmdb_assets.assets_id='.$data['vis_asset_id'];
                    }
					$filter = $filter.'#'.$filter1;
					break;
					case 63://ticket_activity
					if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                      $filter    = 'avis_auditlog.entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_auditlog.ticket_hash='.'"' .$data['vis_new_ticket_list_client1'].'"';
					  $filter .= " and avis_auditlog.access_id!=1 and avis_auditlog.access_id!=2 and avis_auditlog.access_id!=3";
					   
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                     $filter    = 'avis_auditlog.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_auditlog.ticket_hash='.'"' .$data['vis_new_ticket_list_client1'].'"';
					 $filter .= " and avis_auditlog.access_id!=1 and avis_auditlog.access_id!=2 and avis_auditlog.access_id!=3";
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
                    $filter    = 'avis_auditlog.entry_date  between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_auditlog.ticket_hash='.'"' .$data['vis_new_ticket_list_client1'].'"';
					$filter .= " and avis_auditlog.access_id!=1 and avis_auditlog.access_id!=2 and avis_auditlog.access_id!=3";
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   =  $data['from_date'] - VIS_TIMEZONE;
                    $to     =  $data['to_date'] - VIS_TIMEZONE;
                     $filter = 'avis_auditlog.entry_date  between ' . $from . ' AND ' . $to . ' and avis_auditlog.ticket_hash='.'"' .$data['vis_new_ticket_list_client1'].'"';
					 $filter .= " and avis_auditlog.access_id!=1 and avis_auditlog.access_id!=2 and avis_auditlog.access_id!=3";
                } 
				 
				break;
				
			case 64: //releases_linkedto_changes_report
						            if ($data['duration'] == 1) //if select Last 30 days duration
										{
										$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									   
										$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 ';
										
									} else if ($data['duration'] == 2) //if select Last 7 days duration
										{
										$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
										if($data['vis_priority_condition']==0)
										
										$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 ';
										
										
									} else if ($data['duration'] == 3) //if select Last 24 hours duration
										{
										$hour = strtotime("-1 day ") - VIS_TIMEZONE;
										if($data['vis_priority_condition']==0)
										
										$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 ';
										
									   
									}
									 else if ($data['duration'] == 4) //if select Custom duration
										{
										$from = $data['from_date'] - VIS_TIMEZONE;
										$to   = $data['to_date'] - VIS_TIMEZONE;
										
										$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 ';
									} 
						    
						break;
						
						case 65: //changes_resolvedby_staff_report
						           
						         if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									if ($data['staff_id'] != 0) {
										$filter = 'c.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and c.staff_id=' . $data['staff_id'];
									} else {
										$filter =  'c.date_created between  '.$monthDate. ' AND '.strtotime($currentdate).' and c.department_id in'.'('.$dept_id.')';

									}
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
									if ($data['staff_id'] != 0) {
										$filter = 'c.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and c.staff_id=' . $data['staff_id'];
									} else {
										$filter   =  'c.date_created between '.$weekDate.' AND '.strtotime($currentdate).' and c.department_id in'.'('.$dept_id.')';

									}
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour = strtotime("-1 day ") - VIS_TIMEZONE;
									if ($data['staff_id'] != 0) {
										$filter = 'c.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and c.staff_id=' . $data['staff_id'];
									} else {
										$filter =  'c.date_created between '.$hour.' AND '.strtotime($currentdate).' and c.department_id in'.'('.$dept_id.')'; 
									  
									}
								} else if ($data['duration'] == 4) //if select Custom duration
									{
									$from = $data['from_date'] - VIS_TIMEZONE;
									$to   = $data['to_date'] - VIS_TIMEZONE;
									if ($data['staff_id'] != 0) {
										$filter = 'c.date_created between ' . $from . ' AND ' . $to . ' and c.staff_id=' . $data['staff_id'];
									} else {
										$filter = 'c.date_created between '.$from.' AND '.$to.' and c.department_id in'.'('.$dept_id.')'; 
									  
									}
								}
						break;
				    case 66: // staff leaderboard report
				                 if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour          = strtotime("-1 day ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 4) //if select Custom duration
								{
									$from          = $data['from_date'] - VIS_TIMEZONE;
									$to            = $data['to_date'] - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} 
				        	break;
					
					case 67: // ticket_replied_by_staff_report
				                 if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=1';
								   
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=1';
								   
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour          = strtotime("-1 day ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=1';
								   
								} else if ($data['duration'] == 4) //if select Custom duration
									{
									$from          = $data['from_date'] - VIS_TIMEZONE;
									$to            = $data['to_date'] - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=1';
								   
								}
					break;
					
					case 68: // ticket_forwarded_by_staff_report
				      if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=2';
								   
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=2';
								   
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour          = strtotime("-1 day ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=2';
								   
								} else if ($data['duration'] == 4) //if select Custom duration
									{
									$from          = $data['from_date'] - VIS_TIMEZONE;
									$to            = $data['to_date'] - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=2';
								   
								}
					break;

	case 69: // ticket_viewed_by_staff_report
				      if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'auditlog.entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'auditlog.operation_id=52 and '.VIS_TABLE_PREFIX.'auditlog.operator_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'auditlog.operator=2';
								   
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'auditlog.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'auditlog.operation_id=52 and '.VIS_TABLE_PREFIX.'auditlog.operator_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'auditlog.operator=2';
								   
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour          = strtotime("-1 day ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'auditlog.entry_date between ' . $hour . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'auditlog.operation_id=52 and '.VIS_TABLE_PREFIX.'auditlog.operator_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'auditlog.operator=2';
								   
								} else if ($data['duration'] == 4) //if select Custom duration
									{
									$from          = $data['from_date'] - VIS_TIMEZONE;
									$to            = $data['to_date'] - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'auditlog.entry_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.operation_id=52 and '.VIS_TABLE_PREFIX.'auditlog.operator_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'auditlog.operator=2';
								   
								}
					break;
	   case 70: //assets_linkedto_problems_report
						  if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != '') {
                    $filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 4 and cmast.ci_type_id = '.$data['vis_ci_type'];
					$filter1 =' where  avis_customfield.customgroup_id ='.$data['vis_ci_type']. ' and  avis_itil_cmdb_assets.assets_id='.$data['vis_asset_id'];
                    }
					$filter = $filter.'#'.$filter1;
					break;
case 71: //assets_groupby_status_report
			  if ($data['status_id'] != -1 && $data['vis_ci_type'] != '') {
								$filter = $data['status_id'].' and '.$data['vis_ci_type']; 
					}
					            			
			break;
					case 72: //assets_groupby_location_report
						  if ($data['location_id'] != -1 && $data['vis_ci_type'] != '') {
						if($data['location_id']!=0){
								$filter = 'cmast.location_id='.$data['location_id'].' and cmast.ci_type_id = '.$data['vis_ci_type']; 
						}else{
								$filter = 'cmast.location_id!='.$data['location_id'].' and cmast.ci_type_id = '.$data['vis_ci_type']; 
						}
						$filter1 =' where avis_customfield.customgroup_id ='.$data['vis_ci_type'];
									
					}
					$filter = $filter.'#'.$filter1;
					break;
 
					
 
					case 73: //THIS ONE  FOR STATUS BY REPORT
							 	if ($data['vis_status'] == 1){
																$filter = VIS_TABLE_PREFIX.'task.task_status=1 and ('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) > 0 ';
													}elseif ($data['vis_status'] == 2){
															$filter = '('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) <= 0 and ('.VIS_TABLE_PREFIX.'task.task_status!=3 and '.VIS_TABLE_PREFIX.'task.task_status!=4)';
													}elseif ($data['vis_status'] == 3){
															$filter = VIS_TABLE_PREFIX.'task.task_status=3';
													}elseif ($data['vis_status'] == 4){
															$filter = VIS_TABLE_PREFIX.'task.task_status=4';
													}elseif ($data['vis_status'] == 5){
															$filter = '('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) > 0 and '.VIS_TABLE_PREFIX.'task.task_status=5';
													} 
													$filter=($filter!='')?$filter.' and '.VIS_TABLE_PREFIX.'task.staff_id='.$data['staff_id']:' '.VIS_TABLE_PREFIX.'task.staff_id='.$data['staff_id'];
							break;
							case 74: //assets_by_asset_type_report
						if ($data['location_id'] != -1) {
				        $filter = 'cmast.ci_type_id='.$data['location_id']; 
						$filter1 =' where  avis_customfield_data.parent_id ='.$data['location_id'];			
				$filter=$filter.'#'.$filter1;
				         }
						  
					break;
					case 75: //assets_by_asset_product_report
					 if ($data['product_id'] != -1 && $data['vendor_id']!=-1 ) {
						 
							  $filter = 'cmast.product_id='.$data['product_id']. ' and cmast.vendor_id='.$data['vendor_id']; 
						
					}
					break;
					case 76: //hardware_assets_by_state_report
						if ($data['asset_id'] != -1) {
						 
							  $filter = 'cmast.assets_state='.$data['asset_id'].' and cmast.ci_type_id=2 '; 
						
					} break;
					case 77: //assets_depreciation_report
						if ($data['depr_type_id'] != -1 && $data['depr_type_id'] != 0) {
						 
					 $filter = ' cmast.depreciation_type='.$data['depr_type_id'].' and cmast.ci_type_id=2 '; 
					}
				if ($data['depr_type_id'] == 0) {
						 
					 $filter = ' cmast.depreciation_type!=0 and cmast.ci_type_id=2 '; 
					} break;
					
					case 78: //assets_depreciation_notification_report
						if ($data['depr_type_id'] != -1 && $data['depr_type_id'] != 0) {
						 
					 $filter = ' cmast.depreciation_type='.$data['depr_type_id'].' and cmast.ci_type_id=2 '; 
					}
				if ($data['depr_type_id'] == 0) {
						 
					 $filter = ' cmast.depreciation_type!=0 and cmast.ci_type_id=2 '; 
					} break;
					 
					 case 79:// ticket load report 
		if($data['department_id']==0){
		$filter = '';
		$filter1='where b.owner_id!=0 and a.department_access!=-1';
		$filter2='';
		$filter3='';
		$temp_filter= '';
		}
		elseif($data['department_id']!=0)
		{
		$filter = ' and (CASE a.department_access WHEN "-2" then (sg.department_access=0 OR find_in_set('.$data['department_id'].',sg.department_access)) else ( a.department_access=0 OR find_in_set('.$data['department_id'].',a.department_access)) END) and a.department_access!=-1 ';
		
		$filter1=' where  b.owner_id!=0 and (CASE a.department_access WHEN "-2" then (sg.department_access=0 OR find_in_set('.$data['department_id'].',sg.department_access)) else ( a.department_access=0 OR find_in_set('.$data['department_id'].',a.department_access)) END) and a.department_access!=-1 ';
		
		$filter2 = ' where department_id = '.$data['department_id'].' and status_id !=3 ';
		$filter3 =' where c.department_id = '.$data['department_id'];
		$temp_filter = ' and c.department_id = '.$data['department_id'];
		}
		$filter = $filter.'#'.$filter1.'#'.$filter2.'#'.$filter3.'#'.$temp_filter;
		
		break;
		
		case 80: //client_report
						if ($data['vis_client_start'] != '') {
										if ($data['domain_id'] != '') {
											$filter = '(email like "' . $data['vis_client_start'] . '%" or first_name like "' . $data['vis_client_start'] . '%") and domain_id=' . $data['domain_id'] . ' and is_spam=0 and is_banned=0 ';
										}else{
											$filter = ' domain_id=' . $data['domain_id'] . ' and is_spam=0 and is_banned=0 '; 
										}
					  }else{
							$filter = ' (email like "%" or first_name like "%") and domain_id=1 and is_spam=0 and is_banned=0 '; 
						}
			break;
			case 81: // Clients by organization
					 
					if ($data['domain_id'] == 0) {
                    $filter = "";
                } else
                     $filter = ' (' . VIS_TABLE_PREFIX . 'client.domain_id = ' . $data['domain_id'].' or ' . VIS_TABLE_PREFIX . 'client.optionB_domain_id = ' . $data['domain_id'].')';
				
				
				if ($data['group_id'] == '0' || $data['group_id'] == ''){
					//$filter    = "";
				}else{
					$filter   .= ($filter!='')?' and '.VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id']:VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'];
				}
					break;
		    case 82:// invoices by organization
				     
                     $domainId = ' AND ' . VIS_TABLE_PREFIX . 'client.domain_id = ' . $data['domain_id'];
					 if ($data['group_id'] == '0' || $data['group_id'] == ''){
					 $groupId    = "";
				     }else{
					 $groupId   = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'].' AND ';
				      }
                     if ($data['duration'] == 1) //if select Last 30 days duration
                     {
                     $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                     $filter    =  $groupId . VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $monthDate . ' AND  ' . strtotime($currentdate) . $domainId;
                     } else if ($data['duration'] == 2) //if select Last 7 days duration
                     {
                     $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                     $filter   =  $groupId . VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . $domainId;
                     } else if ($data['duration'] == 3) //if select Last 24 hours duration
                     {
                     $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                     $filter =  $groupId . VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . $domainId;
                     } else if ($data['duration'] == 4) //if select Custom duration
                     {
                     $from   = $data['from_date'] - VIS_TIMEZONE;
                     $to     = $data['to_date'] - VIS_TIMEZONE;
                     $filter =  $groupId . VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $from . ' AND ' . $to . $domainId;
                     }
			break;
			 case 83: // staff_leaderboard_first_avgresponse_report
				     if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour          = strtotime("-1 day ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 4) //if select Custom duration
								{
									$from          = $data['from_date'] - VIS_TIMEZONE;
									$to            = $data['to_date'] - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from . ' AND ' . $to . ' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} 
				        	break;
					case 84: // staff_leaderboard_avgresponse_report
				                 if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour          = strtotime("-1 day ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 4) //if select Custom duration
								{
									$from          = $data['from_date'] - VIS_TIMEZONE;
									$to            = $data['to_date'] - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} 
				        	break;
							case 85: // staff_leaderboard_avgresponse_maintain_report
				                 if ($data['duration'] == 1) //if select Last 30 days duration
									{
									$monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 2) //if select Last 7 days duration
									{
									$weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 3) //if select Last 24 hours duration
									{
									$hour          = strtotime("-1 day ") - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) .' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} else if ($data['duration'] == 4) //if select Custom duration
								{
									$from          = $data['from_date'] - VIS_TIMEZONE;
									$to            = $data['to_date'] - VIS_TIMEZONE;
									$filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and avis_ticket.domain_id=' . $data['domain_id'];
								   
								} 
				        	break;
							
				case 86: // Overdue Tickets
				if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    if ($data['department_id'] != 0) {
                        $filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and d.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'ticket.is_spam=0 and '.VIS_TABLE_PREFIX . 'ticket.status_id!=3 and is_deleted=0 and due_time!=0 and due_time-unix_timestamp() and user_replied = 1';
                    } else {
						$filter =  VIS_TABLE_PREFIX . 'ticket.receive_date between  '.$monthDate. ' AND '.strtotime($currentdate).' and d.department_id in ('.$dept_id.') and '.VIS_TABLE_PREFIX . 'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX . 'ticket.status_id!=3 and due_time!=0 and due_time-unix_timestamp() and user_replied = 1';
                    }
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    if ($data['department_id'] != 0) {
                        $filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and d.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX . 'ticket.status_id!=3 and due_time!=0 and due_time-unix_timestamp() and user_replied = 1';
                    } else {
						$filter   =  VIS_TABLE_PREFIX . 'ticket.receive_date between '.$weekDate.' AND '.strtotime($currentdate).' and d.department_id in ('.$dept_id.') and '.VIS_TABLE_PREFIX . 'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX . 'ticket.status_id!=3 and due_time!=0 and due_time-unix_timestamp() and user_replied = 1';
                    }
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    if ($data['department_id'] != 0) {
                        $filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and d.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.status_id!=3 and due_time!=0 and due_time-unix_timestamp() and user_replied = 1';
                    } else {
					 $filter =  VIS_TABLE_PREFIX . 'ticket.receive_date between '.$hour.' AND '.strtotime($currentdate).' and d.department_id in ('.$dept_id.') and '.VIS_TABLE_PREFIX . 'ticket.is_spam=0 and is_deleted=0 and due_time!=0 and '.VIS_TABLE_PREFIX.'ticket.status_id!=3 and due_time-unix_timestamp() and user_replied = 1';
                    }
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from = $data['from_date'] - VIS_TIMEZONE;
                    $to   = $data['to_date'] - VIS_TIMEZONE;
                    if ($data['department_id'] != 0) {
                        $filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from . ' AND ' . $to . ' and d.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'ticket.is_spam=0 and is_deleted=0 and due_time!=0 and '.VIS_TABLE_PREFIX.'ticket.status_id!=3 and due_time-unix_timestamp() and user_replied = 1';
                    } else {
						$filter = VIS_TABLE_PREFIX . 'ticket.receive_date between '.$from.' AND '.$to.' and d.department_id in ('.$dept_id.') and '.VIS_TABLE_PREFIX . 'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX . 'ticket.status_id!=3 and due_time!=0 and due_time-unix_timestamp() and user_replied = 1';
                    }
                } 
                break;
				case 87: //undue ticket report
					if ($data['duration'] == 1) //if select Last 30 days duration
					{
						$monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
						if($data['department_id']!='' && $data['department_id']!=0){
							$filter        = ' '.VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'ticket.department_Id='.$data['department_id'];
						}else{ 
							$filter        = ' '.VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate);
						}
					} else if ($data['duration'] == 2) //if select Last 7 days duration
					{
						$weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
						if($data['department_id']!='' && $data['department_id']!=0){
							$filter        = ' '.VIS_TABLE_PREFIX . 'WHERE ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'ticket.department_Id='.$data['department_id'];
						}else{ 
							$filter        = ' '.VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
						}
					} else if ($data['duration'] == 3) //if select Last 24 hours duration
					{
						$hour          = strtotime("-1 day ") - VIS_TIMEZONE;
						if($data['department_id']!='' && $data['department_id']!=0){
							$filter        = ' '.VIS_TABLE_PREFIX . 'WHERE ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) .' and '.VIS_TABLE_PREFIX.'ticket.department_Id='.$data['department_id'];
						}else{ 
							$filter        = ' '.VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate);
						}
					} else if ($data['duration'] == 4) //if select Custom duration
						{
						$from          = $data['from_date'] - VIS_TIMEZONE;
						$to            = $data['to_date'] - VIS_TIMEZONE;
						if($data['department_id']!='' && $data['department_id']!=0){
							$filter        = ' '.VIS_TABLE_PREFIX . 'WHERE ticket.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.department_Id='.$data['department_id'];
						}else{ 
							$filter        = ' '.VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from . ' AND ' . $to;
						}
					}break;
					
					case 88: //ticket_activity_by_department_report
					if ($data['duration'] == 1) //if select Last 30 days duration
												{
												$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
														$filter    = 'avis_auditlog.entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_auditlog.department_id='.$data['department_id'];
														$filter .= " and avis_auditlog.access_id!=1 and avis_auditlog.access_id!=2 and avis_auditlog.access_id!=3";
								} else if ($data['duration'] == 2) //if select Last 7 days duration
												{
												$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
													$filter    = 'avis_auditlog.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_auditlog.department_id='.$data['department_id'] ;
													$filter .= " and avis_auditlog.access_id!=1 and avis_auditlog.access_id!=2 and avis_auditlog.access_id!=3";
								}
								
								else if ($data['duration'] == 3) //if select Last 24 hours duration
												{
												$hour = strtotime("-1 day ") - VIS_TIMEZONE;
												
												$filter    = 'avis_auditlog.entry_date  between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_auditlog.department_id='.$data['department_id'];
												$filter .= " and avis_auditlog.access_id!=1 and avis_auditlog.access_id!=2 and avis_auditlog.access_id!=3";
								} else if ($data['duration'] == 4) //if select Custom duration
												{
												$from   =  $data['from_date'] - VIS_TIMEZONE;
												$to     =  $data['to_date'] - VIS_TIMEZONE;
													$filter = 'avis_auditlog.entry_date  between ' . $from . ' AND ' . $to . ' and avis_auditlog.department_id='.$data['department_id'];
													$filter .= " and avis_auditlog.access_id!=1 and avis_auditlog.access_id!=2 and avis_auditlog.access_id!=3";
								}
								
							break;
		    case 89: //ticket_ci_relation_report
			if ($data['duration'] == 1) //if select Last 30 days duration
			{
			$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
			$filter    = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'ticket.department_id=' . $data['department_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket.draft_id=0 and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=0 ';
			} 
			else if ($data['duration'] == 2) //if select Last 7 days duration
			{
			$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
			$filter   = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'ticket.department_id=' . $data['department_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket.draft_id=0 and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=0 ';
			} 
			else if ($data['duration'] == 3) //if select Last 24 hours duration
			{
			$hour   = strtotime("-1 day ") - VIS_TIMEZONE;
			$filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'ticket.department_id=' . $data['department_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket.draft_id=0 and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=0 ';
			} 
			else if ($data['duration'] == 4) //if select Custom duration
			{
			$from   = strtotime($data['from_date']) - VIS_TIMEZONE;
			$to     = strtotime($data['to_date']) - VIS_TIMEZONE;
			$filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from . ' AND ' . $to . ' and '. VIS_TABLE_PREFIX .'ticket.department_id=' . $data['department_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket.draft_id=0 and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=0 ';
			}
			break;
			
			case 90:// problems ci relation report
			
			if ($data['duration'] == 1) //if select Last 30 days duration
			{
			$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
			$filter    = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'itil_problems.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=4 ';
			} 
			else if ($data['duration'] == 2) //if select Last 7 days duration
			{
			$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
			$filter   = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'itil_problems.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=4 ' ;
			} 
			else if ($data['duration'] == 3) //if select Last 24 hours duration
			{
			$hour   = strtotime("-1 day ") - VIS_TIMEZONE;
			$filter = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'itil_problems.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=4 ';
			} 
			else if ($data['duration'] == 4) //if select Custom duration
			{
			$from   = strtotime($data['from_date']) - VIS_TIMEZONE;
			$to     = strtotime($data['to_date']) - VIS_TIMEZONE;
			$filter = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $from . ' AND ' . $to . ' and '. VIS_TABLE_PREFIX .'itil_problems.department_id=' . $data['department_id'] .' and '.VIS_TABLE_PREFIX . 'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=4 ' ;
			}
			break;
            case 91: // changes ci relation report
			if ($data['duration'] == 1) //if select Last 30 days duration
			{
			$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
			$filter    = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'itil_changes.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'itil_changes.status_id!=3 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=9 ';
			} 
			else if ($data['duration'] == 2) //if select Last 7 days duration
			{
			$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
			$filter   = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'itil_changes.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'itil_changes.status_id!=3 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=9 ' ;
			} 
			else if ($data['duration'] == 3) //if select Last 24 hours duration
			{
			$hour   = strtotime("-1 day ") - VIS_TIMEZONE;
			$filter = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'itil_changes.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'itil_changes.status_id!=3 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=9 ';
			} 
			else if ($data['duration'] == 4) //if select Custom duration
			{
			$from   = strtotime($data['from_date']) - VIS_TIMEZONE;
			$to     = strtotime($data['to_date']) - VIS_TIMEZONE;
			$filter = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $from . ' AND ' . $to . ' and '. VIS_TABLE_PREFIX .'itil_changes.department_id=' . $data['department_id'].' and '.VIS_TABLE_PREFIX . 'itil_changes.status_id!=3 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=9 ';
			}
			break;
		case 92 :// ticket link to task report
			  if ($data['duration'] == 1) //if select Last 30 days duration
			{
			$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
			$filter    = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'ticket.department_id=' . $data['department_id'];
			} 
			else if ($data['duration'] == 2) //if select Last 7 days duration
			{
			$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
			$filter   = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'ticket.department_id=' . $data['department_id'] ;
			} 
			else if ($data['duration'] == 3) //if select Last 24 hours duration
			{
			$hour   = strtotime("-1 day ") - VIS_TIMEZONE;
			$filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '. VIS_TABLE_PREFIX .'ticket.department_id=' . $data['department_id'];
			} 
			else if ($data['duration'] == 4) //if select Custom duration
			{
			$from   = strtotime($data['from_date']) - VIS_TIMEZONE;
			$to     = strtotime($data['to_date']) - VIS_TIMEZONE;
			$filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from . ' AND ' . $to . ' and '. VIS_TABLE_PREFIX .'itil_problems.department_id=' . $data['department_id'];
			}break;
		case 93 :
				if ($data['duration'] == 1) //if select Last 30 days duration

												{

												$monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;

												if ($data['staff_id'] != 0 && $data['field_type'] != 0) {

																$filter = 't.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and st.staff_id=' . $data['staff_id'] . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';

												} else if ($data['staff_id'] == 0 && $data['field_type'] != 0) {

																$filter = 't.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and st.staff_id in ' . '(' . $dept_id . ')' . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';

												} else if ($data['staff_id'] != 0 && $data['field_type'] == 0) {

																$filter = 't.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and st.staff_id=' . $data['staff_id'].' and cf.is_enabled=1 ';

												} else {

																$filter = 't.receive_date between  ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and st.staff_id in ' . '(' . $dept_id . ')'.' and cf.is_enabled = 1 ';

												}

								} else if ($data['duration'] == 2) //if select Last 7 days duration

												{

												$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;

												if ($data['staff_id'] != 0 && $data['field_type'] != 0) {

																$filter = 't.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and st.staff_id=' . $data['staff_id'] . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';

												} else if ($data['staff_id'] == 0 && $data['field_type'] != 0) {

																$filter = 't.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and st.staff_id in ' . '(' . $dept_id . ')' . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';

												} else if ($data['staff_id'] != 0 && $data['field_type'] == 0) {

																$filter = 't.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and st.staff_id=' . $data['staff_id'].' and cf.is_enabled = 1 ';

												} else {

																$filter = 't.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and st.staff_id in ' . '(' . $dept_id . ')'.' and cf.is_enabled = 1 ';

												}

								} else if ($data['duration'] == 3) //if select Last 24 hours duration

												{

												$hour = strtotime("-1 day ") - VIS_TIMEZONE;

												if ($data['staff_id'] != 0 && $data['field_type'] != 0) {

																$filter = 't.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and st.staff_id=' . $data['staff_id'] . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';

												} else if ($data['staff_id'] == 0 && $data['field_type'] != 0) {

																$filter = 't.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and st.staff_id in ' . '(' . $dept_id . ')' . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';

												} else if ($data['staff_id'] != 0 && $data['field_type'] == 0) {

																$filter = 't.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and st.staff_id=' . $data['staff_id'].' and cf.is_enabled = 1 ';

												} else {

																$filter = 't.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and st.staff_id in ' . '(' . $dept_id . ')'.' and cf.is_enabled = 1 ';

												}

								} else if ($data['duration'] == 4) //if select Custom duration

												{

												$from = strtotime($data['from_date']) - VIS_TIMEZONE;

												$to   = strtotime($data['to_date']) - VIS_TIMEZONE;

												if ($data['staff_id'] != 0 && $data['field_type'] != 0) {

																$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and st.staff_id=' . $data['staff_id'] . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';

												} else if ($data['staff_id'] == 0 && $data['field_type'] != 0) {

																$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and st.staff_id in ' . '(' . $dept_id . ')' . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';

												} else if ($data['staff_id'] != 0 && $data['field_type'] == 0) {

																$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and st.staff_id=' . $data['staff_id'].' and cf.is_enabled = 1 ';

												}

												

												else {

																$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and st.staff_id in ' . '(' . $dept_id . ')'.' and cf.is_enabled = 1 ';

												}

								}break;	
		case 94: //customfield data report for organization registration
                if ($data['userfield_name'] != 0) {
                    $filter = 'cf.field_group=' . $data['userfield_name'];
                }
				break;
        case 95: //total ticket closed by staff
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'avis_ticket.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.status_id=3  and '.VIS_TABLE_PREFIX.'auditlog.operator_id='.$data['staff_id'].' and  avis_ticket.department_id=' . $data['department_id'];

                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'avis_ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.status_id=3 and '.VIS_TABLE_PREFIX.'auditlog.operator_id='.$data['staff_id'].' and avis_ticket.department_id=' . $data['department_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'avis_ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_ticket.status_id=3 and '.VIS_TABLE_PREFIX.'auditlog.operator_id='.$data['staff_id'].' and avis_ticket.department_id=' . $data['department_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = $data['from_date'] - VIS_TIMEZONE;
                    $to     = $data['to_date'] - VIS_TIMEZONE;
                    $filter = 'avis_ticket.receive_date between ' . $from . ' AND ' . $to . '  and avis_ticket.status_id=3 and '.VIS_TABLE_PREFIX.'auditlog.operator_id='.$data['staff_id'].' and avis_ticket.department_id=' . $data['department_id'];
                }                
                break;	
		case 96:		
				if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
					$flag_id = ($data['flag_id'] == 0) ? '' : $data['flag_id'];
                    $monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter        = 'receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) .' and avis_staff.staff_id='.$data['staff_id'];
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['flag_id'] != 0) ? ' and avis_ticket.flag_id=' . $data['flag_id'] : '';
					
					} else if ($data['duration'] == 2) //if select Last 7 days duration
						{
						$department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
						$flag_id = ($data['flag_id'] == 0) ? '' : $data['flag_id'];
						$weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
						$filter        = 'receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) .' and avis_staff.staff_id='.$data['staff_id'];
						$filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
						$filter .= ($data['flag_id'] != 0) ? ' and avis_ticket.flag_id=' . $data['flag_id'] : '';						
						
					} else if ($data['duration'] == 3) //if select Last 24 hours duration
						{
						$department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
						$flag_id = ($data['flag_id'] == 0) ? '' : $data['flag_id'];
						$hour          = strtotime("-1 day ") - VIS_TIMEZONE;
						$filter        = 'receive_date between ' . $hour . ' AND ' . strtotime($currentdate) .' and avis_staff.staff_id='.$data['staff_id'];
						$filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
						$filter .= ($data['flag_id'] != 0) ? ' and avis_ticket.flag_id=' . $data['flag_id'] : '';								
						
					} else if ($data['duration'] == 4) //if select Custom duration
						{
						$department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
						$flag_id = ($data['flag_id'] == 0) ? '' : $data['flag_id'];
						$from          = $data['from_date'] - VIS_TIMEZONE;
						$to            = $data['to_date'] - VIS_TIMEZONE;
						$filter        = 'receive_date between ' . $from . ' AND ' . $to .' and avis_staff.staff_id='.$data['staff_id'];
						$filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
						$filter .= ($data['flag_id'] != 0) ? ' and avis_ticket.flag_id=' . $data['flag_id'] : '';							
						
					}					
				break;
				case 97: // client group
                include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
                $object = new class_client($database);
                $filter = $object->get_client_group(' is_enable = 1 ', VIS_STAFF_ID, VIS_LOCATION_AREA,'','report_type','97');
                break;
			
        }
					 
		include('../config.php');
        $username = $database_username;
        $password = $database_password;
        $name     = $database_name;
        
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $object       = new class_setting($database);
        $object_staff = new class_staff($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $report_object = new class_report($database);
        $staff_filter  = "staff_id =" . VIS_STAFF_ID;
        $staff_details = $object_staff->get_staff($staff_filter, $userid, $user);
        $staff_email   = $staff_details[0]['email'];
        list($dpinf, $domain_details) = $object->get_domain(VIS_TABLE_PREFIX . 'domain.domain_id=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain = $domain_details[0]['domain'];
		$toemail=implode(',',$email);
        $result = $report_object->insert_report($data['export_filename'], $domain, $filter, $data['department_id'], $name, $username, $password, $data['report_type'], $staff_email, $data['report_time'], $data['export_type'], $data['send_email'], $toemail, $data['staff_id']); 
        if (!$result)
			 
            return false;
        if (mysql_affected_rows()) {
            $database->database_disconnect();
			
			if($data['vis_static_area']!='export'){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");$(".modal").modal("toggle"); </script>';
		}else{echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");$(".modal").modal("toggle");$("#vis_workpanel_div").visExecution("load_module","' . $vis_language['TXTREPORTS'] . '",{"vis_module":"report", "vis_operation":"download_queue_list"}); </script>';}

        }
        return true;
    }
    

    function client_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTCLIENTOVERVIEW'];
        	if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
				$database = new class_database('mysql', 1);
		else
				$database = new class_database();
								
								$export=1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object   = new class_ticket($database);
        $filter       = VIS_TABLE_PREFIX . 'domain.is_enabled=1 ';
        $domain       = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $clientReport = 1;
        if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
            $data = parse_form_array($operation['vis_action']);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
            }else{
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '"); </script>';
					return false;
				}
				$filter = '(email like "' . $operation['vis_client_start'] . '%" or first_name like "' . $operation['vis_client_start'] . '%") and domain_id=' . $data['domain_id'] . ' and is_spam=0 and is_banned=0 '; // reject ban/spam report
			}
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            $report = $object->get_client_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {							
						if ($key == 'first_name' || $key == 'last_name' || $key == 'client_type' || $key == 'email' || $key == 'contact_number' || $key == 'organization' || $key == 'ticket_count' || $key == 'close_ticket_count' || $key == 'contact_number') {
							$report_exp[$j][$key] = $val;
							$clientType = '';
							if($key=='client_type')
							{
								$clientType = ($report_exp[$j][$key]== 0)?$vis_language['TXTEMAILCLIENT']:$vis_language['TXTCALLCLIENT'];
							}
						}
					}
					$report_exp1[$j]['Client Name']=$report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['Client type']=($report_exp[$j][$key]== 0)?$vis_language['TXTEMAILCLIENT']:$vis_language['TXTCALLCLIENT'];
					$report_exp1[$j]['Email']=$report_exp[$j]['email'];
					$report_exp1[$j]['Contact number']=$report_exp[$j]['contact_number'];
					$report_exp1[$j]['Organizations']=$report_exp[$j]['organization'];
					$report_exp1[$j]['Ticket Count']=$report_exp[$j]['ticket_count'];
					$report_exp1[$j]['Closed Ticket']=$report_exp[$j]['close_ticket_count'];
					$j++;
				}					
				$filename = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
				$report_exp1['Report_title'] = $report_title;
				if ($operation['export_type'] == 1) {
					$export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
					if (file_exists('../downloads/' . $filename . '.csv')) {
									$filename = $filename;
					} else {
									$filename = '';
					}
				} else if ($operation['export_type'] == 2) {
					$export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
					
					if (file_exists('../downloads/' . $filename . '.html')) {
									$filename = $filename;
					} else {
									$filename = '';
					}
				} else if ($operation['export_type'] == 3) {
					$export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
					
					if (file_exists('../downloads/' . $filename . '.xls')) {
									$filename = $filename;
					} else {
									$filename = '';
					}
				}
									
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			}									
            include(VIS_PATH_TEMPLATE . 'client_report.php');
        } 
		else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
		
        $database->database_disconnect();
        return true;
    }
    
     // checking once
    
    function client_group_ticket_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTORGNIZATIONTICKET'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        $export = 1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object        = new class_report($database);
        $tkt_object    = new class_ticket($database);
        $client_object = new class_client($database);
        include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
        $object_client = new client();
        $domain_list   = $object_client->get_domain_access_list();
        $clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA); //get client group list
        $filter        = VIS_TABLE_PREFIX . 'domain.is_enabled=1';
        $domain        = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA); // get domain list
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        $export        = 1;
        if((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['group_id'] == 0 && $data['domain_id'] == "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['group_id'] == 0 && $data['domain_id'] == "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "' . $vis_language['TXTSELECT'] ." ".$vis_language['TXTORGANIZATION']. '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['group_id'] == 0 && $data['domain_id'] != "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECT'] ." ".$vis_language['TXTORGANIZATION']. '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['group_id'] == 0 && $data['domain_id'] != "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                }
                
                else if ($data['duration'] == 0 && $data['group_id'] != 0 && $data['domain_id'] != "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['group_id'] != 0 && $data['domain_id'] == "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['group_id'] != 0 && $data['domain_id'] == "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' .  $vis_language['TXTSELDOMAINFORRES']  .  '" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['group_id'] == 0 && $data['domain_id'] == "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message","' .  $vis_language['TXTSELDOMAINFORRES']  .  '" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }	
                if ($data['domain_id'] == 0) {
                    $domainId = " ";
                } else
                    $domainId = ' AND ' . VIS_TABLE_PREFIX . 'client.domain_id = ' . $data['domain_id'];
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'] . ' AND ' . VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . $domainId;
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'] . ' AND ' . VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . $domainId;
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'] . ' AND ' . VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . $domainId;
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'] . ' AND ' . VIS_TABLE_PREFIX . 'ticket.receive_date between "' . $from . '" AND "' . $to . '"' . $domainId;
                }
            }
            //$filter .= ' and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1 and ' . VIS_TABLE_PREFIX . 'ticket.due_time!=0 ';
			$filter .= ' and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1 ';
            $post_details = $object->get_client_ticket_report1($filter, VIS_STAFF_ID, VIS_LOCATION_AREA); //get client report
  
			if ($post_details != -1)
                for ($i = 0; $i < count($post_details); $i++) {
                    /* if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
                        $report[$post_details[$i]['ticket_id']]['ticket_hash']    = $post_details[$i]['ticket_hash'];
                        $report[$post_details[$i]['ticket_id']]['subject']        = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['first_name']        = $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']        = $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']        = $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']        = $post_details[$i]['group_name'];
                        $report[$post_details[$i]['ticket_id']]['ticket_entry']   = $post_details[$i]['receive_date'];
                        $report[$post_details[$i]['ticket_id']]['start_time']     = $post_details[$i]['entry_date'];
                        $report[$post_details[$i]['ticket_id']]['timestamp']      = ($post_details[$i]['old_info'] != '' && $post_details[$i]['old_info'] != 0) ? $post_details[$i]['old_info'] - $post_details[$i]['receive_date'] : 0;
                        $report[$post_details[$i]['ticket_id']]['ticket_id']      = $post_details[$i]['ticket_id'];
                        $report[$post_details[$i]['ticket_id']]['status_id']      = $post_details[$i]['status_id'];
                        $report[$post_details[$i]['ticket_id']]['remain_resolve'] = $post_details[$i]['remain_resolve'];
                        $report[$post_details[$i]['ticket_id']]['count']          = 0;
                        $report[$post_details[$i]['ticket_id']]['resolve_time']   = $post_details[$i]['resolution_time'];
                        $report[$post_details[$i]['ticket_id']]['status_name']    = $post_details[$i]['status_name'];
                        //$report[$post_details[$i]['ticket_id']]['sla_name']       = $post_details[$i]['sla_name'];
						$report[$post_details[$i]['ticket_id']]['slapause_time']   = $post_details[$i]['slapause_time'];
                        $report[$post_details[$i]['ticket_id']]['solve_time']     = 0;
                        if ($post_details[$i]['operator'] == 1) {
                            $report[$post_details[$i]['ticket_id']]['is_posted'] = false;
                        } else {
                            $report[$post_details[$i]['ticket_id']]['is_posted'] = true;
                            $report_avg += ($post_details[$i]['old_info'] != '' && $post_details[$i]['old_info'] != 0) ? $post_details[$i]['old_info'] - $post_details[$i]['receive_date'] : 0;
                            $report_cnt++;
                            $replied[$post_details[$i]['ticket_id']] = 1;
                        }
                    } elseif ($post_details[$i]['operator'] == 1) {
                        $report[$post_details[$i]['ticket_id']]['start_time'] = $post_details[$i]['entry_date'];
                    } elseif ($post_details[$i]['operation_id'] == 2) {
                        $report[$post_details[$i]['ticket_id']]['solve_time']   = $post_details[$i]['entry_date'];
                        $report[$post_details[$i]['ticket_id']]['resolve_time'] = $post_details[$i]['resolution_time'] == 0 ? 0 : ($post_details[$i]['resolution_time'] - $post_details[$i]['entry_date']);
                    } elseif ($post_details[$i]['old_info'] != '' && $post_details[$i]['old_info'] != 0) {
                        if($report[$post_details[$i]['ticket_id']]['slapause_time']!=''){
							$sla_pause_time = $report[$post_details[$i]['ticket_id']]['slapause_time'];
						}else{
							$sla_pause_time = 0;
						}
						// ===================== Code to calculate timestamp (Start) =====================
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['start_time']);// Total SLA
						// Total SLA Used
						$sla_used = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['start_time'] - $sla_pause_time;
						$sla_remain = ($total_sla_seconds - $sla_used);// Remaining SLA
						$sla_timestamp = round((($sla_used * 100) / $total_sla_seconds),2);// SLA Timestamp
						
						$report[$post_details[$i]['ticket_id']]['timestamp'] += 100 - $sla_timestamp;
						// Old Calculation
						//$report[$post_details[$i]['ticket_id']]['timestamp'] += ($post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['start_time'] - $report[$post_details[$i]['ticket_id']]['slapause_time']) * 100 / ($post_details[$i]['old_info'] - $sla_pause_time);
						// ===================== Code to calculate timestamp (End) =====================
						
                        $report[$post_details[$i]['ticket_id']]['count']++;
                        $report[$post_details[$i]['ticket_id']]['is_posted'] = true;
						$report_avg += $sla_timestamp;
                        //$report_avg += ($post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['start_time'] - $sla_pause_time) * 100 / ($post_details[$i]['old_info'] - $report[$post_details[$i]['ticket_id']]['start_time']);
                        $report_cnt++;
                        $replied[$post_details[$i]['ticket_id']] = 1;
                    } */
					// ===================== Code to calculate timestamp (Starts Here) =====================
					if($post_details[$i]['operation_id']==0){
						$report[$post_details[$i]['ticket_id']]['post_date']=$post_details[$i]['entry_date'];
					}else if($post_details[$i]['operation_id']==50){
						$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
					}else if($post_details[$i]['operation_id']==51){
						$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['slapasue_diff']= $report[$post_details[$i]['ticket_id']]['resume_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
						$report[$post_details[$i]['ticket_id']]['sla_cal_date']=$report[$post_details[$i]['ticket_id']]['sla_cal_date'] + ($report[$post_details[$i]['ticket_id']]['resume_date'] - $report[$post_details[$i]['ticket_id']]['pause_date']);
						$report[$post_details[$i]['ticket_id']]['resume_date']='';
						$report[$post_details[$i]['ticket_id']]['pause_date']='';
					}else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){
						$report[$post_details[$i]['ticket_id']]['post_diff']=($post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date']);
						$report[$post_details[$i]['ticket_id']]['maintaint_date']=($post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date']) - ($report[$post_details[$i]['ticket_id']]['sla_cal_date']);
					}
					// ===================== Code to calculate timestamp (Ends Here) =====================
					if($post_details[$i]['reply_forward'] == 1){
						$reply_count = $reply_count+$post_details[$i]['reply_forward'];
					}
					if(!isset($report[$post_details[$i]['ticket_id']]['start_time'])){
						$report[$post_details[$i]['ticket_id']]['ticket_hash']  = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']      = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['first_name']   = $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']    = $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']      	= $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']   = $post_details[$i]['group_name'];
						
						$report[$post_details[$i]['ticket_id']]['timestamp']    = ($post_details[$i]['old_info'] != '' && $post_details[$i]['old_info'] != 0) ? $post_details[$i]['old_info'] - $post_details[$i]['receive_date'] : 0;
						
						$report[$post_details[$i]['ticket_id']]['ticket_entry'] = $report[$post_details[$i]['ticket_id']]['start_time']   = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']    = $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['solve_time']   = 0;
						$report[$post_details[$i]['ticket_id']]['count']        = 0;
						$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = 0;
						if ($post_details[$i]['operator'] == 1)
							$report[$post_details[$i]['ticket_id']]['is_posted'] = false;
						else {
							$report[$post_details[$i]['ticket_id']]['is_posted'] = true;
							$report_cnt++;
							$total_ticket[$post_details[$i]['ticket_id']] = $post_details[$i]['ticket_id'];
							$report_avg = 0;
							$replied[$post_details[$i]['ticket_id']] = 1;
						}
					} elseif ($post_details[$i]['operator'] == 1) {
						$report[$post_details[$i]['ticket_id']]['start_time'] = $post_details[$i]['receive_date'];
					} elseif ($post_details[$i]['operation_id'] == 2) {
						$report[$post_details[$i]['ticket_id']]['solve_time']   = $post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['resolve_time'] = $post_details[$i]['resolution_time'] == 0 ? 0 : ($post_details[$i]['resolution_time'] - $post_details[$i]['entry_date']);
					} else {
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['start_time']);
						$sla_response_time = round($report[$post_details[$i]['ticket_id']]['maintaint_date']);
						$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = $total_sla_seconds;
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $sla_response_time;
						
						$sla_used = $report[$post_details[$i]['ticket_id']]['maintaint_date'];
						$sla_remain = ($total_sla_seconds - $sla_used);// Remaining SLA
						$sla_timestamp = round((($sla_used * 100) / $total_sla_seconds),2);// SLA Timestamp
						
						$report[$post_details[$i]['ticket_id']]['timestamp'] = 100 - $sla_timestamp;
						$report[$post_details[$i]['ticket_id']]['count']++;
						$report[$post_details[$i]['ticket_id']]['is_posted'] = true;
						$total_ticket[$post_details[$i]['ticket_id']] = $post_details[$i]['ticket_id'];
						$report_cnt++;
						$report_avg += $report[$post_details[$i]['ticket_id']]['timestamp'];
						$replied[$post_details[$i]['ticket_id']] = 1;
					}
				}
			else
				$report = -1;  
			 
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
			    foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'ticket_hash'){
                            $report_exp[$j][$key] =$val;
						} elseif ($key == 'ticket_entry') {
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'subject') {
						    $report_exp[$j][$key] = $val;
                        } elseif ($key == 'first_name') {
						    $report_exp[$j][$key] = $val;
                        } elseif ($key == 'last_name') {
						    $report_exp[$j][$key] = $val;
                        } elseif ($key == 'email') {
						    $report_exp[$j][$key] = $val;
                        } elseif ($key == 'group_name') {
						    $report_exp[$j][$key] = $val;
                        } else if ($key == 'timestamp'){
							if($i['timestamp']<0){
								$show_timestamp = $vis_language['TXTSLA'].' '.strtolower($vis_language['TXTNOTMAINTAIN']);
							}else{
								$show_timestamp = round(($i['timestamp']/$i['count']),2).'%';
							}
							$report_exp[$j][$key]=($i['is_posted'] && $i['count']!=0)? $show_timestamp : 'Not responded';
						} else if($key=='resolve_time'){
							if($val==0){
								$report_exp[$j][$key] = $vis_language['TXTUNDUE'];  
							} else if($val<0 || $i['remain_resolve']<0){
								$report_exp[$j][$key] = $vis_language['TXTOVERDUE'];
							} else{
								$report_exp[$j][$key] = count_remain_time($i['remain_resolve']);
							}
						}
                    }
					$report_exp1[$j]['ticket_hash'] = $report_exp[$j]['ticket_hash']; 
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject']; 
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry']; 
					$report_exp1[$j]['avg_sla'] = $report_exp[$j]['timestamp']; 
					$report_exp1[$j]['resolution_time'] = $report_exp[$j]['resolve_time']; 
					$j++;
				}					
				
				$total_avg_sla = 100 - ($report_avg/$report_cnt);
				$report_exp1[$j]['total_post_count'] = $vis_language['TXTTOTALPOSTCOUNT'].':'. $report_cnt;
				$report_exp1[$j]['total_replied'] = $vis_language['TXTTOTALTICKETREPLIED'].':'.count($replied).'/'.count($report);
				$report_exp1[$j]['total_avg_sla'] = $vis_language['TXTTOTALAVGSLAMAINTAINED'].':'. round($report_avg/$report_cnt, 2).'%';
			   
			   /* for ($i = 0; $i < count($report); $i++) {
                    foreach ($report[$i] as $key => $val) {
                         if ($key == 'ticket_hash' || $key == 'email' || $key == 'receive_date' || $key == 'subject' || $key == 'domain_name' || $key == 'department_name' || $key == 'ticket_priority' || $key == 'ticket_status')
                           
					   $report_exp[$i][$key] = $val;
					  
                    }
                }*/
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
				
                $this->email_send_download($operation);
                return true;
            } 
			else
                include(VIS_PATH_TEMPLATE . 'client_group_tickets.php');
        }
        else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
		
        $database->database_disconnect();
        return true;
    }
    
    /**** Graphical reporting **/
    
    function grapical_report_list($operation)
    {
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        $report = $object->get_report('', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE . 'grapical_report_list.php');
        return true;
    }
    
    function staff_sla_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTSTAFFSLA'];
        $database     = new class_database();
        $export       = 1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object      = new class_ticket($database);
        $staff           = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $getSlaPdf       = 1;
        $graphicalReport = 1;
        $staffSLA        = 1;
        if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
            if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                $data = $operation;
            else
                $data = parse_form_array($operation['vis_action']);
            if (count($data) == 0) {
                include(VIS_PATH_TEMPLATE . 'report_form.php');
                return true;
            }
            $currentdate = date('Y-m-d h:i:s');
            if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '"); </script>';
                return false;
            }
            if ($data['duration'] == 4) {
                list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                if (!$ret) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                    return false;
                }
            }
            if ($data['duration'] == 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '"); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 1) //if select Last 30 days duration
                {
                $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                $filter    = ' operation_id<2 AND entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and old_info!=0 and operator=2 and operator_id=' . $data['staff_id'];
            } else if ($data['duration'] == 2) //if select Last 7 days duration
                {
                $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                $filter   = ' operation_id<2 AND entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and old_info!=0 and operator=2 and operator_id=' . $data['staff_id'];
            } else if ($data['duration'] == 3) //if select Last 24 hours duration
                {
                $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                $filter = ' operation_id<2 AND entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and old_info!=0 and operator=2 and operator_id=' . $data['staff_id'];
            } else if ($data['duration'] == 4) //if select Custom duration
                {
                $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                $filter = ' operation_id<2 and entry_date between ' . $from . ' AND ' . $to . ' and old_info!=0 and operator=2 and operator_id=' . $data['staff_id'];
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object       = new class_report($database);
            $post_details = $object->get_sla_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
            $total        = count($post_details);
            $report       = 0;
            if ($post_details != -1) {
                for ($i = 0; $i < $total; $i++) {
                    if ($post_details[$i]['old_info'] - $post_details[$i]['entry_date'] < 0)
                        $report++;
                }
                $report = $report * 100 / $total;
            }
            include(VIS_PATH_TEMPLATE . 'staff_sla_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function top_performance($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTTOPPERFORMER'];
        $database     = new class_database();
        $export       = 1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object      = new class_ticket($database);
        $departments     = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $getPdf          = 1;
        $canvasDiv       = "#top_performer";
        $pdfTitle        = $vis_language['TXTTOPPERFORMER'];
        $toDisplay       = $vis_language['TXTDEPARTMENT'];
        $graphicalReport = 1;
        if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
            if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                $data = $operation;
            else
                $data = parse_form_array($operation['vis_action']);
            if (count($data) == 0) {
                include(VIS_PATH_TEMPLATE . 'report_form.php');
                return true;
            }
            $staff = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object       = new class_report($database);
            $staff_report = array();
            for ($j = 0; $j < count($staff); $j++) {
                $currentdate = date('Y-m-d h:i:s');
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '"); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '"); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDEPTFORGEN'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['department_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    return false;
                }	 else if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = ' operation_id<2 AND entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and operator=2 and '.VIS_TABLE_PREFIX.'ticket.department_id=' . $data['department_id'] . ' and operator_id=' . $staff[$j]['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = ' operation_id<2 AND entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and operator=2 and '.VIS_TABLE_PREFIX.'ticket.department_id=' . $data['department_id'] . ' and operator_id=' . $staff[$j]['staff_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = ' operation_id<2 AND entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and operator=2 and '.VIS_TABLE_PREFIX.'ticket.department_id=' . $data['department_id'] . ' and operator_id=' . $staff[$j]['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = ' operation_id<2 and entry_date between ' . $from . ' AND ' . $to . ' and operator=2 and '.VIS_TABLE_PREFIX.'ticket.department_id=' . $data['department_id'] . ' and operator_id=' . $staff[$j]['staff_id'];
                }
                $post_details = $object->get_sla_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
                $total        = count($post_details);
                $report       = 0;
                if ($post_details != -1) {
                    for ($i = 0; $i < $total; $i++) {
                        if ($post_details[$i]['old_info'] == 0)
                            $report += 2;
                        else
                            $report += ($post_details[$i]['old_info'] - $post_details[$i]['entry_date'] < 0) ? 1 : 3;
                    }
                    $staff[$j]['level'] = $report;
                } else
                    $staff[$j]['level'] = 0;
            }
            usort($staff, array(
                $this,
                'sortStaffByLevel'
            ));
            include(VIS_PATH_TEMPLATE . 'top_performance.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function channel_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTTICKETBYCHANNEL'];
        $database     = new class_database();
        $export       = 1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object      = new class_ticket($database);
        $getPdf          = 1;
        $canvasDiv       = "#channel_report";
        $pdfTitle        = $vis_language['TXTTICKETBYCHANNEL'];
        $toDisplay       = $vis_language['TXTDEPARTMENT'];
        $graphicalReport = 1;
        $departments     = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
            if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                $data = $operation;
            else
                $data = parse_form_array($operation['vis_action']);
            if (count($data) == 0) {
                include(VIS_PATH_TEMPLATE . 'report_form.php');
                return true;
            }
            $currentdate = date('Y-m-d h:i:s');
            if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '"); </script>';
                return false;
            }
            if ($data['duration'] == 4) {
                list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                if (!$ret) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                    return false;
                }
            }
           if ($data['duration'] == 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '"); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDEPTFORGEN'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['department_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    return false;
                }	 else if ($data['duration'] == 1) //if select Last 30 days duration
                {
                $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                $filter    = ' receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
            } else if ($data['duration'] == 2) //if select Last 7 days duration
                {
                $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                $filter   = ' receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
            } else if ($data['duration'] == 3) //if select Last 24 hours duration
                {
                $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                $filter = ' receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
            } else if ($data['duration'] == 4) //if select Custom duration
                {
                $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                $filter = ' receive_date between ' . $from . ' AND ' . $to . ' and department_id=' . $data['department_id'];
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            $report = $object->get_channel_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
            include(VIS_PATH_TEMPLATE . 'channel_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function department_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTDEPTSTATI'];
        $database     = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object      = new class_ticket($database);
        $domain          = $tkt_object->get_domain(VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $getPdf          = 1;
        $canvasDiv       = "#department_statistics";
        $pdfTitle        = $vis_language['TXTDEPTSTATI'];
        $toDisplay       = $vis_language['TXTDOMAIN'];
        $graphicalReport = 1;
        if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
            if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                $data = $operation;
            else
                $data = parse_form_array($operation['vis_action']);
            if (count($data) == 0) {
                include(VIS_PATH_TEMPLATE . 'report_form.php');
                return true;
            }
            $departments = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.domain_id=' . $data['domain_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            $currentdate = date('Y-m-d h:i:s');
            if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '"); </script>';
                return false;
            }
            if ($data['duration'] == 4) {
                list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                if (!$ret) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                    return false;
                }
            }
           if ($data['duration'] == 0 && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '"); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    return false;
                }	
            if ($data['duration'] == 1) //if select Last 30 days duration
                {
                $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                $filter    = ' receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate);
            } else if ($data['duration'] == 2) //if select Last 7 days duration
                {
                $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                $filter   = ' receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
            } else if ($data['duration'] == 3) //if select Last 24 hours duration
                {
                $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                $filter = ' receive_date between ' . $hour . ' AND ' . strtotime($currentdate);
            } else if ($data['duration'] == 4) //if select Custom duration
                {
                $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                $filter = ' receive_date between ' . $from . ' AND ' . $to;
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            $report = $object->get_department_report($departments, $filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
            include(VIS_PATH_TEMPLATE . 'department_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function rating_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTTKTRATINGS'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object  = new class_ticket($database);
        $departments = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDEPTFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['department_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'receive_date between  ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $from . ' AND ' . $to . ' and department_id=' . $data['department_id']. ' and avis_customfield_data.content!=" "';
                }
            }
            
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            $filter .= ' and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1';
            $report      = $object->get_rating_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA); 
            $custFilter1 = ' (location in (3))  and is_enabled=1 ';
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
            $sett_obj     = new class_setting($database);
            $custom_group = $sett_obj->get_custom_group_list($custFilter1, VIS_STAFF_ID, VIS_LOCATION_AREA);
            
            for ($cnt = 0; $cnt < count($report); $cnt++) {
                $report[$cnt]['feedback'] = $tkt_object->get_custom_fields_id($report[$cnt]['ticket_id']);
            }
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j      = 0;
                foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                        
                        if ($key == 'ticket_hash')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'subject')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'first_name')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'last_name')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'email')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'group_name')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'receive_date')
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						elseif ($key == 'rating')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'content')
                            $report_exp[$j][$key] = $val;
                        
                    }
					
						
					$report_exp1[$j]['ticket_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['created_on'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j]['rating'] = $report_exp[$j]['rating'];
					if($custom_group!= -1){
					$report_exp1[$j]['feedback'] = $report_exp[$j]['content']; }
                    
				$j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
               if (!$result)
                    return false;
                     $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'rating_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function rating_client_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTTICKETRATINGPERCLIENT'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        $export = 1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
        $cli_object = new class_client($database);
        list($clinfo, $clients) = $cli_object->get_client(VIS_TABLE_PREFIX . 'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['vis_client_id'] == '' && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }else if ($data['duration'] != 0 && $data['vis_client_id'] == '' && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }else if ($data['duration'] != 0 && $data['vis_client_id'] != '' && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }else if ($data['duration'] == 0 && $data['vis_client_id'] != '' && $data['domain_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }else if ($data['duration'] == 0 && $data['vis_client_id'] != '' && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }else if ($data['duration'] == 0 && $data['vis_client_id'] == '' && $data['domain_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }else if ($data['duration'] != 0 && $data['vis_client_id'] == '' && $data['domain_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSELCLIENT'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'receive_date between  ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.client_id=' . $data['vis_client_id'] . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.client_id=' . $data['vis_client_id'] . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_ticket.client_id=' . $data['vis_client_id'] . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_customfield_data.content!=" "';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = 'receive_date between ' . $from . ' AND ' . $to . ' and avis_ticket.client_id=' . $data['vis_client_id'] . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_customfield_data.content!=" "';
                }
            }
            $filter .= ' AND avis_ticket.is_spam=0 '; //reject spam from report
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            $report = $object->get_rating_report_per_client($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
            
            $custFilter1 = ' (location in (3))  and is_enabled=1 ';
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
            $sett_obj     = new class_setting($database);
            $custom_group = $sett_obj->get_custom_group_list($custFilter1, VIS_STAFF_ID, VIS_LOCATION_AREA);
            
            for ($cnt = 0; $cnt < count($report); $cnt++) {
                $report[$cnt]['feedback'] = $tkt_object->get_custom_fields_id($report[$cnt]['ticket_id']);
            }
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
                foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                        
                        if ($key == 'ticket_hash')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'subject')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'first_name')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'last_name')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'email')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'group_name')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'receive_date')
                            $report_exp[$j][$key] =  format_datetime_rpt($val,$staff_id);
						elseif ($key == 'rating')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'content')
                            $report_exp[$j][$key] = $val;
                        
                    }
					
						
					$report_exp1[$j]['ticket_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['created_on'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j]['rating'] = $report_exp[$j]['rating'];
					if($custom_group!= -1){
					$report_exp1[$j]['feedback'] = $report_exp[$j]['content']; }
                    
				$j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'rating_report_per_client.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    

    

    function time_tracking_client_report($operation)
    {    
        global $vis_language;
        $report_title = $vis_language['TXTTRACKINGCLIENT'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        $export      = 1;
        $report_type = 22;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object        = new class_report($database);
        $tkt_object    = new class_ticket($database);
        $client_object = new class_client($database);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
                $filter = $operation['filter'];
				$data = $operation;
				$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX . 'domain.domain=' . "'".$data['domain']."'", VIS_STAFF_ID, VIS_LOCATION_AREA);
			    $currency       = $domain_details[0]['currency'];
			}else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['vis_client_id'] == '') {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSELCLIENT'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'created_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.client_id=' . $data['vis_client_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'created_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.client_id=' . $data['vis_client_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.client_id=' . $data['vis_client_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $from . ' AND ' . $to . ' and ' . VIS_TABLE_PREFIX . 'ticket.client_id=' . $data['vis_client_id'];
                }
		    $filter .= ' and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1';
            
             $domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX . 'domain.domain_id=' . $data['domain_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            
			 $currency       = $domain_details[0]['currency'];
            }
            //check amount setting
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
            $object_sett    = new class_setting($database);
            $module_setting = $object_sett->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=' . $domain_details[0]['domain_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            if (empty($module_setting) || $module_setting == -1) {
                $module_setting = $object_sett->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=0', VIS_STAFF_ID, VIS_LOCATION_AREA);
            }
            $amountshowflag = 1;
            if ($module_setting != -1) {
                $amountshowflag = $module_setting[0]['content'];
            }
            //end amount setting check
            
            $total_bill_time = 0;
            $total_work_time = 0;
            $total_amount    = 0;
            $post_details    = $object->get_time_tracking_client_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
            if ($post_details != -1)
                for ($i = 0; $i < count($post_details); $i++) {
					
                    $report[$i]['ticket_hash']     = $post_details[$i]['ticket_hash'];
					 $report[$i]['subject']     = $post_details[$i]['subject'];
                    $report[$i]['ticket_id']       = $post_details[$i]['ticket_id'];
                    $report[$i]['description']     = $post_details[$i]['description'];
					$report[$i]['first_name']     = $post_details[$i]['first_name'];
					$report[$i]['last_name']     = $post_details[$i]['last_name'];
					$report[$i]['email']     = $post_details[$i]['email'];
					$report[$i]['group_name']     = $post_details[$i]['group_name'];
                    $report[$i]['bill_time']       = $post_details[$i]['bill_time'];
                    $report[$i]['work_time']       = $post_details[$i]['work_time'];
                    $report[$i]['amount']          = $post_details[$i]['amount'];
                    $report[$i]['created_date']    = $post_details[$i]['created_date'];
                    $report[$i]['staff_name']      = $post_details[$i]['staff_name'];
                    //$report[$i]['department_name'] = $post_details[$i]['department_name'];
                    $total_bill_time += $post_details[$i]['bill_time'];
                    $total_work_time += $post_details[$i]['work_time'];
                    $total_amount += $post_details[$i]['amount'];
                } else
                $report = -1;
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
			
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
				$min = $vis_language['TXTMIN'];
                foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'ticket_hash')
                            $report_exp[$j][$key] = $val;
						 elseif ($key == 'subject')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'created_date')
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        elseif ($key == 'work_time')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'bill_time')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'amount')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'description')
                            $report_exp[$j][$key] = $val;
                       // elseif ($key == 'department_name')
                            //$report_exp[$j][$key] = $val;
                        elseif ($key == 'staff_name')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'first_name')
                            $report_exp[$j][$key] = $val;
						 elseif ($key == 'last_name')
                            $report_exp[$j][$key] = $val;
						 elseif ($key == 'email')
                            $report_exp[$j][$key] = $val;
						 elseif ($key == 'group_name')
                            $report_exp[$j][$key] = $val;
                    }
					
					$report_exp1[$j]['ticket_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['description'] = $report_exp[$j]['description'];
					$report_exp1[$j]['staff'] =       $report_exp[$j]['staff_name'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['created_on'] = $report_exp[$j]['created_date'];
					//$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['bill_time'.' ('.$min.')'] = $report_exp[$j]['bill_time'];
					$report_exp1[$j]['work_time'.' ('.$min.')'] = $report_exp[$j]['work_time'];
					$report_exp1[$j]['amount'.'('.$currency.')'] = $report_exp[$j]['amount'];
                    $j++;
                }
                $report_exp1[$j]['ticket_hash'] = '';
				$report_exp1[$j]['description'] = '';
				$report_exp1[$j]['staff'] ='';
                $report_exp1[$j]['created_on'] = ''; //Total
				$report_exp1[$j]['total_bill_time']   = $vis_language['TXTTOTALBILLTIME'].":". $total_bill_time . ' ' . $vis_language['TXTMIN'];
                $report_exp1[$j]['total_work_time']   = $vis_language['TXTTOTALWORKTIME'].":". $total_work_time . ' ' . $vis_language['TXTMIN'];
               
                $report_exp1[$j]['total_amount']      = $vis_language['TXTTOTALAMOUNT'].":". number_format($total_amount) . ' ' . $currency;
                
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                 if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
																if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'time_tracking_report.php');
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    function time_tracking_organization_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTTRACKINGORG'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        $export      = 1;
        $report_type = 21;
        
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object        = new class_report($database);
        $tkt_object    = new class_ticket($database);
        $client_object = new class_client($database);
        include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
        $object_client = new client();
        $domain_list   = $object_client->get_domain_access_list();
        $clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA); //get client group list
        $filter        = VIS_TABLE_PREFIX . 'domain.is_enabled=1';
        $domain        = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA); // get domain list
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
                $filter = $operation['filter'];
				$data = $operation;
				$temp_filter = explode("domain_id=",$filter);
                $dom_id = $temp_filter[1];			 
			    $domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX . 'domain.domain_id=' . $dom_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
			    $currency       = $domain_details[0]['currency'];
			}else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
					
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
				if ($data['duration'] == 0 && $data['group_id'] == -1 && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['group_id'] == -1 && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "' . $vis_language['TXTSELECT'] ." ".$vis_language['TXTORGANIZATION']. '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['group_id'] == -1 && $data['domain_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECT'] ." ".$vis_language['TXTORGANIZATION']. '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['group_id'] == -1 && $data['domain_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['group_id'] != -1 && $data['domain_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['group_id'] != -1 && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['group_id'] != -1 && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' .  $vis_language['TXTSELDOMAINFORRES']  .  '" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['group_id'] == -1 && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message","' .  $vis_language['TXTSELDOMAINFORRES']  .  '" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if($data['group_id'] == 0)
				{
					$org_filter = '';
				}
                else
				{
					$org_filter = ' AND '. VIS_TABLE_PREFIX .'client.group_id=' . $data['group_id'];	
				}
                					
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
					$group_id = $data['group_id'];
                    $filter    = 'created_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'] . $org_filter;
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'created_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'] . $org_filter;
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'] . $org_filter;
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = 'created_date between ' . $from . ' AND ' . $to . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'] . $org_filter;
                }
		    
				$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX . 'domain.domain_id=' . $data['domain_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            	$currency       = $domain_details[0]['currency'];
            }
            $filter .= ' and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1';
            
            //check amount setting
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
            $object_sett    = new class_setting($database);

            $module_setting = $object_sett->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=' . $domain_details[0]['domain_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            if (empty($module_setting) || $module_setting == -1) {
                $module_setting = $object_sett->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=0', VIS_STAFF_ID, VIS_LOCATION_AREA);
            }
            $amountshowflag = 1;
            if ($module_setting != -1) {
                $amountshowflag = $module_setting[0]['content'];
            }
            //end amount setting check
            
            $total_bill_time = 0;
            $total_work_time = 0;
            $total_amount    = 0;
            
            $post_details = $object->get_time_tracking_organization_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
            if ($post_details != -1)
                for ($i = 0; $i < count($post_details); $i++) {
                    $report[$i]['ticket_hash']     = $post_details[$i]['ticket_hash'];
					$report[$i]['subject']       = $post_details[$i]['subject'];
                    $report[$i]['ticket_id']       = $post_details[$i]['ticket_id'];
                    $report[$i]['description']     = $post_details[$i]['description'];
					$report[$i]['first_name']     = $post_details[$i]['first_name'];
					$report[$i]['last_name']     = $post_details[$i]['last_name'];
					$report[$i]['email']     = $post_details[$i]['email'];
					$report[$i]['group_name']     = $post_details[$i]['group_name'];
                    $report[$i]['bill_time']       = $post_details[$i]['bill_time'];
                    $report[$i]['work_time']       = $post_details[$i]['work_time'];
                    $report[$i]['amount']          = $post_details[$i]['amount'];
                    $report[$i]['created_date']    = $post_details[$i]['created_date'];
                    $report[$i]['staff_name']      = $post_details[$i]['staff_name'];
                   // $report[$i]['department_name'] = $post_details[$i]['department_name'];
                    $total_bill_time += $post_details[$i]['bill_time'];
                    $total_work_time += $post_details[$i]['work_time'];
                    $total_amount += $post_details[$i]['amount'];
                } else
                $report = -1;
				
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
				$j      = 0;
				$min = $vis_language['TXTMIN'];
                foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'ticket_hash')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'subject')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'created_date')
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        elseif ($key == 'work_time')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'bill_time')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'amount')
                              $report_exp[$j][$key] = $val; 
                        elseif ($key == 'description')
                            $report_exp[$j][$key] = $val;
                        //elseif ($key == 'department_name')
                           // $report_exp[$j][$key] = $val;
                        elseif ($key == 'staff_name')
                            $report_exp[$j][$key] = $val;
						elseif ($key == 'first_name')
                            $report_exp[$j][$key] = $val;
						 elseif ($key == 'last_name')
                            $report_exp[$j][$key] = $val;
						 elseif ($key == 'email')
                            $report_exp[$j][$key] = $val;
						 elseif ($key == 'group_name')
                            $report_exp[$j][$key] = $val;
                    }
					
					$report_exp1[$j]['ticket_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['description'] = $report_exp[$j]['description'];
					$report_exp1[$j]['staff'] = $report_exp[$j]['staff_name'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['created_on'] = $report_exp[$j]['created_date'];
					//$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['bill_time'.' ('.$min.')'] = $report_exp[$j]['bill_time'];
					$report_exp1[$j]['work_time'.' ('.$min.')'] = $report_exp[$j]['work_time'];
					$report_exp1[$j]['amount'.' ('.$currency.')'] = $report_exp[$j]['amount'];
					
                    $j++;
                }
                $report_exp1[$j]['ticket_hash'] = '';
				$report_exp1[$j]['subject'] = '';
				$report_exp1[$j]['description'] = '';
				$report_exp1[$j]['staff'] = '';	
				$report_exp1[$j]['client_name'] = '';
				$report_exp1[$j]['email'] = '';	
				$report_exp1[$j]['organization'] = '';			
                $report_exp1[$j]['created_on']  = '';
				$report_exp1[$j]['bill_time']   = $vis_language['TXTTOTALBILLTIME'].":".$total_bill_time . ' ' . $vis_language['TXTMIN'];
                $report_exp1[$j]['work_time']   = $vis_language['TXTTOTALWORKTIME'].":".$total_work_time . ' ' . $vis_language['TXTMIN'];
                $report_exp1[$j]['amount']      = $vis_language['TXTTOTALAMOUNT'].":".$total_amount . ' ' . $currency;
                
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                 if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'time_tracking_report.php');
            
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    

    
    function sortStaffByLevel($a, $b)
    {
        if ($a['level'] == $b['level'])
            return 0;
        if ($a['level'] > $b['level'])
            return -1;
        return 1;
    }
    
    function display_reportOverview()
    {
        include(VIS_PATH_TEMPLATE . 'report_overview.php');
    }
    
    function generateUniqueHexColors($quantity = 10)
    {
        if ($quantity >= (254 * 254 * 254)) {
            return false;
        }
        $colors   = array();
        $quantity = (intval($quantity) == 0) ? 1 : intval($quantity);
        for ($i = 0; $i < $quantity; $i++) {
            $color = sprintf("%02X%02X%02X", mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
            while (in_array($color, $colors)) {
                $color = sprintf("%02X%02X%02X", mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
            }
            $colors[] = "#" . $color;
        }
        return $colors;
    }
    
    function graphical_report($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object      = new class_ticket($database);
        $getGraphPdf     = 1;
        $canvasDiv       = "#channel_report";
        $pdfTitle        = $vis_language['TXTCHANNEL'];
        $toDisplay       = $vis_language['TXTDEPARTMENT'];
        $graphicalReport = 1;
        $departments     = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
            $criteriaArr = explode("/", $operation['vis_action']);
            $criteria    = $criteriaArr[3];
			$criteria1   = $criteriaArr[4];
            /*if (urldecode($criteria) == $vis_language['TXTTICKSBYSTATUS']) {
                $pdfTitle  = $report_title = $vis_language['TXTTICKSBYSTATUS'];
                $graphDiv  = 'status_sparkline';
                $graphOpts = 'statusOps';
            } elseif (urldecode($criteria) == $vis_language['TXTTICKETSBYPRIORITIES']) {
                $pdfTitle  = $report_title = $vis_language['TXTTICKETSBYPRIORITIES'];
                $graphDiv  = 'priorities_sparkline';
                $graphOpts = 'priorityOps';
            } elseif (urldecode($criteria) == $vis_language['TXTTICKETSBYTYPE']) {
                $pdfTitle  = $report_title = $vis_language['TXTTICKETSBYTYPE'];
                $graphDiv  = 'types_sparkline';
                $graphOpts = 'typesOps';
            } elseif (urldecode($criteria) == $vis_language['TXTTICKETSBYLABEL']) {
                $pdfTitle  = $report_title = $vis_language['TXTTICKETSBYLABEL'];
                $graphDiv  = 'label_sparkline';
                $graphOpts = 'labelOps';
            }*/
			if ($criteria1 == 1) {
                $pdfTitle  = $report_title = $vis_language['TXTTICKSBYSTATUS'];
                $graphDiv  = 'status_sparkline';
                $graphOpts = 'statusOps';
            } elseif ($criteria1 == 2) {
                $pdfTitle  = $report_title = $vis_language['TXTTICKETSBYPRIORITIES'];
                $graphDiv  = 'priorities_sparkline';
                $graphOpts = 'priorityOps';
            } elseif ($criteria1 == 3) {
                $pdfTitle  = $report_title = $vis_language['TXTTICKETSBYTYPE'];
                $graphDiv  = 'types_sparkline';
                $graphOpts = 'typesOps';
            } elseif ($criteria1 == 4) {
                $pdfTitle  = $report_title = $vis_language['TXTTICKETSBYLABEL'];
                $graphDiv  = 'label_sparkline';
                $graphOpts = 'labelOps';
            }
            if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                $data = $operation;
            else
                $data = parse_form_array($operation['vis_action']);
            if (count($data) == 0) {
                include(VIS_PATH_TEMPLATE . 'report_form.php');
                return true;
            }
            $currentdate = date('Y-m-d h:i:s');
            $filter      = ' department_id  = ' . $data['department_id'];
            if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '"); </script>';
                return false;
            }
            if ($data['duration'] == 4) {
                list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                if (!$ret) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                    return false;
                }
            }
            if ($data['duration'] == 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '"); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDEPTFORGEN'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['department_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    return false;
                }	 else if ($data['duration'] == 1) //if select Last 30 days duration
                {
                $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                $filter .= ' and receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
            } else if ($data['duration'] == 2) //if select Last 7 days duration
                {
                $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                $filter .= ' and receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
            } else if ($data['duration'] == 3) //if select Last 24 hours duration
                {
                $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                $filter .= ' and receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and department_id=' . $data['department_id'];
            } else if ($data['duration'] == 4) //if select Custom duration
                {
                $from = strtotime($data['from_date']) - VIS_TIMEZONE;
                $to   = strtotime($data['to_date']) - VIS_TIMEZONE;
                $filter .= ' and receive_date between ' . $from . ' AND ' . $to . ' and department_id=' . $data['department_id'];
            } 
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object      = new class_report($database);
            $graphReport = $object->get_graphical_ticket_overview($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, '');
            
            /*if (strtolower(trim(urldecode($data['vis_criteria']))) == 'tickets by status') {
                include(VIS_PATH_TEMPLATE . 'status_graphical_report.php');
            } elseif (strtolower(trim(urldecode($data['vis_criteria']))) == 'tickets by priorities') {
                include(VIS_PATH_TEMPLATE . 'priority_graphical_report.php');
            } elseif (strtolower(trim(urldecode($data['vis_criteria']))) == 'tickets by ticket types') {
                include(VIS_PATH_TEMPLATE . 'type_graphical_report.php');
            } elseif (strtolower(trim(urldecode($data['vis_criteria']))) == 'tickets by label') {
                include(VIS_PATH_TEMPLATE . 'labels_graphical_report.php');
            }*/
			if (strtolower(trim($data['vis_criteria1'])) == 1) {
                include(VIS_PATH_TEMPLATE . 'status_graphical_report.php');
            } elseif (strtolower(trim($data['vis_criteria1'])) == 2) {
                include(VIS_PATH_TEMPLATE . 'priority_graphical_report.php');
            } elseif (strtolower(trim($data['vis_criteria1'])) == 3) {
                include(VIS_PATH_TEMPLATE . 'type_graphical_report.php');
            } elseif (strtolower(trim($data['vis_criteria1'])) == 4) {
                include(VIS_PATH_TEMPLATE . 'labels_graphical_report.php');
            }
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function get_survey_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTSURVEY'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        $export = 1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $object = new class_setting($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $ticket_object = new class_ticket($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
        $client               = new class_client($database);
        $filter               = "location = 4 and is_enabled=1";
        $custom_group_details = $object->get_custom_group_list($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $custom_group_total   = count($custom_group_details);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                $filter    = $operation['filter'];
                $survey_id = $operation['department_id'];
            } else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['survey_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGFIELDSNTSELECTED'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['survey_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERRSELSURVEY'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                $survey_id   = $data['survey_id'];
                $filter      = '';
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = 'entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = 'entry_date between ' . $from . ' AND ' . $to;
                }
            }
            
            $filter11                    = "location = 4 and is_enabled=1";
            $custom_group_details_select = $object->get_custom_group_list($filter11, VIS_STAFF_ID, VIS_LOCATION_AREA);
            $custIds                     = $client->get_custom_fields_id($survey_id);
            $idArr                       = $dataArr = array();
            if ($custIds != -1) {
                foreach ($custIds as $id) {
                    foreach ($id as $key => $val) {
                        $idArr[] = $val;
                    }
                }
                $strIds = implode(',', $idArr);
                $filter .= ' and customfield_id in (' . $strIds . ')';
                $checkExists = $ticket_object->get_customfield_data_client($filter);
                if ($checkExists != -1) {
                    foreach ($checkExists as $arrClients) {
                        $clients[]                         = $arrClients['parent_id'];
                        $clDt[]                            = $arrClients['entry_date'];
                        $dataArr[$arrClients['parent_id']] = $arrClients['entry_date'];
                    }
                    $clientIds    = array_unique($clients);
                    $clientStr    = implode(',', $clientIds);
                    $clientFilter = ' client_id in (' . $clientStr . ') and customfield_id in (' . $strIds . ') AND ' . VIS_TABLE_PREFIX . 'client.is_spam=0 AND ' . VIS_TABLE_PREFIX . 'client.is_banned=0';
                    list($client_info, $client_details) = $client->get_survey_client($clientFilter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
                }
            }
            
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $report_object = new class_report($database);
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
                foreach ($client_details as $i) {
                    $temp = '';
                    foreach ($i as $key => $val) {
                        if ($key == 'first_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'last_name') {
                            $report_exp[$j][$key] = $val;
                        } 
						elseif ($key == 'group_name') {
                            $report_exp[$j][$key] = $val;
                        }elseif ($key == 'email') {
                            $report_exp[$j][$key]          = $val;
                            $report_exp[$j]['survey']      = $custom_group_details_select[0]['customgroup_name'];
                            $report_exp[$j]['survey_date'] = $temp;
                        } elseif ($key == 'client_id') {
                            $temp = format_datetime_rpt($dataArr[$val],$staff_id);
                        }
                    }
					
					 $report_exp1[$j]['client'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					 $report_exp1[$j]['email'] = $report_exp[$j]['email'];
					 $report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					 $report_exp1[$j]['survey'] = $report_exp[$j]['survey'];
					 $report_exp1[$j]['survey_date'] = $report_exp[$j]['survey_date'];
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                }
                $result = $report_object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'survey_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function display_client_survey($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_FUNCTION_PREFIX . 'ticket.php');
        $ticket      = new ticket();
        $location[0] = 4;
        $location[1] = $operation['vis_survey_id'];
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $object                      = new class_setting($database);
        $filter11                    = "location = 4 and customgroup_id = " . $operation['vis_survey_id'];
        $custom_group_details_select = $object->get_custom_group_list($filter11, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $surveyTitle                 = $custom_group_details_select[0]['customgroup_name'];
        $custom_field_var            = $ticket->get_custom_fields_values($location, 0, '', $operation['vis_client_id'], $database);
        include(VIS_PATH_TEMPLATE . 'display_client_survey.php');
        return true;
    }
    
    function get_client_survey_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTCLIENTSURVEY'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        $export = 1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                $clientId = $operation['department_id'];
            } else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if ($data['domain_id'] == 0 && $data['vis_client_id'] == '') {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGFIELDSNTSELECTED'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDOMAIN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['vis_client_id'] == '') {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSELCLIENT'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                $clientId = $data['vis_client_id'];
            }
            
            $surveyList = $object->get_client_survey_report($clientId);
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
                foreach ($surveyList as $i) {
                    $temp = '';
                    foreach ($i as $key => $val) {
                        if ($key == 'first_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'last_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'group_name') {
                            $report_exp[$j][$key] = $val;
                        }elseif ($key == 'email') {
                            $report_exp[$j][$key]  = $val;
                            $report_exp[$j]['survey_date'] = $temp;
                        } elseif ($key == 'customgroup_name') {
                            $report_exp[$j]['survey'] = $val;
                        } elseif ($key == 'entry_date') {
                            $temp = format_datetime_rpt($val,$staff_id);
                        }
                    }
					 $report_exp1[$j]['client'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					 $report_exp1[$j]['email'] = $report_exp[$j]['email'];
					  $report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					 $report_exp1[$j]['survey'] = $report_exp[$j]['survey'];
					 $report_exp1[$j]['survey_date'] = $report_exp[$j]['survey_date'];
                   
				   $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'client_survey_list.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function export_survey($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_FUNCTION_PREFIX . 'ticket.php');
        $ticket      = new ticket();
        $location[0] = 4;
        $location[1] = $operation['vis_survey_id'];
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $object                      = new class_setting($database);
        $location[3]                 = $operation['vis_survey_dt'];
        $filter11                    = "location = 4 and customgroup_id = " . $operation['vis_survey_id'];
        $custom_group_details_select = $object->get_custom_group_list($filter11, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $surveyTitle                 = $custom_group_details_select[0]['customgroup_name'];
        $custom_field_var            = $ticket->show_custom_fields($location, $operation['vis_client_id'], 0, $database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
        $client = new class_client($database);
        list($client_info, $clientDet) = $client->get_client('client_id=' . $operation['vis_client_id'], '', 0, '', 0, 1);
        $html = get_include_contents(VIS_PATH_TEMPLATE . 'survey_export.php', array(
            $surveyTitle,
            $clientDet,
            $custom_field_var,
            $surveyDt
        ));
        if ($ticket_details == -1 || $post_details == -1) {
            echo $vis_language['MSGERROPRT'];
            return false;
        } else {
            if ($operation['vis_type'] == 'pdf') {
                require_once('../plugins/tcpdf/config/lang/eng.php');
                require_once('../plugins/tcpdf/tcpdf.php');
                $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
                $pdf->SetCreator(PDF_CREATOR);
                $pdf->SetAuthor('Ajay Ahire');
                $pdf->SetTitle($surveyTitle);
                $pdf->SetSubject($surveyTitle);
                $pdf->SetKeywords('Vision helpdesk, PDF, ' . $surveyTitle);
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
                $pdf->SetPrintHeader(false);
                $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
                $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->setLanguageArray($l);
                $pdf->SetFont('helvetica', '', 9);
                $pdf->AddPage();
                $pdf->writeHTML($html, true, false, true, false, '');
                $pdf->lastPage();
                $pdf->Output($surveyTitle . '.pdf', 'I');
            } else {
                //header('Content-Disposition: attachment; filename="'.$ticket_details['ticket_id'].' - '.$ticket_details['subject'].'.pdf"');
            }
            return true;
        }
    }
    
    function leaderboard_report($operation)
    {
        $online   = 1;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        $staff_object = new class_staff($database);
        list($view_info, $view_details) = $staff_object->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (isset($operation['vis_page']))
            $page = $operation['vis_page'];
        else
            $page = 0;
        $view_info['page_count'] = 10;
        $limit                   = ' limit ' . ($page * $view_info['page_count']) . ',' . $view_info['page_count'];
        list($staffCnt, $online_staff) = $object->leaderboard_report('', VIS_STAFF_ID, VIS_LOCATION_AREA, $limit);
        $view_info['page_count'] = ($staffCnt['total'] == 0) ? 0 : ceil($staffCnt['total'] / $view_info['page_count']);
        $view_info['page']       = $page;
        $database->database_disconnect();
        if (!isset($operation['vis_change']))
            include(VIS_PATH_TEMPLATE . 'leaderboard_report.php');
        else
            include(VIS_PATH_TEMPLATE . 'leaderboard_report_list.php');
        return true;
    }
    
    /******ITIL REPORTS******/
    
    function problems_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTPROBLEMSPERDEPT'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        $export     = 1;
        $itilReport = 1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object  = new class_ticket($database);
        $filter      = (VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1');
        $departments = $tkt_object->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX . 'domain.domain_id');
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
               
				
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDEPTFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['department_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }	
			
				
				
				
                if ($data['department_id'] == 0) {
                    $department_Id = " ";
                } else
                    $department_Id = " AND FIND_IN_SET (" . $data['department_id'] . ", " . VIS_TABLE_PREFIX . "itil_problems.department_id)>0";
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $from . ' AND ' . $to . $department_Id;
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'problem.php');
            $problem_object = new class_problem($database);
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            list($problems_info, $problems_details) = $problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
                foreach ($problems_details as $i) {
                    $temp = '';
                    foreach ($i as $key => $val) {
                        if ($key == 'problem_hash') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'subject') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'date_created') {
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        } elseif ($key == 'domain_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'department_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'first_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'last_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'impact_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'priority_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'status_name') {
                            $report_exp[$j][$key] = $val;
                        }
                    }
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                 if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'problems_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
        
    }
    
    function changes_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTCHANGESPERDEPT'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object  = new class_ticket($database);
        $filter      = (VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1');
        $departments = $tkt_object->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX . 'domain.domain_id');
        $export      = 1;
        $itilReport  = 1;
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
              if ($data['duration'] == 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDEPTFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['department_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['department_id'] == 0) {
                    $department_Id = " ";
                } else
                    $department_Id = " AND FIND_IN_SET (" . $data['department_id'] . ", " . VIS_TABLE_PREFIX . "itil_changes.department_id)>0";
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $from . ' AND ' . $to . $department_Id;
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'changes.php');
            $change_object = new class_changes($database);
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            list($changes_info, $changes_details) = $change_object->get_changes($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
                foreach ($changes_details as $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'changes_hash') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'subject') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'date_created') {
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        } elseif ($key == 'domain_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'department_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'first_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'last_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'change_type') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'impact_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'priority_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'risk_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'status_name') {
                            $report_exp[$j][$key] = $val;
                        }
                    }
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                 if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'changes_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function releases_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTRELEASESPERDEPT'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');

        $tkt_object  = new class_ticket($database);
        $filter      = (VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1');
        $departments = $tkt_object->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX . 'domain.domain_id');
        $export      = 1;
        $itilReport  = 1;
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
               if ($data['duration'] == 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDEPTFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['department_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['department_id'] == 0) {
                    $department_Id = " ";
                } else
                    $department_Id = " AND FIND_IN_SET (" . $data['department_id'] . ", " . VIS_TABLE_PREFIX . "itil_releases.department_id)>0";
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'itil_releases.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'itil_releases.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_releases.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . $department_Id;
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'itil_releases.date_created between ' . $from . ' AND ' . $to . $department_Id;
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'releases.php');
            $release_object = new class_releases($database);
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            list($releases_info, $releases_details) = $release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
                foreach ($releases_details as $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'release_hash') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'subject') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'date_created') {
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        } elseif ($key == 'domain_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'department_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'release_type') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'priority_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'status_name') {
                            $report_exp[$j][$key] = $val;
                        }
                    }
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'releases_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function generate_reports()
    {
        global $vis_language;
        $currentdatee=date('Y-m-d h:i:s');
        /*if (VIS_SLAVE_DB == 1) {
            $database = new class_database('mysql', 1);
        } else*/
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $report_object = new class_report($database);
								
								include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'subreport.php');
        $subreport_object = new subreport();
								
        include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
        $object_export = new export();
        
        $download_list           = $report_object->get_download_queue($database);
		$download_list[0]['export_name'] = str_replace(" ","_",$download_list[0]['export_name']);
		$operation               = $download_list[0];
		// replace space with underscore
        
		
		//
        $operation['vis_action'] = 'export';
        $operation['vis_export'] = 1;
        $operation['slave_db']   = VIS_SLAVE_DB;
		
		if($operation['report_type']==79) { $operation['vis_tab'] = 7; }
        switch ($operation['report_type']) {
            case 1: // work report
                $subreport_object->work_report($operation);
                break;
            case 2: // sla report
                $subreport_object->sla_report($operation);
                break;
            case 3: //response report
                $subreport_object->response_report($operation);
                break;
            case 4: //performance report
                $subreport_object->performance_report($operation);
                break;
            case 6: //client sla report
                $subreport_object->client_sla_report($operation);
                break;
            case 7: //billing report
                $subreport_object->billing_report($operation);
                break;
            case 8: //rating report per department 
                $this->rating_report($operation);
                break;
            case 9: // time tracking per staff report
                $subreport_object->time_tracking_staff_report($operation);
                break;
            case 10: // time tracking per department report
                $subreport_object->time_tracking_department_report($operation);
                break;
            case 11: // orgnization report
                $this->client_group_ticket_report($operation);
                break;
            case 12: // survey report
                $this->get_survey_report($operation);
                break;
            case 13: // client survey report
                $this->get_client_survey_report($operation);
                break;
            case 14: //ticket report
                $object_export->advance_search($operation);
                break;
            case 15: // client report
                $object_export->advance_search($operation);
                break;
            case 16: // rating report per client
                $this->rating_client_report($operation);
                break;
            case 17: // problem report			   	
                $this->problems_report($operation);
                break;
            case 18: // changes_report
                $this->changes_report($operation);
                break;
            case 19: // release report
                $this->releases_report($operation);
                break;
            case 20: //billing client report
                $subreport_object->billing_client_report($operation);
                break;
            case 21: //time_tracking_organization_report
                $this->time_tracking_organization_report($operation);
                break;
            case 22: //time_tracking_client_report
                $this->time_tracking_client_report($operation);
                break;
            case 23: //domain report
                $subreport_object->domain_report($operation);
                break;
            case 24: //first_response_report
                $subreport_object->first_response_report($operation);
                break;
			case 25: //Total_response_report
                $this->total_response_report($operation);
                break;
            
            case 26: //Billing_invoice_report
                $subreport_object->billing_invoice_report($operation);
                break;
            case 27: //order_report
                $subreport_object->order_report($operation);
                break;
            case 28: //transaction_report
                $subreport_object->transaction_report($operation);
                break;
            case 29: //client_order_report	
                $subreport_object->client_order_report($operation);
                break;
            case 30: //client_transaction_report
                $subreport_object->client_transaction_report($operation);
                break;
            case 31: //staff_point_report
                $this->staff_point_report($operation);
                break;
            case 32: //staff_bonus_point_report
                $this->staff_bonus_point_report($operation);
                break;
            case 33: //quest_report
                $this->quest1_report($operation);
                break;
            case 34: //Deleted tickets report
                $subreport_object->deleted_tickets_report($operation);
                break;
            case 35: //Merged tickets report
                $subreport_object->merged_tickets_report($operation);
                break;
            case 36: //grouped by channel tickets report
                $subreport_object->channel_wise_tickets_report($operation);
                break;
            case 37: //grouped by channel tickets report
                $this->itil_problemsolved_report($operation);
                break;
            case 38://for user ticket creation
                $subreport_object->customfield_data_report($operation);
                break;
            case 39:// for user registration
                $this->customfield_data_userreg_report($operation);
                break;
            case 40: //not ans ticket report
                $subreport_object->not_answered_ticket_report($operation);
                break;
            case 41: //ticket escalation group by staff
                $subreport_object->ticket_escalation_staff_report($operation);
                break;
            case 42: //ticket escalation group by departmnent
                $subreport_object->ticket_escalation_department_report($operation);
                break;
            case 43: //total ticket resolved
                $subreport_object->dept_report($operation);
                break;
            case 44: //login activity report
                $this->login_act_report($operation);
                break;
            case 45: //staff activities report
                $this->staff_report($operation);
                break;
            case 46: // staff activity search report
                $this->staff_activity_search_report($operation);
                break;
            case 47: // staff response time report
                $this->staff_response_time_report($operation);
                break;
			 case 48: // client with maximum ticket
                $this->client_with_maximum_ticket_report($operation);
                break;
			case 49: // client with maximum ticket reply
                $this->client_with_maximum_reply_ticket_report($operation);
                break;
			case 50://most commented article
			  $this->most_commented_article_report($operation);
			  break;
			case 51://most rated article
			  $this->most_rated_articles_report($operation);
			  break;
			  case 52://most view article
			  $this->most_view_articles_report($operation);
			  break;
			  case 53://itil problems group by status
			  $this->itil_problems_groupby_status_report($operation);
			  break;
			  case 54://itil problems group by priority
			  $this->itil_problems_groupby_status_report($operation);
			  break;
			  case 55://itil problems group by impact
			  $this->itil_problems_groupby_status_report($operation);
			  break;
			   case 56:// assign_staff_task_report
			  $this->assign_staff_task_report($operation);
			  break;
			   case 57://overdue_task
			  $this->overdue_task_report($operation);
			  break;
			  case 58://assets used by client report
			  $this->assets_usedby_client_report($operation);
			  break;
			  case 59://assets managed by staff report
			  $this->assets_managedby_staff_report($operation);
			  break;			  
			   case 60://ticket_linking_report
			  $subreport_object->ticket_linking_report($operation);
			  break;
			  case 61://task_commented_report
			  $this->task_commented_report($operation);
			  break;
			  case 62://assets_linkedto_tickets_report
			  $this->assets_linkedto_tickets_report($operation);
              break;
			  case 63://ticket_activity
			  $subreport_object->ticket_activity_report($operation);
			  break;
			  case 64: //releases_linkedto_changes_report
			  $this->releases_linkedto_changes_report($operation);
			  break;
			  case 65://changes_resolvedby_staff_report
			  $this->changes_resolvedby_staff_report($operation);
     break;
			  case 66://staff_leaderboard_report
			  $subreport_object->staff_leaderboard_report($operation);
     break;
					case 67://ticket_replied_by_staff_report
			  $subreport_object->ticket_replied_by_staff_report($operation);
     break;
					case 68://ticket_forwarded_by_staff_report
			  $subreport_object->ticket_forwarded_by_staff_report($operation);
     break;
					case 69://ticket_viewed_by_staff_report
			  $subreport_object->ticket_viewed_by_staff_report($operation);
     break;
					case 70://ticket_viewed_by_staff_report
			  $subreport_object->assets_linkedto_problems_report($operation);
     break;
			  case 71://assets_groupby_status_report
			  $subreport_object->assets_groupby_status_report($operation);
     break;
					case 72://assets_groupby_location_report
			  $subreport_object->assets_groupby_location_report($operation);
     break;
 
	 
 
	case 73://task_by_status_report
			  $subreport_object->task_by_status_report($operation);
			  break;
			  case 74://assets_by_asset_type_report
			  $subreport_object->assets_asset_type_report($operation);
     break;
	  case 75://assets_by_asset_porduct_report
			  $subreport_object->assets_asset_product_report($operation);
     break;
	 case 76://hardware_assets_by_state_report
			  $subreport_object->hardware_assets_by_state_report($operation);
     break;
	  case 77://assets_depreciation_report
			  $subreport_object->assets_depreciation_report($operation);
     break;
	 case 78://assets_depreciation_notification_report
			  $subreport_object->assets_depreciation_notification_report($operation);
     break;
	 case 79://ticket load report
	        $this->report_list($operation);
			break;
			case 80://client overview
	          $this->client_report($operation);
     break;
         case 81://clients_by_organization_report
	     $subreport_object->clients_by_organization_report($operation);
     break;
	     case 82://invoicesby_organization_report
	     $subreport_object->invoiceby_organization_report($operation);
     break;
	 
	  case 83://staff_leaderboard_report
					$subreport_object->staff_leaderboard_first_avgresponse_report($operation);
					break;
				case 84://staff_leaderboard_report
					$subreport_object->staff_leaderboard_avgresponse_report($operation);
				break;
				case 85://staff_leaderboard_report
					$subreport_object->staff_leaderboard_avgresponse_maintain_report($operation);
				break;
	 
	 case 86://tickets_overdue_report
	     $subreport_object->overdue_tickets_report($operation);
		 break;	
     case 87: 
	          $subreport_object->unoverdue_ticket_report($operation);
              break;	
			case 88: // ticket activity by department
			$subreport_object->ticket_activity_by_department_report($operation);
			break;
			case 89: 
			$subreport_object->ticket_ci_relation_report($operation);
			break;
			case 90: 
			$subreport_object->problem_ci_relation_report($operation);
			break;
		case 91: 
		$subreport_object->changes_ci_relation_report($operation);
		break;
		case 92: 
		$subreport_object->task_linkedto_ticket_report($operation);
		break;
		case 93: // get custom field staff report                             
                $subreport_object->customfield_staff_report($operation);                
                break; 
		case 94:
                $this->customfield_data_orgreg_report($operation);
                break;
        case 95:
                $subreport_object->ticket_closed_by_user_report($operation);
                break;	
		case 96: 
			$subreport_object->ticket_flag_by_user($operation);
				break;
		case 97: // client group report
                $object_export->advance_search($operation);
                break;
        }
    }
    
    function report_date_range_validation($from_date, $to_date)
    {
        global $vis_language;
        $vis_from_date = strtotime($from_date);
        $vis_to_date   = strtotime($to_date);
        
        $datetime1 = new DateTime($from_date);
        $datetime2 = new DateTime($to_date);
        
        $dateDiff = get_timespan_difference($datetime1, $datetime2);
        
        if ($vis_from_date > $vis_to_date) {
            return array(
                false,
                $vis_language['MSGFROMLESSTHANTO']
            );
        } else if ($dateDiff['y'] > 0) {
            return array(
                false,
                $vis_language['MSGDURATIONLESSTHANTHREEMONTHS']
            );
        } elseif ($dateDiff['m'] > 3) {
            return array(
                false,
                $vis_language['MSGDURATIONLESSTHANTHREEMONTHS']
            );
        } elseif ($dateDiff['m'] == 3) {
            if ($dateDiff['d'] > 0) {
                return array(
                    false,
                    $vis_language['MSGDURATIONLESSTHANTHREEMONTHS']
                );
            }
        }
        return array(
            true,
            ''
        );
    }
    function quest_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTQUESTTOPPERFORMER'];
        $export       = 1;
        $database     = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $object = new class_setting($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object_report = new class_report($database);
        list($quest_info, $questDetails) = $object->get_quest_list('quest_status !=0', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if ($data['quest_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGFLDNTSEL'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                list($staffCnt, $online_staff) = $object_report->quest_report($data['quest_id'], $data['quest_id'], VIS_STAFF_ID, VIS_LOCATION_AREA, $limit);
            }
			include(VIS_PATH_TEMPLATE . 'quest_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    
    
    
    // new report
    function total_response_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTTOTALRESPONSES'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        $export = 1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object       = new class_ticket($database);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        $departments      = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '"); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '"); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['department_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDEPTFORGEN'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['department_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    return false;
                }
                $currentdate = date('Y-m-d h:i:s');
                
                
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $monthDate     = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1 and reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $hour          = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
                    $from          = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to            = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter        = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1';
                    $filter .= ($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                }
                
            }
            
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object       = new class_report($database);
            $total_post   = 0;
            $total_ticket = array();
            $total_time   = 0;
            $filter .= ' and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1';
            $post_details = $object->get_total_response_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
            if ($post_details != -1)
                for ($i = 0; $i < count($post_details); $i++) {
                    
                    if (!isset($report[$post_details[$i]['ticket_id']]['start_time']) || $report[$post_details[$i]['ticket_id']]['start_time'] == '') {
                        //echo $i."---test--".$post_details[$i]['ticket_id']."<br>";
                        $report[$post_details[$i]['ticket_id']]['ticket_hash']  = $post_details[$i]['ticket_hash'];
                        $report[$post_details[$i]['ticket_id']]['subject']      = $post_details[$i]['subject'];
                        $report[$post_details[$i]['ticket_id']]['ticket_entry'] = $post_details[$i]['ticket_entry'];
                        $report[$post_details[$i]['ticket_id']]['time']         = $post_details[$i]['receive_date'] - $post_details[$i]['ticket_entry'];
                        $report[$post_details[$i]['ticket_id']]['ticket_id']    = $post_details[$i]['ticket_id'];
                        $report[$post_details[$i]['ticket_id']]['count']        = 0;
                        if ($post_details[$i]['submitter'] == 1)
                            $report[$post_details[$i]['ticket_id']]['is_posted'] = false;
                        if ($post_details[$i]['submitter'] != 1) {
                            $report[$post_details[$i]['ticket_id']]['start_time'] = $post_details[$i]['receive_date'];
                            $report[$post_details[$i]['ticket_id']]['is_posted'] = true;
                        }
                        
                    } elseif ($post_details[$i]['submitter'] == 1) {
                        
                        $report1[$post_details[$i]['ticket_id']]['time'] += $post_details[$i]['receive_date'] - $report[$post_details[$i]['ticket_id']]['start_time'];
                        $report[$post_details[$i]['ticket_id']]['start_time'] = '';
                        $report[$post_details[$i]['ticket_id']]['count']++;
                        $report[$post_details[$i]['ticket_id']]['is_posted'] = true;
                        $total_ticket[$post_details[$i]['ticket_id']]        = $post_details[$i]['ticket_id'];
                        $total_time += $report[$post_details[$i]['ticket_id']]['time'];
                        $total_post++;
                        //echo $i."---ssss--".$post_details[$i]['ticket_id']."-------".$report[$post_details[$i]['ticket_id']]['time']."<br>";
                    } else {
                        $report[$post_details[$i]['ticket_id']]['time'] += $post_details[$i]['receive_date'] - $report[$post_details[$i]['ticket_id']]['start_time'];
                        if ($report[$post_details[$i]['ticket_id']]['time'] < 0)
                            $report[$post_details[$i]['ticket_id']]['time'] = 0;
                        //echo $i."---hhhh--".$post_details[$i]['ticket_id']."<br>";
                        $report[$post_details[$i]['ticket_id']]['count']++;
					    $total_post++;
                        $total_ticket[$post_details[$i]['ticket_id']] = $post_details[$i]['ticket_id'];
                        $total_time += $post_details[$i]['receive_date'] - $report[$post_details[$i]['ticket_id']]['start_time'];
                    }
                    
                }
            
            else
                $report = -1;
			
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
				 foreach ($report as $ticket_id => $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'ticket_hash') {
                            $report_exp[$j][$key] = $val;
                        }
						elseif ($key == 'subject') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'ticket_entry') {
                           
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        } elseif ($key == 'time'){
                            if ($val != 0)
                                $report_exp[$j]['total_response_time'] = count_remain_time($val);
                            else
                                $report_exp[$j]['avg_response_time'] = 0;
                        }

					}
					$report_exp1[$j]['ticket_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['total_response_time'] = $report_exp[$j]['total_response_time'];
              
                    $j++;
					
                }
                $report_exp1[$j]['total_avg_response_time'] = $vis_language['TXTTOTALAVGRESPONSETIME'].':'.count_remain_time(round($total_time/$total_post,2));
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				 
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
 
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'total_response_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
        
    }
    
    function staff_point_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTSTAFFPOINTREPORT'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $ticket_object = new class_ticket($database);
        list($info, $ticket) = $ticket_object->get_ticket('ticket_id=' . $data['vis_ticket_id'], '', 0, '', $user, VIS_LOCATION_AREA);
        $tickets    = array_merge($data, $ticket[0]);
        $tkt_object = new class_ticket($database);
        $staff      = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                $filter = $operation['filter'];
            } else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                
                if ($data['duration'] == 0 && $data['staff_id'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                    
                } else if ($data['duration'] == 0 && $data['staff_id'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                    
                }
                 
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $staff_id  = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                     $filter    = VIS_TABLE_PREFIX . 'ticket_post.receive_date between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and staff_id=' . $data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and staff_id=' . $data['staff_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $hour     = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and staff_id=' . $data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $from     = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to       = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to;
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and staff_id=' . $data['staff_id'];
                }
                
            }
            
            $filters      = explode('and', $filter);
            $filter       = $filters[0];
            $staff_filter = $filters[1];
            /*print_r($filters);
            echo "<br>";
            echo $filter;
            echo "<br>";
            echo $staff_filter;*/
            
             $filter1 = ' avis_ticket_post.submitter=0 and avis_ticket_post.reply_forward =1 and ' . $filter . '
HAVING (SELECT (MINUTE(TIMEDIFF(from_unixtime(avis_ticket_post.receive_date, "%Y-%m-%d %h:%i:%s"),from_unixtime(C.receive_date, "%Y-%m-%d %h:%i:%s")))) as timdiff FROM avis_ticket_post C WHERE C.post_id < avis_ticket_post.post_id and C.submitter=1 order by C.post_id DESC LIMIT 1) <=10 
and avis_ticket_post.submitter_id!=(SELECT IF(C.submitter!=1,C.submitter_id,0) as id FROM avis_ticket_post C WHERE C.post_id < avis_ticket_post.post_id  order by C.post_id DESC LIMIT 1)';
            $filter2 = ' (avis_ticket.due_time-avis_ticket_post.receive_date) >0 and avis_ticket_post.submitter=0 and reply_forward =1 and ' . $filter . ' HAVING avis_ticket_post.submitter_id!=(SELECT IF(C.submitter!=1,C.submitter_id,0) as id FROM avis_ticket_post C WHERE C.post_id < avis_ticket_post.post_id and C.ticket_id = avis_ticket_post.ticket_id  order by C.post_id DESC LIMIT 1)';
            $filter3 = ' (avis_ticket.due_time-avis_ticket_post.receive_date)<0 and avis_ticket_post.submitter=0 and reply_forward =1 and ' . $filter . ' HAVING avis_ticket_post.submitter_id!=(SELECT IF(C.submitter!=1,C.submitter_id,0) as id FROM avis_ticket_post C WHERE C.post_id < avis_ticket_post.post_id and C.ticket_id =avis_ticket_post.ticket_id  order by C.post_id DESC LIMIT 1)';

            
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            list($result1, $result3) = $object->staff_point_report($filter, $staff_filter, $filter1, $filter2, $filter3, VIS_STAFF_ID, VIS_LOCATION_AREA); 
          
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
                foreach ($result1 as $ticket_id => $i) {
					/*print_r($result1);
					echo '<br><br>'.$i['fastreply_total'].'-----'.$i['slatime_total'].'-----'.$i['overduereply_total'].'<br><br>';*/
					$report_exp[$j]['duration'] = ($i['fastreply_total'] * $result3[0]['points'])+($i['slatime_total'] * $result3[1]['points'])+($i['overduereply_total'] * $result3[2]['points']);
                    
				   foreach ($i as $key => $val) {
                        if ($key == 'first_name' || $key == 'last_name' ) {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'staff_point') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'level_id') {
							$report_exp[$j][$key] = $val;
							 if($val==1){
							 	$report_exp[$j][$key] =$vis_language['TXTPAWN'];}
							 else if($val==2){
								$report_exp[$j][$key] =$vis_language['TXTKNIGHT'];
							 }else if($val==3){
								$report_exp[$j][$key] =$vis_language['TXTBISHOP'];
							 }else if($val==4){
								$report_exp[$j][$key] =$vis_language['TXTROOK'];
							 }else if($val==5){
								$report_exp[$j][$key] =$vis_language['TXTQUEEN'];
							 }else if($val==6){
								$report_exp[$j][$key] =$vis_language['TXTKING'];
							 }else{
							 	$report_exp[$j][$key] = '---';
							 }
                        }
				   }
					$report_exp1[$j]['staff_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['total_point'] = $report_exp[$j]['staff_point'];
					$report_exp1[$j]['current_rank'] = $report_exp[$j]['level_id'];
					$report_exp1[$j]['duration_point'] = $report_exp[$j]['duration'];
                    					
                    $j++;
                }
                //print_r($report_exp);
				//die();
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
				if(isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'staff_point_report.php');
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
        
    }
    
    function staff_bonus_point_report($operation)
    {
        
        global $vis_language;
        $report_title = $vis_language['TXTBONUSPOINTREPOT'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $ticket_object = new class_ticket($database);
        list($info, $ticket) = $ticket_object->get_ticket('ticket_id=' . $data['vis_ticket_id'], '', 0, '', $user, VIS_LOCATION_AREA);
        $tickets    = array_merge($data, $ticket[0]);
        $tkt_object = new class_ticket($database);
        $staff      = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                $filter = $operation['filter'];
            } else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                
                if ($data['duration'] == 0 && $data['staff_id'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                    
                } else if ($data['duration'] == 0 && $data['staff_id'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $staff_id  = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'selfhelp_article.entry_date between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'selfhelp_article.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $hour     = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'selfhelp_article.entry_date between ' . $hour . ' AND ' . strtotime($currentdate);
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    
                    $staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
                    $from     = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to       = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'selfhelp_article.entry_date between ' . $from . ' AND ' . $to;
                    $filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
                }
                
            }
            
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object       = new class_report($database);
            $filters      = explode('and', $filter);
            $filter       = $filters[0];
            $staff_filter = str_replace('author_id', 'staff_id', $filters[1]);
            /*print_r($filters);
            echo "<br>";
            echo $filter;
            echo "<br>";
            echo $staff_filter;*/
            
            $filter1 = ' and avis_selfhelp_article.art_likes >3 and ' . $filter;
            $filter2 = ' and avis_selfhelp_article.art_likes<3 and avis_selfhelp_article.art_likes>0 and ' . $filter;
            list($result1, $result3) = $object->staff_bonus_point_report($filter, $filter1, $filter2, $staff_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
            /*print_r($result1);
            die();*/
            if ($result1 != -1) {
                for ($j = 0; $j < count($result1); $j++) {
                    $result1[$j]['happy_customer']   = ($result1[$j]['happy_customer'] * $result3[3]['points']);
                    $result1[$j]['unhappy_customer'] = ($result1[$j]['unhappy_customer'] * $result3[4]['points']);
                    $result1[$j]['total_article']    = ($result1[$j]['total_article'] * $result3[5]['points']);
                    $result1[$j]['total_comment']    = ($result1[$j]['total_comment'] * $result3[7]['points']);
                    $result1[$j]['total_notes']      = ($result1[$j]['total_notes'] * $result3[6]['points']);
                    $result1[$j]['Bonuspoint']       = ($result1[$j]['happy_customer'] + $result1[$j]['unhappy_customer'] + $result1[$j]['total_article'] + $result1[$j]['total_comment'] + $result1[$j]['total_notes']);
                    $result1[$j]['total_article']    = ($result1[$j]['total_article'] + $result1[$j]['happy_customer'] + $result1[$j]['unhappy_customer']);
                }
            }
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
                
                foreach ($result1 as $ticket_id => $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'first_name' || $key == 'last_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'staff_point') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'level_id') {
                             $report_exp[$j][$key] = $val;
							 if($val==1){
							 	$report_exp[$j][$key] =$vis_language['TXTPAWN'];}
							 else if($val==2){
								 $report_exp[$j][$key] =$vis_language['TXTKNIGHT'];
							 }else if($val==3){
								 $report_exp[$j][$key] =$vis_language['TXTBISHOP'];
							 }else if($val==4){
								 $report_exp[$j][$key] =$vis_language['TXTROOK'];
							 }else if($val==5){
								 $report_exp[$j][$key] =$vis_language['TXTQUEEN'];
							 }else if($val==6){
								 $report_exp[$j][$key] =$vis_language['TXTKING'];
							 }else{
							 	$report_exp[$j][$key] = '---';
							 }
                        } elseif ($key == 'total_article') {
                            $report_exp[$j][$key] = $val;
						} elseif ($key == 'total_comment') {
                            $report_exp[$j][$key] = $val;
						  } elseif ($key == 'total_notes') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'Bonuspoint') {
                            $report_exp[$j][$key] = $val;
                        }
                    }
					$report_exp1[$j]['staff_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['total_point'] = $report_exp[$j]['staff_point'];
					$report_exp1[$j]['current_rank'] = $report_exp[$j]['level_id'];
					$report_exp1[$j]['article'] = $report_exp[$j]['total_article'];
					$report_exp1[$j]['comment'] = $report_exp[$j]['total_comment'];
					$report_exp1[$j]['note'] = $report_exp[$j]['total_notes'];
					$report_exp1[$j]['bonus_points'] = $report_exp[$j]['Bonuspoint'];
                    
                    $j++;
                    
                }
				//print_r($report_exp);
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'staff_bonus_point_report.php');
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
        
    }
    
    function quest1_report($operation)
    {
        global $vis_language;
        
        $report_title = $vis_language['TXTQUESTSTAFF'];
        
        $export   = 1;
        //print_r($operation);
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $object = new class_setting($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object_report = new class_report($database);
        list($quest_info, $questDetails) = $object->get_quest_list('quest_status !=0', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $staff      = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
               
				if ($data['quest_id'] == 0 && $data['staff_id'] ==0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
			if ($data['quest_id'] == 0 && $data['staff_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECT'] .' '. $vis_language['TXTQUEST'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                   return false;
                }
                if ($data['quest_id'] != 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTSTAFF'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
				$filter1= ' avis_quest.quest_id=' . $data['quest_id'] . ' and avis_staff_badge.staff_id=' . $data['staff_id'];
				  $currentdate = date('Y-m-d h:i:s');
                $quest_date=$object_report->quest_date_list($filter1,$data); 
				
               
				  foreach ($quest_date as $quest_details) {
                    $quest_start_date = $quest_details['quest_start_date'];
					$quest_duration   = $quest_details['quest_duration'];
					//$quest_end_date   = date('Y-m-d H:i:s', strtotime($quest_duration, $quest_start_date));
				  
				  }
				 $quest_end_date   =   strtotime($currentdate);
				 
                $filter = VIS_TABLE_PREFIX . 'quest.quest_start_date between  ' . $quest_start_date . ' AND ' .$quest_end_date;
                $filter .= ' and avis_quest.quest_id=' . $data['quest_id'] . ' and avis_staff.staff_id=' . $data['staff_id'];
                
			}
                list($staff_info, $solving_ticket_count, $artical_count, $artical_solving, $solving_ticket) = $object_report->quest1_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
                foreach ($staff_info as $ticket_id => $details) {
                    $quest_start_date = $details['quest_start_date'];
                    $quest_duration   = $details['quest_duration'];
                   // $quest_end_date   = date('Y-m-d H:i:s', strtotime($quest_duration, $quest_start_date));	
                }
			 	 $quest_end_date   =   strtotime($currentdate);
                $count_ticket = count($solving_ticket_count);
                for ($i = 0; $i < count($staff_info); $i++) {
                    $t = $staff_info[$i]['quest_points'];
                }
                $total_ticket = $count_ticket * $t;
                
                
                for ($i = 0; $i < count($solving_ticket_count); $i++) {
                    $ticket_rating += $solving_ticket_count[$i]['rating'];
                }
                $artical = count($artical_count);
                for ($i = 0; $i < count($staff_info); $i++) {
                    $t = $staff_info[$i]['quest_points'];
                }
                for ($i = 0; $i < count($artical_count); $i++) {
                    $article_rating += $artical_count[$i]['art_likes'];
                }
                $total_article = $artical * $t;
                foreach ($artical_solving as $quest_details) {
                    $total = $quest_details['count_article'];
                }
                $totalticket1 = count($solving_ticket);
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j= 0;
                
                foreach ($staff_info as $ticket_id => $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'quest_type') {
                            $report_exp[$j][$key] = $val;
							if($val==1){
								$report_exp[$j][$key]=$vis_language['TXTRESOLVINGTYPE'];
								$report_exp[$j]['total'] =  $count_ticket;
								$report_exp[$j]['point'] =  $total_ticket;
								$report_exp[$j]['totalrating'] =  $ticket_rating;
							}else if($val==2){
								$report_exp[$j][$key]=$vis_language['TXTSELFHELFARTICLE'];
								$report_exp[$j]['total'] =  $artical;
								$report_exp[$j]['point'] =  $total_article;
								$report_exp[$j]['articlerating'] =  $article_rating;
							}
                        } elseif ($key == 'staff_point') {
                            $report_exp[$j][$key] = $val;
                        } 
						
					} 
					 	
					 
				
                    $j++;
					
					 
                 
				 
					if($i['quest_type'] == 1){
						$report_exp[$j][$key]= $vis_language['TXTRESOLVINGTYPE'].' :'. $totalticket1;
						}else{
						$report_exp[$j][$key]= $vis_language['TXTSELFHELFARTICLE'].' :'. $quest_details['count_article'];
						}
				}  
				 
                $completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
				 
                $result = $object_report->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'quest1_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    //generate deleted tickets report function start created by sumit

    
   

    
    function itil_problemsolved_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTITILPRBSOLVE'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
		
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object  = new class_ticket($database);
        $departments = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        $object_staff = new class_staff($database);
        $staff_filter  = "staff_id =" . VIS_STAFF_ID;
        $staff_details = $object_staff->get_staff($staff_filter, $userid, $user);
        $dept_ids    = '';
        for ($d = 0; $d < count($departments); $d++) {
            $dept_ids .= $departments[$d]['department_id'] . ',';
        }
        if ($dept_ids != '') {
            $dept_ids = substr($dept_ids, 0, -1);
        }
        $dept_id  = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
        //$access = $staff_details[0]['department_access'];
        $staff_list    = $object_staff->get_staff('is_enabled=1 ', VIS_STAFF_ID, VIS_LOCATION_AREA, '');
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'a.entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and operator_id=' . $data['staff_id'];
                    } else {
                        $filter =  'a.entry_date between  '.$monthDate. ' AND '.strtotime($currentdate).' and p.department_id in'.'('.$dept_id.')';
                        //$filter = 'date_created between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    }
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'a.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and operator_id=' . $data['staff_id'];
                    } else {
                        $filter   =  'a.entry_date between '.$weekDate.' AND '.strtotime($currentdate).' and p.department_id in'.'('.$dept_id.')';
                       // $filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    }
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'a.entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and operator_id=' . $data['staff_id'];
                    } else {
                        $filter =  'a.entry_date between '.$hour.' AND '.strtotime($currentdate).' and p.department_id in'.'('.$dept_id.')'; 
                       // $filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate);
                    }
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to   = strtotime($data['to_date']) - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'a.entry_date between ' . $from . ' AND ' . $to . ' and operator_id=' . $data['staff_id'];
                    } else {
                        $filter = 'a.entry_date between '.$from.' AND '.$to.' and p.department_id in'.'('.$dept_id.')'; 
                       // $filter = 'date_created between ' . $from . ' AND ' . $to;
                    }
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            $report = $object->get_itil_problemsolved_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                for ($i = 0; $i < count($report); $i++) {
                    if ($report[$i]['first_name'] == '') {
                        $report[$i]['first_name'] = 'Nobody';
                    }
                }
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'problem_hash'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'subject'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'fname'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'lname'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'receive_date'){
						$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						}
						elseif($key == 'first_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'last_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'fst_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'lst_name'){
						$report_exp[$j][$key] = $val;
						}
						
					}
				 $report_exp1[$j]['problem_hash'] = $report_exp[$j]['problem_hash'];
				 $report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
				 $report_exp1[$j]['cteated_by'] = $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
				 $report_exp1[$j]['assigned_to'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name']; 
				 $report_exp1[$j]['resolved_date'] = $report_exp[$j]['receive_date']; 
				 $report_exp1[$j]['resolved_by'] = $report_exp[$j]['fst_name'].' '.$report_exp[$j]['lst_name']; 
					
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'itil_problems_solved.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
				
	
	function itil_problems_groupby_status_report($operation)
	{ 
	global $vis_language;
    $report_title = $vis_language['TXTPROBLEMGROUPBYSTATUS'];
	 $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
	include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
	$ticket_module=new ticket($database);
	$status=$ticket_module->get_properties('get_status', '', '');
	$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
	if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                $currentdate = date('Y-m-d h:i:s');
				if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    if($data['vis_status_condition']==0)
					{
					$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id='.$data['vis_status'];
					}
					else{
					$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
                    }
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
					if($data['vis_status_condition']==0)
					{
					$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems. status_id='.$data['vis_status'];
					}
					else{
					$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
                    }
                    
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
					if($data['vis_status_condition']==0)
					{
					$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id='.$data['vis_status'];
					}
					else{
					$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
                    }
                   
                }
                 else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to   = strtotime($data['to_date']) - VIS_TIMEZONE;
					if($data['vis_status_condition']==0)
					{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id='.$data['vis_status'];
                    }
					else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
                    }
                }
            }
	     include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
         $object = new class_report($database);
         $report = $object->get_itil_problems_groupby_status_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		 if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
              
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				
                $export         = new export();
				$j=0;
				foreach ($report as $problem_id => $i) {
                    foreach ($i as $key => $val) {
						
                        if ($key == 'problem_hash') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'subject') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'date_created') {
                           $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						 } elseif ($key == 'department_name') {
                            $report_exp[$j][$key] =($val);
                        } elseif ($key == 'first_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'last_name') {
                            $report_exp[$j][$key] = $val;
                        }
						  elseif ($key == 'impact_name') {
                            $report_exp[$j][$key] = $val;
                        }
						 elseif ($key == 'priority_name') {
                            $report_exp[$j][$key] = $val;
                        }
						 elseif ($key == 'status_name') {
                            $report_exp[$j][$key] = $val;
                        }
                     }
					$report_exp1[$j]['problem_hash'] = $report_exp[$j]['problem_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['problem_from'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['create_date'] = $report_exp[$j]['date_created'];
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['priority'] = $report_exp[$j]['priority_name'];
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
					
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }else
                include(VIS_PATH_TEMPLATE . 'itil_problems_group.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
         $database->database_disconnect();
        return true;
	}
	
	function itil_problems_groupby_priority_report($operation)
	{
	global $vis_language;
    $report_title = $vis_language['TXTPROBLEMGROUPBYPRIORITY'];
	 $export       = 1;
     if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
          $database = new class_database('mysql', 1);
         else
            $database = new class_database();
	include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
	$ticket_module=new ticket($database);
	$priorities=$ticket_module->get_properties('get_priorities', '', '');
	$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
	if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                $currentdate = date('Y-m-d h:i:s');
				if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    if($data['vis_priority_condition']==0)
					{
					$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
					}
					else{
					$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
                    }
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
					if($data['vis_priority_condition']==0)
					{
					$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
					}
					else{
					$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
                    }
                    
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
					if($data['vis_priority_condition']==0)
					{
					$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
					}
					else{
					$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
                    }
                   
                }
                 else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to   = strtotime($data['to_date']) - VIS_TIMEZONE;
					if($data['vis_priority_condition']==0)
					{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
                    }
					else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
                    }
                }
            }
	     include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
         $object = new class_report($database);
         $report = $object->get_itil_problems_groupby_priority_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		 if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j=0;
				foreach ($report as $problem_id => $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'ticket_hash') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'subject') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'date_created') {
                           $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        } elseif ($key == 'department_name') {
                            $report_exp[$j][$key] =($val);
                        } elseif ($key == 'first_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'last_name') {
                            $report_exp[$j][$key] = $val;
                        }
						  elseif ($key == 'impact_name') {
                            $report_exp[$j][$key] = $val;
                        }
						 elseif ($key == 'priority_name') {
                            $report_exp[$j][$key] = $val;
                        }
						 elseif ($key == 'status_name') {
                            $report_exp[$j][$key] = $val;
                        }
                     }
					$report_exp1[$j]['problem_hash'] = $report_exp[$j]['problem_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['problem_from'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['create_date'] = $report_exp[$j]['date_created'];
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['priority'] = $report_exp[$j]['priority_name'];
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }else
                include(VIS_PATH_TEMPLATE . 'itil_problems_group.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
         $database->database_disconnect();
        return true;
	}
	
	function itil_problems_groupby_impact_report($operation)
	{
	global $vis_language;
    $report_title = $vis_language['TXTPROBLEMGROUPBYIMPACT'];
	 $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
	include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
	$ticket_module=new ticket($database);
	$impact=$ticket_module->get_properties('get_impacts', '', '');
	$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
	if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                $currentdate = date('Y-m-d h:i:s');
				if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    if($data['vis_impact_condition']==0)
					{
					$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
					}
					else{
					$filter = 'date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
                    }
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
					if($data['vis_impact_condition']==0)
					{
					$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
					}
					else{
					$filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
                    }
                    
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
					if($data['vis_impact_condition']==0)
					{
					$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
					}
					else{
					$filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
                    }
                   
                }
                 else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to   = strtotime($data['to_date']) - VIS_TIMEZONE;
					if($data['vis_impact_condition']==0)
					{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
                    }
					else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
                    }
                }
            }
	     include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
         $object = new class_report($database);
         $report = $object->get_itil_problems_groupby_impact_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		 if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j=0;
				foreach ($report as $problem_id => $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'ticket_hash') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'subject') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'date_created') {
                           $report_exp[$j][$key] = format_datetime_rpt($val,$staff);
                        } elseif ($key == 'department_name') {
                            $report_exp[$j][$key] =($val);
                        } elseif ($key == 'first_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'last_name') {
                            $report_exp[$j][$key] = $val;
                        }
						  elseif ($key == 'impact_name') {
                            $report_exp[$j][$key] = $val;
                        }
						 elseif ($key == 'priority_name') {
                            $report_exp[$j][$key] = $val;
                        }
						 elseif ($key == 'status_name') {
                            $report_exp[$j][$key] = $val;
                        }
                     }
					$report_exp1[$j]['problem_hash'] = $report_exp[$j]['problem_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['problem_from'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['create_date'] = $report_exp[$j]['date_created'];
					$report_exp1[$j]['department'] = $report_exp[$j]['department_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['priority'] = $report_exp[$j]['priority_name'];
					$report_exp1[$j]['status'] = $report_exp[$j]['status_name'];
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }else
                include(VIS_PATH_TEMPLATE . 'itil_problems_group.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
         $database->database_disconnect();
        return true;
	
	}
	
	function assets_usedby_client_report($operation)
	{  
	  global $vis_language;
        $report_title = $vis_language['TXTASSETSUSEDBYCLIENT'];
       	 $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
      include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
	  $cmdb_obj = new class_cmdb($database);
	  $assets = $cmdb_obj->get_assets('', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA); 
	  include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
      $setting_object=new class_setting($database);
	  $citype_details=$setting_object->get_configuration_item_category('','is_enabled=1'); 
	 //print_r($assets);
	 foreach ($assets as $i){
					foreach ($i as $key => $val){
					if($key=='name')
					$assets_details[$j][$key] = $val;					
	          }
			  $j++;
	     }
	     $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
				if ($data['asset_name'] == '' && $data['vis_ci_type'] == '' && $data['vis_usedby'] == '') { 
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
				
				if ($data['vis_ci_type'] == '') {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTITILSELECTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
				
				if ($data['vis_usedby'] == '') {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSELCLIENT'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
				
				 $client_email = str_replace("%40","@",$data['vis_usedby']);
				
			if ($data['asset_name']!= '' && $client_email != '' && $data['vis_ci_type'] != '') {
                    if(strpos($data['asset_name'],'"')){
						$filter = "cmast.name like '%".htmlentities(str_replace('\"',"",$data['asset_name']), ENT_COMPAT, 'UTF-8')."%' and cmast.usedby like '%".$client_email."%' and cmast.ci_type_id = ".$data['vis_ci_type'];
					}else{
						$filter = 'cmast.name like "%'.$data['asset_name'].'%" and cmast.usedby like "%'.$client_email.'%" and cmast.ci_type_id = '.$data['vis_ci_type'];
					}
                }
                //print_r($filter);	
				$filter1 =' where avis_customfield.customgroup_id ='.$data['vis_ci_type']. ' and avis_itil_cmdb_assets.name="'.$data['asset_name'].'"';
				  
				 $filter=$filter.'#'.$filter1;	
			}
			$temp_filtr = explode('#',$filter);
					 
					$filter = $temp_filtr[0];
					$filter1= $temp_filtr[1];
					 
			 include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
             $object = new class_report($database);
			    
			 $report=array();
           list($custom_fields_details,$report) = $object->get_assets_usedby_client_report($filter,$filter1, VIS_STAFF_ID, VIS_LOCATION_AREA);   
			$temp=array();
			$temp1=array();		
			$temp2=array();	 
			$a=0;
		  
		for($i=0;$i<count($custom_fields_details);$i++) 
		{
			$a=$custom_fields_details[$i]['assets_id'];
			if($custom_fields_details[$i]['assets_id']!=$temp1[$a]['assets_id'])
			{$temp['assets_id']=$custom_fields_details[$i]['assets_id'];
		    $a=$custom_fields_details[$i]['assets_id'];
			}
			$temp[$custom_fields_details[$i]['field_name']]=$custom_fields_details[$i]['content'];
			$temp1[$a]=$temp;	 
		}
         
			$temp2=reset($temp1);
		     
		  foreach($report as $key => $csm)
		   {
		 if(in_array($report[$key]['assets_id'],$temp1[$csm['assets_id']])){

			foreach($temp1[$csm['assets_id']] as $keys=>$val){
			 if($keys!='assets_id')
			$report[$key][$keys]=$val;
		   }
		}else{

		 foreach($temp2 as $keys=>$val){
		  if($keys!='assets_id')
		 $report[$key][$keys]='';
		   }
		  }
		   
		}
				 if($report!=1){
									
					for($i=0; $i<count($report); $i++){
						
						$is_expired =0;
						if($report[$i]['ci_type_id']==2 || $report[$i]['ci_type_id']==3){
							$total_month = ($report[$i]['warranty_year']*12)+$report[$i]['warranty_month'];
							$current_date = strtotime(date('Y-m-d h:i:s'));
							//$expiry_date = strtotime(date('Y-m-d h:i:s', $report[$i]['installation_date']) . $total_month.' month');
							if($report[$i]['warranty_year']==0 && $report[$i]['warranty_month']==0){
								if($report[$i]['expiry_date']>$report[$i]['installation_date']){
									$expiry_date = $report[$i]['expiry_date'];
								}else{
									$expiry_date = 0;
								}
							}else{
								$expiry_date = strtotime($total_month.' month',$report[$i]['installation_date']);
							}
							
							if($expiry_date==0){
								$report[$i]['status']= '--';
							}else if($expiry_date <= $current_date){
								//$report[$i]['status']=format_datetime($expiry_date);
								$report[$i]['status']=date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
							} else{
								//$report[$i]['status']='--';
								$report[$i]['status']=date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
								//format_datetime_rpt($expiry_date,$staff_id);
							}
						}else{
							$report[$i]['status']='--';
						}
																			
					}//end for
																
				}
			 
 	 
		     if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                 include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j=0;
				 
               foreach ($report as $i)
								{
									
												foreach ($i as $key => $val)  {
						if ($key == 'ci_type_id') {
                            $report_exp[$j][$key] = $val;
                        }
                        elseif ($key == 'name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'description') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'assigned_on') {
                           $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        } elseif($key == 'installation_date'){
							$report_exp[$j][$key] = date(VIS_EDITDATETIMEPICKER_FORMAT,$val);
						} elseif($key == 'last_audit_date'){
							$report_exp[$j][$key] = date(VIS_EDITDATETIMEPICKER_FORMAT,$val);
						} elseif ($key == 'domain_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'department_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'location_name') {
                            $report_exp[$j][$key] = $val;
                        }
						  elseif ($key == 'usedby') {
                            $report_exp[$j][$key] = $val;
                        }
					    elseif($key == 'impact_name' || $key == 'product_name' || $key =='vender_name' || $key == 'asset_state' || $key == 'depreciation_type' || $key == 'salvage'  || $key == 'warranty_year'  || $key == 'warranty_month'|| $key == 'asset_tag' || $key == 'licence_key' || $key == 'installation_path' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'fname' || $key == 'lname' || $key == 'clnt_fname' || $key == 'clnt_lname' || $key == 'licence_type' || $key == 'status' || $key == 'staff_id') {
							$report_exp[$j][$key] = $val;	
						}
						/*elseif($key == 'installation_date' || $key == 'expiry_date'  || $key == 'last_audit_date'){
						$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);	
						}*/
						elseif($key == 'details')
						{
						$text = $val;
						$new_val = $this->strip_html_tags($text);
						 $report_exp[$j][$key] = $new_val;
						} elseif($key!='group_name' && $key !='ci_type_id' && $key !='ci_property_type' && $key !='impact_id' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='assets_state' && $key != 'status'  && $key != 'expiry_date') {
							$report_exp[$j][$key] = $val;
						} 
					}
						//for hardware assets
					 if($report_exp[$j]['ci_type_id'] == 2)
					{
					$report_exp1[$j]['Asset_name'] = $report_exp[$j]['name'];
					$report_exp1[$j]['Department'] = $report_exp[$j]['domain_name'].' : '.$report_exp[$j]['department_name'];
					$report_exp1[$j]['CI_Type'] = $report_exp[$j]['description'];
					$report_exp1[$j]['description'] = $report_exp[$j]['details'];
					if($report_exp[$j]['staff_id']===''){
						$report_exp1[$j]['managed_by'] = '---';
					}else{
						$report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					}
					$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
					if($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']=='')
					{
						$report_exp1[$j]['used_by']	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					}
					else{
						$report_exp1[$j]['used_by']	= $report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
					}
					$report_exp1[$j]['email'] = $report_exp[$j]['usedby'];
					$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
					$report_exp1[$j]['Location'] = $report_exp[$j]['location_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['product'] = $report_exp[$j]['product_name'];
					$report_exp1[$j]['vender'] = $report_exp[$j]['vender_name'];
					$report_exp1[$j]['warranty_year'] = $report_exp[$j]['warranty_year'];
					$report_exp1[$j]['warranty_month'] = $report_exp[$j]['warranty_month'];
					$report_exp1[$j]['acquisition_date'] = $report_exp[$j]['installation_date'];
					$report_exp1[$j]['warranty_expiry_date'] = $report_exp[$j]['expiry_date'];
					$report_exp1[$j]['asset_state'] = $report_exp[$j]['asset_state'];
					$report_exp1[$j]['asset_tag'] = $report_exp[$j]['asset_tag'];
					$report_exp1[$j]['serial_no'] = $report_exp[$j]['licence_key'];
					$report_exp1[$j]['last_audit_date'] = $report_exp[$j]['last_audit_date'];
					$report_exp1[$j]['cost'] = $report_exp[$j]['installation_path'];
					$report_exp1[$j]['salvage'] = $report_exp[$j]['salvage'];
					$report_exp1[$j]['depreciation_type'] = $report_exp[$j]['depreciation_type'];
					$report_exp1[$j]['expiry_date'] = $report_exp[$j]['status'];
					 
					}
					
					// for software assets
					 elseif($report_exp[$j]['ci_type_id'] == 3)
					 {
					$report_exp1[$j]['Asset_name'] = $report_exp[$j]['name'];
					$report_exp1[$j]['Department'] = $report_exp[$j]['domain_name'].' : '.$report_exp[$j]['department_name'];
					$report_exp1[$j]['CI_Type'] = $report_exp[$j]['description'];
					$report_exp1[$j]['description'] = $report_exp[$j]['details'];
					if($report_exp[$j]['staff_id']===''){
						$report_exp1[$j]['managed_by'] = '---';
					}else{
						$report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					}
					$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
					if($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']=='')
					{
						$report_exp1[$j]['used_by']	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					}
					else{
						$report_exp1[$j]['used_by']	= $report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
					}
					$report_exp1[$j]['email'] = $report_exp[$j]['usedby'];
					$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
					$report_exp1[$j]['Location'] = $report_exp[$j]['location_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['product'] = $report_exp[$j]['product_name'];
					$report_exp1[$j]['vender'] = $report_exp[$j]['vender_name'];
					$report_exp1[$j]['warranty_year'] = $report_exp[$j]['warranty_year'];
					$report_exp1[$j]['warranty_month'] = $report_exp[$j]['warranty_month'];
					$report_exp1[$j]['installation_date'] = $report_exp[$j]['installation_date'];
					$report_exp1[$j]['licence_expiry_date'] = $report_exp[$j]['expiry_date'];
					$report_exp1[$j]['licence_type'] = $report_exp[$j]['licence_type'];
					$report_exp1[$j]['cost'] = $report_exp[$j]['asset_tag'];
					$report_exp1[$j]['licence_key'] = $report_exp[$j]['licence_key'];
					$report_exp1[$j]['installation_path'] = $report_exp[$j]['installation_path'];
					$report_exp1[$j]['last_audit_date'] = $report_exp[$j]['last_audit_date'];
					$report_exp1[$j]['expiry_date'] = $report_exp[$j]['status'];
						   
					 }
					 //for other types of assets
					 else
					{
				    $report_exp1[$j]['Asset_name'] = $report_exp[$j]['name'];
					$report_exp1[$j]['Department'] = $report_exp[$j]['domain_name'].' : '.$report_exp[$j]['department_name'];
					$report_exp1[$j]['CI_Type'] = $report_exp[$j]['description'];
					$report_exp1[$j]['description'] = $report_exp[$j]['details'];
					if($report_exp[$j]['staff_id']===''){
						$report_exp1[$j]['managed_by'] = '---';
					}else{
						$report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					}
					$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
					if($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']=='')
					{
					$report_exp1[$j]['used_by']	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					}
					else{
					$report_exp1[$j]['used_by']	= $report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
					}
					$report_exp1[$j]['email'] = $report_exp[$j]['usedby'];
					$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
					$report_exp1[$j]['Location'] = $report_exp[$j]['location_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
						
					}
						 if($report_exp[$j]['ci_type_id'] == 2){
							 
						foreach($report_exp[$j] as $key=>$val){
						 
						if($key!='group_name' && $key !='ci_type_id' && $key !='ci_property_type' && $key !='domain_name' && $key !='department_name' && $key !='clnt_fname' && $key !='clnt_lname' && $key !='fname' && $key !='first_name' && $key !='last_name' && $key !='lname' && $key !='impact_id' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='asset_state' && $key!='email' && $key!='name' && $key!='assigned_on' && $key!='impact_name' && $key !='licence_type' && $key!='product_name' && $key!='vender_name' && $key!='location_name' && $key!='usedby' && $key != 'status' && $key!='') { // Newly added some more keys from email to onwards
						
							$report_exp1[$j][$key]=$val;
							
						}
						 
					}
				 } elseif($report_exp[$j]['ci_type_id'] == 3){
					 
					 foreach($report_exp[$j] as $key=>$val){
						 
						if($key!='group_name' && $key !='ci_type_id' && $key !='ci_property_type' && $key !='domain_name' && $key !='department_name'  && $key !='first_name' && $key !='last_name' && $key !='clnt_fname' && $key !='clnt_lname' && $key !='impact_id' && $key !='fname' && $key !='lname' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='asset_state' && $key!='email' && $key!='name' && $key!='assigned_on' && $key!='impact_name' && $key!='product_name' && $key!='vender_name' && $key!='location_name' && $key!='usedby' && $key != 'status' && $key!='') {
						
							$report_exp1[$j][$key]=$val;
							
						}
						 
					}
					 
				 }else{
					  
					 
					  foreach($report_exp[$j] as $key=>$val){        
						if($key!='group_name' && $key!='ci_type_id' && $key !='ci_property_type' && $key !='domain_name' && $key !='department_name' && $key !='first_name' && $key !='last_name' && $key !='clnt_fname' && $key !='clnt_lname' && $key !='impact_id' && $key !='fname' && $key !='lname' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='asset_state' && $key!='assets_id' && $key!='name' && $key!='usedby' && $key!='assigned_on' && $key !='attachment_id' && $key !='warranty_year' && $key !='warranty_month' && $key !='installation_date' && $key!='expiry_date' && $key !='asset_tag' && $key !='licence_key' && $key !='installation_path' && $key !='last_audit_date' && $key !='salvage' && $key !='depreciation_type' && $key !='impact_name' && $key !='product_name' && $key !='vender_name' && $key !='licence_type' && $key !='location_name' && $key!='email' && $key != 'status' && $key !=''){ 						
							$report_exp1[$j][$key]=$val;
							
						}
						 
					}
					 
				 }
					 
                    $j++;
                }
				
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;	// To display title which shows on report form
				//$report_exp1['Report_title'] = $operation['export_name']; // To display title which entered in request report popup form
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }else
                include(VIS_PATH_TEMPLATE . 'assets_usedby_client.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
         $database->database_disconnect();
        return true;		
		
	}
	
	function assets_managedby_staff_report($operation)
	{
		global $vis_language;
        $report_title = $vis_language['TXTASSETMANAGEDBYSTAFF'];
       	 $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
			
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
	    $citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
	    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
		
        $staff      = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
		    if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
             	$filter = $operation['filter'];
            }else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
				
                if($data['staff_id']==-1 && $data['vis_ci_type'] == ''){ // Newly added condition by Sachin E.
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
				}
				
				if ($data['staff_id'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
				
				if ($data['vis_ci_type'] == '') {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTITILSELECTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
				
				if ($data['staff_id'] != 0 && $data['vis_ci_type'] != '') {
					if($data['staff_id'] == -2){
						$filter = ' cmast.staff_id = "" and cmast.ci_type_id = '.$data['vis_ci_type'];
					}else{
                    	$filter = ' cmast.staff_id = '.$data['staff_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'];
					}
                } 
				else{
					if($data['staff_id'] == -2){
						$filter = ' cmast.staff_id = "" and cmast.ci_type_id = '.$data['vis_ci_type'];
					}else{
						$filter = ' cmast.ci_type_id = '.$data['vis_ci_type'];
					}
				}
				
                if($data['staff_id']== -2){
					$filter1 =" where avis_customfield.customgroup_id ='".$data['vis_ci_type']."' and avis_itil_cmdb_assets.staff_id=''";
				}else{
					$filter1 =' where avis_customfield.customgroup_id ='.$data['vis_ci_type'].' and avis_itil_cmdb_assets.staff_id='.$data['staff_id'];
				}
				
				$filter=$filter.'#'.$filter1;			
			}
					$temp_filtr = explode('#',$filter);
					 
				 	$filter = $temp_filtr[0];
				 	$filter1= $temp_filtr[1];
			 include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
             $object = new class_report($database);
			 $report = array();
             list($custom_fields_details,$report) = $object->get_assets_managedby_staff_report($filter,$filter1, VIS_STAFF_ID, VIS_LOCATION_AREA);
			  
			if($report!=1){
				for($i=0; $i<count($report); $i++){
			
					$is_expired =0;
					if($report[$i]['ci_type_id']==2 || $report[$i]['ci_type_id']==3){
						$total_month = ($report[$i]['warranty_year']*12)+$report[$i]['warranty_month'];
						$current_date = strtotime(date('Y-m-d h:i:s'));
						//$expiry_date = strtotime(date('Y-m-d h:i:s', $report[$i]['installation_date']) . $total_month.' month');
						if($report[$i]['warranty_year']==0 && $report[$i]['warranty_month']==0){
							if($report[$i]['expiry_date']>$report[$i]['installation_date']){
								$expiry_date = $report[$i]['expiry_date'];
							}else{
								$expiry_date = 0;
							}
						}else{
							$expiry_date = strtotime($total_month.' month',$report[$i]['installation_date']);
						}
						
						if($expiry_date==0){
							$report[$i]['status']= '--';
						}else if($expiry_date <= $current_date){
							//$report[$i]['status']=format_datetime($expiry_date);
							$report[$i]['status']=date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
						} else{
							//$report[$i]['status']='--';
							$report[$i]['status']=date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
							//format_datetime_rpt($expiry_date,$staff_id);
						}
					}else{
						$report[$i]['status']='--';
					}
				}//end for  
			}
																												
															
		$temp=array();
         $temp1=array();		
         $temp2=array();	 
		 $a=0;
		  
		for($i=0;$i<count($custom_fields_details);$i++) 
		{
			$a=$custom_fields_details[$i]['assets_id'];
			if($custom_fields_details[$i]['assets_id']!=$temp1[$a]['assets_id'])
			{$temp['assets_id']=$custom_fields_details[$i]['assets_id'];
		    $a=$custom_fields_details[$i]['assets_id'];
			}
			$temp[$custom_fields_details[$i]['field_name']]=$custom_fields_details[$i]['content'];
			$temp1[$a]=$temp;			 
		}
 
			$temp2=reset($temp1);
		     
			foreach($report as $key => $csm)
			{
				if(in_array($report[$key]['assets_id'],$temp1[$csm['assets_id']])){
					foreach($temp1[$csm['assets_id']] as $keys=>$val){
						if($keys!='assets_id')
							$report[$key][$keys]=$val;
					}
				}else{
					foreach($temp2 as $keys=>$val){
						if($keys!='assets_id')
							$report[$key][$keys]='';
					}
				}
			}
		 
		 
		 
		     if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j=0;
				foreach ($report as $assets_id => $i) {
                    foreach ($i as $key => $val) {
						if ($key == 'ci_type_id') {
                            $report_exp[$j][$key] = $val;
                        }
                        if ($key == 'name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'description') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'assigned_on') {
                           $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        } elseif($key == 'installation_date'){
							$report_exp[$j][$key] = date(VIS_EDITDATETIMEPICKER_FORMAT,$val);
						} elseif($key == 'expiry_date'){
							$report_exp[$j][$key] = date(VIS_EDITDATETIMEPICKER_FORMAT,$val);
						} elseif($key == 'last_audit_date'){
							$report_exp[$j][$key] = date(VIS_EDITDATETIMEPICKER_FORMAT,$val);
						} elseif ($key == 'domain_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'department_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'location_name') {
                            $report_exp[$j][$key] = $val;
                        }
						  elseif ($key == 'usedby') {
                            $report_exp[$j][$key] = $val;
                        }
					    elseif($key == 'impact_name' || $key == 'product_name' || $key =='vender_name' || $key == 'asset_state' || $key == 'depreciation_type' || $key == 'salvage'  || $key == 'warranty_year'  || $key == 'warranty_month'|| $key == 'asset_tag' || $key == 'licence_key' || $key == 'installation_path' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'fname' || $key == 'lname' || $key == 'clnt_fname' || $key == 'clnt_lname' || $key == 'licence_type' || $key == 'status' || $key =='staff_id') {
							$report_exp[$j][$key] = $val;	
						}
						/*elseif($key == 'installation_date' || $key == 'expiry_date'  || $key == 'last_audit_date'){
						$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);	
						}*/
						elseif($key == 'details')
						{
							$text = $val;
							$new_val = $this->strip_html_tags($text);
							$report_exp[$j][$key] = $new_val;
						}elseif($key !='ci_type_id' && $key !='impact_id' && $key !='warranty_month' && $key !='attachment_id' && $key !='warranty_year' && $key !='staff_id'  && $key !='expiry_date' && $key !='licence_key' && $key !='asset_tag' && $key !='depreciation_type'  && $key !='salvage'  && $key !='last_audit_date' && $key !='installation_path' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='assets_state'  ) {
							$report_exp[$j][$key] = $val;
						}
						
					 }
					 
					 //for hardware assets
					if($report_exp[$j]['ci_type_id'] == 2)
					{
					$report_exp1[$j]['Asset_name'] = $report_exp[$j]['name'];
					$report_exp1[$j]['Department'] = $report_exp[$j]['domain_name'].' : '.$report_exp[$j]['department_name'];
					$report_exp1[$j]['CI_Type'] = $report_exp[$j]['description'];
					$report_exp1[$j]['description'] = $report_exp[$j]['details'];
					if(!isset($report_exp[$j]['staff_id'])){
						$report_exp1[$j]['managed_by'] = '---';
					}else{
						$report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					}
					$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
					if($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']=='')
					{
						$report_exp1[$j]['used_by']	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					}
					else{
						$report_exp1[$j]['used_by']	= $report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
					}
					 
					$report_exp1[$j]['email'] = $report_exp[$j]['usedby'];
					$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
					$report_exp1[$j]['Location'] = $report_exp[$j]['location_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['product'] = $report_exp[$j]['product_name'];
					$report_exp1[$j]['vender'] = $report_exp[$j]['vender_name'];
					$report_exp1[$j]['warranty_year'] = $report_exp[$j]['warranty_year'];
					$report_exp1[$j]['warranty_month'] = $report_exp[$j]['warranty_month'];
					$report_exp1[$j]['acquisition_date'] = $report_exp[$j]['installation_date'];
					$report_exp1[$j]['warranty_expiry_date'] = $report_exp[$j]['expiry_date'];
					$report_exp1[$j]['asset_state'] = $report_exp[$j]['asset_state'];
					$report_exp1[$j]['asset_tag'] = $report_exp[$j]['asset_tag'];
					$report_exp1[$j]['serial_no'] = $report_exp[$j]['licence_key'];
					$report_exp1[$j]['last_audit_date'] = $report_exp[$j]['last_audit_date'];
					$report_exp1[$j]['cost'] = $report_exp[$j]['installation_path'];
					$report_exp1[$j]['salvage'] = $report_exp[$j]['salvage'];
					$report_exp1[$j]['depreciation_type'] = $report_exp[$j]['depreciation_type'];
					$report_exp1[$j]['expiry_date'] = $report_exp[$j]['status'];
					
					}
					  
					// for software assets
					 elseif($report_exp[$j]['ci_type_id'] == 3)
					 {
					$report_exp1[$j]['Asset_name'] = $report_exp[$j]['name'];
					$report_exp1[$j]['Department'] = $report_exp[$j]['domain_name'].' : '.$report_exp[$j]['department_name'];
					$report_exp1[$j]['CI_Type'] = $report_exp[$j]['description'];
					$report_exp1[$j]['description'] = $report_exp[$j]['details'];
					if(!isset($report_exp[$j]['staff_id'])){
						$report_exp1[$j]['managed_by'] = '---';
					}else{
						$report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					}
					$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
					if($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']=='')
					{
						$report_exp1[$j]['used_by']	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					}
					else{
						$report_exp1[$j]['used_by']	= $report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
					}
					$report_exp1[$j]['email'] = $report_exp[$j]['usedby'];
					$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
					$report_exp1[$j]['Location'] = $report_exp[$j]['location_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['product'] = $report_exp[$j]['product_name'];
					$report_exp1[$j]['vender'] = $report_exp[$j]['vender_name'];
					$report_exp1[$j]['warranty_year'] = $report_exp[$j]['warranty_year'];
					$report_exp1[$j]['warranty_month'] = $report_exp[$j]['warranty_month'];
					$report_exp1[$j]['installation_date'] = $report_exp[$j]['installation_date'];
					$report_exp1[$j]['licence_expiry_date'] = $report_exp[$j]['expiry_date'];
					$report_exp1[$j]['licence_type'] = $report_exp[$j]['licence_type'];
					$report_exp1[$j]['cost'] = $report_exp[$j]['asset_tag'];
					$report_exp1[$j]['licence_key'] = $report_exp[$j]['licence_key'];
					$report_exp1[$j]['installation_path'] = $report_exp[$j]['installation_path'];
					$report_exp1[$j]['last_audit_date'] = $report_exp[$j]['last_audit_date'];
					$report_exp1[$j]['expiry_date'] = $report_exp[$j]['status'];
					  
					  
					 }
					 //for other types of assets
					 else
					{
				    $report_exp1[$j]['Asset_name'] = $report_exp[$j]['name'];
					$report_exp1[$j]['Department'] = $report_exp[$j]['domain_name'].' : '.$report_exp[$j]['department_name'];
					$report_exp1[$j]['CI_Type'] = $report_exp[$j]['description'];
					$report_exp1[$j]['description'] = $report_exp[$j]['details'];
					if(!isset($report_exp[$j]['staff_id'])){
						$report_exp1[$j]['managed_by'] = '---';
					}else{
						$report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					}
					$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
					if($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']=='')
					{
						$report_exp1[$j]['used_by']	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					}
					else{
						$report_exp1[$j]['used_by']	= $report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
					}
					$report_exp1[$j]['email'] = $report_exp[$j]['usedby'];
					$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
					$report_exp1[$j]['Location'] = $report_exp[$j]['location_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					   
					}
					  if($report_exp[$j]['ci_type_id'] == 2){
							 
						foreach($report_exp[$j] as $key=>$val){
						 
						if($key!='group_name' && $key !='ci_type_id' && $key !='ci_property_type' && $key !='clnt_fname' && $key !='domain_name' && $key !='department_name' && $key !='clnt_lname' && $key !='fname' && $key !='first_name' && $key !='last_name' && $key !='lname' && $key !='impact_id' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='asset_state' && $key!='email' && $key!='name' && $key!='assigned_on' && $key!='impact_name' && $key!='product_name' && $key!='vender_name' && $key!='location_name' && $key !='licence_type' && $key!='usedby' && $key!='expiry_date' && $key!='status' && $key!='') {
						
							$report_exp1[$j][$key]=$val;
						}
					}
				 } elseif($report_exp[$j]['ci_type_id'] == 3){
					 foreach($report_exp[$j] as $key=>$val){
						 
						if($key!='group_name' && $key !='ci_type_id' && $key !='ci_property_type'  && $key !='clnt_fname' && $key !='first_name' && $key !='last_name' && $key !='domain_name' && $key !='department_name' && $key !='clnt_lname' && $key !='impact_id' && $key !='fname' && $key !='lname' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='asset_state' && $key!='email' && $key!='name' && $key!='assigned_on' && $key!='impact_name' && $key!='product_name' && $key!='vender_name' && $key!='location_name' && $key!='usedby' && $key!='expiry_date' && $key!='status' && $key!='') {
						
							$report_exp1[$j][$key]=$val;
						}
					}
				 }else{
					  foreach($report_exp[$j] as $key=>$val){        
						 if($key!='group_name' && $key!='ci_type_id' && $key !='ci_property_type' && $key !='domain_name' && $key !='department_name' && $key !='first_name' && $key !='last_name' && $key !='clnt_fname' && $key !='clnt_lname' && $key !='impact_id' && $key !='fname' && $key !='lname' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='asset_state' && $key!='assets_id' && $key!='name' && $key!='usedby' && $key!='assigned_on' && $key !='attachment_id' && $key !='warranty_year' && $key !='warranty_month' && $key !='installation_date' && $key!='expiry_date' && $key !='asset_tag' && $key !='licence_key' && $key !='installation_path' && $key !='last_audit_date' && $key !='salvage' && $key !='depreciation_type' && $key !='impact_name' && $key !='product_name' && $key !='vender_name' && $key !='licence_type' && $key !='location_name' && $key!='email' && $key!='status' && $key !=''){
						 
						
							$report_exp1[$j][$key]=$val;
							
						}
						 
					}
					 
				 }
						  
                    $j++;
                }
				  
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }else{
					 $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
				}
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }else
                include(VIS_PATH_TEMPLATE . 'assets_managedby_staff.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
         $database->database_disconnect();
        return true;
	}
	
	function assets_linkedto_tickets_report($operation)
	{
		global $vis_language;
        $report_title = $vis_language['TXTASSETLINKTOTICKETS'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
		 include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
	      $cmdb_obj = new class_cmdb($database);
	      $assets = $cmdb_obj->get_assets('', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
	      include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
           $setting_object=new class_setting($database);
	       $citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
		   
		 if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
				
				if($data['vis_asset_id'] == -1 && $data['vis_ci_type'] == ''){ // Newly added condition by Sachin E.
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
				}
				
                if ($data['vis_asset_id'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTASSETNAME'].' '.strtolower($vis_language['TXTISREQUIRED']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
				 if ($data['vis_ci_type'] == '') {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTITILSELECTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
				
				 if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != '') {
                    $filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 0 and cmast.ci_type_id = '.$data['vis_ci_type'];
                }
					$filter1 =' where  avis_customfield.customgroup_id ='.$data['vis_ci_type']. ' and  avis_itil_cmdb_assets.assets_id='.$data['vis_asset_id'];		
				$filter=$filter.'#'.$filter1;
			}
			$temp_filtr = explode('#',$filter);
					 
				 	$filter = $temp_filtr[0];
				 	$filter1= $temp_filtr[1];
			 include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
             $object = new class_report($database);
			 $report=array();
             //$report = $object->get_assets_linkedto_tickets_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			  list($custom_fields_details,$report) = $object->get_assets_linkedto_tickets_report($filter,$filter1, VIS_STAFF_ID, VIS_LOCATION_AREA); 
			 if($report!=1){
													
								for($i=0; $i<count($report); $i++){
									$is_expired =0;
									if($report[$i]['ci_type_id']==2 || $report[$i]['ci_type_id']==3){
										$total_month = ($report[$i]['warranty_year']*12)+$report[$i]['warranty_month'];
										$current_date = strtotime(date('Y-m-d h:i:s'));
										//$expiry_date = strtotime(date('Y-m-d h:i:s', $report[$i]['installation_date']) . $total_month.' month');
										if($report[$i]['warranty_year']==0 && $report[$i]['warranty_month']==0){
											if($report[$i]['expiry_date']>$report[$i]['installation_date']){
												$expiry_date = $report[$i]['expiry_date'];
											}else{
												$expiry_date = 0;
											}
										}else{
											$expiry_date = strtotime($total_month.' month',$report[$i]['installation_date']);
										}
										
										if($expiry_date==0){
											$report[$i]['status']= '--';
										}else if($expiry_date <= $current_date){
											//$report[$i]['status']=format_datetime($expiry_date);
											$report[$i]['status']=date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
										} else{
											//$report[$i]['status']='--';
											$report[$i]['status']=date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
											//format_datetime_rpt($expiry_date,$staff_id);
										}
									}else{
										$report[$i]['status']='--';
									}
																												
								}//end for
																									
					        }
							
							$temp=array();
         $temp1=array();		
         $temp2=array();	 
		 $a=0;
		  
		for($i=0;$i<count($custom_fields_details);$i++) 
		{
			$a=$custom_fields_details[$i]['assets_id'];
			if($custom_fields_details[$i]['assets_id']!=$temp1[$a]['assets_id'])
			{$temp['assets_id']=$custom_fields_details[$i]['assets_id'];
		    $a=$custom_fields_details[$i]['assets_id'];
			}
			$temp[$custom_fields_details[$i]['field_name']]=$custom_fields_details[$i]['content'];
			$temp1[$a]=$temp;			 
		}
 
			$temp2=reset($temp1);
		     
			foreach($report as $key => $csm)
			{
				if(in_array($report[$key]['assets_id'],$temp1[$csm['assets_id']])){

					foreach($temp1[$csm['assets_id']] as $keys=>$val){
					if($keys!='assets_id')
					$report[$key][$keys]=$val;
				}
			}else{

					foreach($temp2 as $keys=>$val){
					if($keys!='assets_id')
					$report[$key][$keys]='';
					}
				}
		   
			
																									
			}
							
		     if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j=0;
				foreach ($report as $assets_id => $i) {
                    foreach ($i as $key => $val) {
						if ($key == 'ci_type_id') {
                            $report_exp[$j][$key] = $val;
                        }
                        if ($key == 'name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'description') {
                            $report_exp[$j][$key] = $val;
                        }  elseif ($key == 'assigned_on') {
                           $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        } elseif($key == 'installation_date'){
							$report_exp[$j][$key] = date(VIS_EDITDATETIMEPICKER_FORMAT,$val);
						} elseif($key == 'expiry_date'){
							$report_exp[$j][$key] = date(VIS_EDITDATETIMEPICKER_FORMAT,$val);
						} elseif($key == 'last_audit_date'){
							$report_exp[$j][$key] = date(VIS_EDITDATETIMEPICKER_FORMAT,$val);
						} elseif ($key == 'ticket_hash') {
                            $report_exp[$j][$key] =($val);
                        } elseif ($key == 'domain_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'department_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'location_name') {
                            $report_exp[$j][$key] = $val;
                        }elseif ($key == 'subject') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'usedby') {
                            $report_exp[$j][$key] = $val;
                        }
						elseif($key == 'impact_name' || $key == 'product_name' || $key =='vender_name' || $key == 'asset_state' || $key == 'depreciation_type' || $key == 'salvage'  || $key == 'warranty_year'  || $key == 'warranty_month'|| $key == 'asset_tag' || $key == 'licence_key' || $key == 'installation_path' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'fname' || $key == 'lname' || $key == 'clnt_fname' || $key == 'clnt_lname' || $key == 'licence_type' || $key == 'status' || $key =='staff_id') {
							$report_exp[$j][$key] = $val;	
						}
						/*elseif($key == 'installation_date' || $key == 'expiry_date'  || $key == 'last_audit_date'){
						$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);	
						}*/
						elseif($key == 'details')
						{
						$text = $val;
						$new_val = $this->strip_html_tags($text);
						 $report_exp[$j][$key] = $new_val;
						}elseif($key!='group_name' && $key !='ci_type_id' && $key !='impact_id' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='assets_state'  ) {
							$report_exp[$j][$key] = $val;
						} 
						 
					 }
					 
					//for hardware assets
					if($report_exp[$j]['ci_type_id'] == 2)
					{
					$report_exp1[$j]['Ticket_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['Subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['Asset_name'] = $report_exp[$j]['name'];
					$report_exp1[$j]['Department'] = $report_exp[$j]['domain_name'].' : '.$report_exp[$j]['department_name'];
					$report_exp1[$j]['CI_Type'] = $report_exp[$j]['description'];
					$report_exp1[$j]['description'] = $report_exp[$j]['details'];
					if(!isset($report_exp[$j]['staff_id'])){
						$report_exp1[$j]['managed_by'] = '---';
					}else{
						$report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					}
					$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
					if($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']=='')
					{
					$report_exp1[$j]['used_by']	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					}
					else{
					$report_exp1[$j]['used_by']	= $report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
					}
					$report_exp1[$j]['email'] = $report_exp[$j]['usedby'];
					$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
					$report_exp1[$j]['Location'] = $report_exp[$j]['location_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['product'] = $report_exp[$j]['product_name'];
					$report_exp1[$j]['vender'] = $report_exp[$j]['vender_name'];
					$report_exp1[$j]['warranty_year'] = $report_exp[$j]['warranty_year'];
					$report_exp1[$j]['warranty_month'] = $report_exp[$j]['warranty_month'];
					$report_exp1[$j]['acquisition_date'] = $report_exp[$j]['installation_date'];
					$report_exp1[$j]['warranty_expiry_date'] = $report_exp[$j]['expiry_date'];
					$report_exp1[$j]['asset_state'] = $report_exp[$j]['asset_state'];
					$report_exp1[$j]['asset_tag'] = $report_exp[$j]['asset_tag'];
					$report_exp1[$j]['serial_no'] = $report_exp[$j]['licence_key'];
					$report_exp1[$j]['last_audit_date'] = $report_exp[$j]['last_audit_date'];
					$report_exp1[$j]['cost'] = $report_exp[$j]['installation_path'];
					$report_exp1[$j]['salvage'] = $report_exp[$j]['salvage'];
					$report_exp1[$j]['depreciation_type'] = $report_exp[$j]['depreciation_type'];
					$report_exp1[$j]['expiry_date'] = $report_exp[$j]['status'];
					}
					// for software assets
					 elseif($report_exp[$j]['ci_type_id'] == 3)
					 {
					$report_exp1[$j]['Ticket_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['Subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['Asset_name'] = $report_exp[$j]['name'];
					$report_exp1[$j]['Department'] = $report_exp[$j]['domain_name'].' : '.$report_exp[$j]['department_name'];
					$report_exp1[$j]['CI_Type'] = $report_exp[$j]['description'];
					$report_exp1[$j]['description'] = $report_exp[$j]['details'];
					if(!isset($report_exp[$j]['staff_id'])){
						$report_exp1[$j]['managed_by'] = '---';
					}else{
						$report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					}
					$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
					if($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']=='')
					{
					$report_exp1[$j]['used_by']	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					}
					else{
					$report_exp1[$j]['used_by']	= $report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
					}
					$report_exp1[$j]['email'] = $report_exp[$j]['usedby'];
					$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
					$report_exp1[$j]['Location'] = $report_exp[$j]['location_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['product'] = $report_exp[$j]['product_name'];
					$report_exp1[$j]['vender'] = $report_exp[$j]['vender_name'];
					$report_exp1[$j]['warranty_year'] = $report_exp[$j]['warranty_year'];
					$report_exp1[$j]['warranty_month'] = $report_exp[$j]['warranty_month'];
					$report_exp1[$j]['installation_date'] = $report_exp[$j]['installation_date'];
					$report_exp1[$j]['licence_expiry_date'] = $report_exp[$j]['expiry_date'];
					$report_exp1[$j]['licence_type'] = $report_exp[$j]['licence_type'];
					$report_exp1[$j]['cost'] = $report_exp[$j]['asset_tag'];
					$report_exp1[$j]['licence_key'] = $report_exp[$j]['licence_key'];
					$report_exp1[$j]['installation_path'] = $report_exp[$j]['installation_path'];
					$report_exp1[$j]['last_audit_date'] = $report_exp[$j]['last_audit_date'];
					$report_exp1[$j]['expiry_date'] = $report_exp[$j]['status'];
					 
					}
					 //for other types of assets
					 else
					{
					$report_exp1[$j]['Ticket_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['Subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['Asset_name'] = $report_exp[$j]['name'];
					$report_exp1[$j]['Department'] = $report_exp[$j]['domain_name'].' : '.$report_exp[$j]['department_name'];
					$report_exp1[$j]['CI_Type'] = $report_exp[$j]['description'];
					$report_exp1[$j]['description'] = $report_exp[$j]['details'];
					if(!isset($report_exp[$j]['staff_id'])){
						$report_exp1[$j]['managed_by'] = '---';
					}else{
						$report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					}
					$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
					if($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']=='')
					{
					$report_exp1[$j]['used_by']	= $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					}
					else{
					$report_exp1[$j]['used_by']	= $report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname'];	
					}
					$report_exp1[$j]['email'] = $report_exp[$j]['usedby'];
					$report_exp1[$j]['Assigned_on'] = $report_exp[$j]['assigned_on'];
					$report_exp1[$j]['Location'] = $report_exp[$j]['location_name'];
					$report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
					 
						 
					}
					  if($report_exp[$j]['ci_type_id'] == 2){
							 
						foreach($report_exp[$j] as $key=>$val){
						 
						if($key!='group_name' && $key !='ci_property_type' && $key !='ci_type_id' && $key !='domain_name' && $key !='department_name' && $key !='clnt_fname' && $key !='clnt_lname' && $key !='fname' && $key !='first_name' && $key !='last_name' && $key !='lname' && $key !='impact_id' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='asset_state' && $key!='email' && $key!='name' && $key!='assigned_on' && $key!='impact_name' && $key!='product_name' && $key!='vender_name' && $key!='location_name' && $key!='usedby' && $key!='ticket_hash' && $key !='licence_type' && $key!='subject' && $key!='expiry_date' && $key!='status' && $key!='') {
						
							$report_exp1[$j][$key]=$val;
							
						}
						 
					}
				 } elseif($report_exp[$j]['ci_type_id'] == 3){
					 
					 foreach($report_exp[$j] as $key=>$val){
						 
						if($key!='group_name' && $key !='ci_type_id' && $key !='ci_property_type '  && $key !='domain_name' && $key !='department_name' && $key !='clnt_fname' && $key !='clnt_lname' && $key !='first_name' && $key !='last_name' && $key !='impact_id' && $key !='fname' && $key !='lname' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='asset_state' && $key!='email' && $key!='name' && $key!='assigned_on' && $key!='impact_name' && $key!='product_name' && $key!='vender_name' && $key!='location_name' && $key!='usedby' && $key!='ticket_hash' && $key!='subject' && $key!='expiry_date' && $key!='status' && $key!='') {
						
							$report_exp1[$j][$key]=$val;
							
						}
						 
					}
					 
				 }else{
					  
					 
					  foreach($report_exp[$j] as $key=>$val){        
						 if($key!='group_name' && $key!='ci_type_id' && $key !='ci_property_type' && $key !='domain_name' && $key !='department_name' && $key !='first_name' && $key !='last_name' && $key !='clnt_fname' && $key !='clnt_lname' && $key !='impact_id' && $key !='fname' && $key !='lname' && $key !='staff_id' && $key !='location_id' && $key !='vendor_id' && $key !='department_access' && $key !='product_id' && $key !='asset_state' && $key!='assets_id' && $key!='name' && $key!='usedby' && $key!='assigned_on' && $key !='attachment_id' && $key !='warranty_year' && $key !='warranty_month' && $key !='installation_date' && $key!='expiry_date' && $key !='asset_tag' && $key !='licence_key' && $key !='installation_path' && $key !='last_audit_date' && $key !='salvage' && $key !='depreciation_type' && $key !='impact_name' && $key !='product_name' && $key !='vender_name' && $key !='licence_type' && $key !='location_name' && $key!='email' && $key!='ticket_hash' && $key!='subject' && $key!='status' && $key !=''){
						 
						
							$report_exp1[$j][$key]=$val;
							
						}
						 
					}
					 
				 }
					
                    $j++;
                }
				  
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;	// To display title which shows on report form
				//$report_exp1['Report_title'] = $operation['export_name']; // To display title which entered in request report popup form
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }else
                include(VIS_PATH_TEMPLATE . 'assets_linkedto_tickets.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
         $database->database_disconnect();
        return true;
	}
	
	function releases_linkedto_changes_report($operation)
	{
		 global $vis_language;
        $report_title = $vis_language['TXTRELEASELINKEDTOCHANGES'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
		
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
				
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                $currentdate = date('Y-m-d h:i:s');
				if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                   
				    $filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 ';
					
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
					if($data['vis_priority_condition']==0)
					
					$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 ';
					
                    
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
					if($data['vis_priority_condition']==0)
					
					$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 ';
					
                   
                }
                 else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to   = strtotime($data['to_date']) - VIS_TIMEZONE;
					
					$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 ';
			    }
			
			}
			 include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
             $object = new class_report($database);
             $report = $object->get_releases_linkedto_changes_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		     if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j=0;
                foreach ($report as $changes_id => $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'changes_hash') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'subject') {
                            $report_exp[$j][$key] = $val;
                        }  elseif ($key == 'release_hash') {
                            $report_exp[$j][$key] =($val);
                        } elseif ($key == 'date_created') {
                            $report_exp[$j][$key] =  format_datetime_rpt($val,$staff_id);
                        } elseif ($key == 'first_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'last_name') {
                            $report_exp[$j][$key] = $val;
                        }
					 }
					$report_exp1[$j]['Changes_hash'] = $report_exp[$j]['changes_hash'];
					$report_exp1[$j]['Subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['Release_hash'] = $report_exp[$j]['release_hash'];
					$report_exp1[$j]['Created_by'] = $report_exp[$j]['first_name'].' '. $report_exp[$j]['last_name'];
					$report_exp1[$j]['Create_date'] =  $report_exp[$j]['date_created'];
					
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }else
                include(VIS_PATH_TEMPLATE . 'releases_linkedto_changes.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
         $database->database_disconnect();
        return true;
		
	}
	
	function changes_resolvedby_staff_report($operation)
	{
	global $vis_language;
    $report_title = $vis_language['TXTCHANGESRESOLVEDBYSTAFF'];
	 $export       = 1;
     if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
           $database = new class_database('mysql', 1);
        else
            $database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object  = new class_ticket($database);
        $departments = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        $object_staff = new class_staff($database);
        $staff_filter  = "staff_id =" . VIS_STAFF_ID;
        $staff_details = $object_staff->get_staff($staff_filter, $userid, $user);
        $dept_ids    = '';
        for ($d = 0; $d < count($departments); $d++) {
            $dept_ids .= $departments[$d]['department_id'] . ',';
        }
        if ($dept_ids != '') {
            $dept_ids = substr($dept_ids, 0, -1);
        }
        $dept_id  = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
        //$access = $staff_details[0]['department_access'];
        $staff_list    = $object_staff->get_staff('is_enabled=1 ', VIS_STAFF_ID, VIS_LOCATION_AREA, '');
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'c.date_created between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and a.operator_id=' . $data['staff_id'];
                    } else {
                        $filter =  'c.date_created between  '.$monthDate. ' AND '.strtotime($currentdate).' and c.department_id in'.'('.$dept_id.')';
                        //$filter = 'date_created between  ' . $monthDate . ' AND ' . strtotime($currentdate);
                    }
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'c.date_created between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and a.operator_id=' . $data['staff_id'];
                    } else {
                        $filter   =  'c.date_created between '.$weekDate.' AND '.strtotime($currentdate).' and c.department_id in'.'('.$dept_id.')';
                       // $filter = 'date_created between ' . $weekDate . ' AND ' . strtotime($currentdate);
                    }
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'c.date_created between ' . $hour . ' AND ' . strtotime($currentdate) . ' and a.operator_id=' . $data['staff_id'];
                    } else {
                        $filter =  'c.date_created between '.$hour.' AND '.strtotime($currentdate).' and c.department_id in'.'('.$dept_id.')'; 
                       // $filter = 'date_created between ' . $hour . ' AND ' . strtotime($currentdate);
                    }
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to   = strtotime($data['to_date']) - VIS_TIMEZONE;
                    if ($data['staff_id'] != 0) {
                        $filter = 'c.date_created between ' . $from . ' AND ' . $to . ' and a.operator_id=' . $data['staff_id'];
                    } else {
                        $filter = 'c.date_created between '.$from.' AND '.$to.' and c.department_id in'.'('.$dept_id.')'; 
                       // $filter = 'date_created between ' . $from . ' AND ' . $to;
                    }
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            $report = $object->get_changes_resolvedby_staff_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
           
		   if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                for ($i = 0; $i < count($report); $i++) {
                    if ($report[$i]['first_name'] == '') {
                       $report[$i]['first_name'] = 'Nobody';
                    }
               }
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j=0;
				foreach($report as $problem_details){
					
					foreach($problem_details as $key => $val){
						
						if($key == 'changes_hash'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'subject'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'fname'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'lname'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'receive_date'){
						$report_exp[$j][$key] = format_datetime($val);
						}
						elseif($key == 'first_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'last_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'frst_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'lst_name'){
						$report_exp[$j][$key] = $val;
						}
						
					}
					
				 $report_exp1[$j]['changes_hash'] = $report_exp[$j]['changes_hash'];
				 $report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
				 $report_exp1[$j]['created_by'] = $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
				 $report_exp1[$j]['assigned_to'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
				 $report_exp1[$j]['resolved_date'] = $report_exp[$j]['receive_date'];
                 $report_exp1[$j]['resolved_by'] = $report_exp[$j]['frst_name'].' '.$report_exp[$j]['lst_name'];				 
				 
					
                    $j++;
                }
				
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'changes_resolvedby_staff_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
		
	}
	

    
    function customfield_data_userreg_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTCSTRPTUSRREG'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
			
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        $object_staff = new class_staff($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $object_setting   = new class_setting($database);
        $filter           = 'location=0';
        $custom_grouplist = $object_setting->get_custom_group_list($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        for ($i = 0; $i < count($custom_grouplist); $i++) {
            $filter = ' ' . VIS_TABLE_PREFIX . 'customfield.customgroup_id=' . $custom_grouplist[$i]['customgroup_id'] . ' and ' . VIS_TABLE_PREFIX . 'customfield.is_enabled=1 ';
            list($customfield_info, $customfield_details) = $object_setting->get_customfield(0, $filter, '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
            $customfield_userreg_array[] = $customfield_details;
        }
        //echo '<pre>';
        //print_r($customfield_userreg_array);
        
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter_new = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
				if ($data['userfield_name'] == "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['userfield_name'] != 0) {
                    $filter_new = 'cf.field_group=' . $data['userfield_name'];
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object      = new class_report($database);
            $report      = $object->get_customfield_data_report_for_userreg($filter_new, VIS_STAFF_ID, VIS_LOCATION_AREA);
            $custFilter1 = ' (location in (3))  and is_enabled=1 ';
            $custom_grouplist = $object_setting->get_custom_group_list($custFilter1, VIS_STAFF_ID, VIS_LOCATION_AREA);
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'first_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'last_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'email'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'group_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'field_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'content'){
						$report_exp[$j][$key] = $val;
						}
						
					}
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];				
					$report_exp1[$j]['field_name'] = $report_exp[$j]['field_name']; 
					$report_exp1[$j]['field_value'] = $report_exp[$j]['content']; 
					
                    $j++;
                }
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'customfield_data_report_for_userreg.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
			
        $database->database_disconnect();
        return true;

	}
   
    function download_html($operation)
    {
        $data = explode('/',$operation['vis_action']);
		$filename = $data[3];  		  
        header('Content-type: text/html');
        header("Content-Type: application/force-download");
		header("Content-Type: application/octet-stream");
		header("Content-Type: application/download");
        header("Content-Disposition: attachment;filename=".$filename.".html");       
        $file = fopen(VIS_PATH_DOWNLOADS.$filename.'.html', "r");
        echo fread($file, filesize(VIS_PATH_DOWNLOADS .$filename. '.html'));
        fclose($file);
    }
	
    function email_send_download($operation)
    {
        
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        if ($operation['export_id'] == '') {
            $exportid = $operation['vis_export'];
        } else
            $exportid = $operation['export_id'];
        $filter = VIS_TABLE_PREFIX . 'exportlist.export_id=' . $exportid;
        
        
        $report = $object->download_queue_list('', $filter, $operation['staff_id']);
       
        if ($report) {
            
            $data = $report[1][0];
            global $operation_hnd;
            $data['vis_module']    = 'report';
            $data['vis_operation'] = 'report_atachment';
			 
				  						
            $operation_hnd->operation_flow($data, $data['staff_id'], VIS_LOCATION_AREA, $database);
            
            
            echo true;
        }
    }
    
    function add_schedule_report_inqueue($operation)
    {
        global $vis_language;
								$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
								if(isset($operation['report_type']) && $operation['report_type']==14)
								{
									if(isset($operation['vis_filter_id']) && $operation['vis_filter_id']!=0)
								{
											$filter=$ticket_object->get_filter($operation['vis_filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
										if($filter != ""){
											$operation['vis_title']=$filter['filter_name'];
										}
								}
								}
								
        $message_info['vis_form_title'] = $vis_language['TXTSCHEDULEREPORT'];
        $message_info['vis_message']    = $vis_language['MSGSURE'];
        include(VIS_PATH_TEMPLATE . 'request_schedule_report.php');
        return true;
    }
    
 
      function request_schedule_report($data)
    {
        global $vis_language;
        $database    = new class_database();
        $currentdate = strtotime(date('Y-m-d h:i:s'));
        $report_id   = $data['report_type']; //get report_type
        $data['end_date'] = strtotime($data['end_date']);        
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff = new class_staff($database);
		$staff_filter  = "staff_id =" . VIS_STAFF_ID;
		$staff_details = $object_staff->get_staff($staff_filter, $userid, $user);
		$staff_timezone   = $staff_details[0]['timezone'];
        //$data['start_date']=strtotime($data['start_date']);
       
           
        if ($data['current_operation'] == '' || $data['current_operation'] == 'update') 
        {
				if ($data['report_title'] == '') {
                
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGREPORTNAME'] . '"); </script>';
                return false;
            } elseif ($data['end_date'] == '') {
                
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
                return false;
            } elseif (strtotime($data['start_date']) == '') {
                
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
                return false;
            } elseif ($data['end_date'] < strtotime($data['start_date'])) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSCHEDULEENDDATE'] . '"); </script>';
                return false;
            }elseif ($data['send_email'] == 1 && $data['email_id'] == '') {
                
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGEMAILMISS'] . '"); </script>';
                return false;
            } else if ($data['send_email'] == 1 && $data['email_id'] != ""){
		 
            list($message, $flag) = check_email_validation($data['email_id']);
						if(!$flag) {
							echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
							return false;
 
									}
			}
			 
            if ($data['current_operation'] == 'update' && $data['start_hidden_date']!=strtotime($data['start_date'])) {
				
				if (strtotime($data['start_date'])< $currentdate) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSTARTDATEVALIDATION'] . '"); </script>';
                return false;
				}
            }else if ($data['current_operation'] == ''){
				
				if (strtotime($data['start_date'])<$currentdate) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSTARTDATEVALIDATION'] . '"); </script>';
                return false;
				}
			} 
            
		}
		   
        switch ($data['schedule_type']) {
			
          	case 0: // once schedule
                if ($data['current_operation'] == '' || $data['current_operation'] == 'update') {
					
						$from_date = strtotime($data['start_date']) - $staff_timezone ;
					
                }                
                $to_date = $data['creation_date'] = $data['end_date'];
				$total_count=1;
              
                break;  
            case 1: // daily schedule
                if ($data['current_operation'] == '' || $data['current_operation'] == 'update' ) {
					$from_date = strtotime($data['start_date']) - $staff_timezone ;                                    
                } else {
                   $from_date = $data['creation_date'] - $staff_timezone  ;                    
                }
                if(isset($data['vis_form']))
                {				
					if(strtotime($data['start_date'])< $currentdate && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['export_type1']!=$data['export_type'])
					{ $to_date = $data['creation_date'] = strtotime("+1 day", $currentdate + $staff_timezone) ;	}
					else{$to_date = $data['creation_date'];}
                
					if(strtotime($data['start_date'])>= $currentdate && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['export_type1']!=$data['export_type']) 
					{$to_date =$data['creation_date'] = strtotime("+1 day", $from_date + $staff_timezone) ;	}
					else{$to_date = $data['creation_date'];}
                 		
					if(strtotime($data['start_date'])< $currentdate && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type'])
					{
						$end_date=$data['end_date'];
						$diff = ($end_date- $currentdate)/24/3600; 
						$total_count=(int)($diff);
					}
					else if(strtotime($data['start_date'])>=$currentdate && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type'])
					{
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$total_count=(int)($diff);
					}
				}else
				{
					
					$to_date =$data['creation_date'] = strtotime("+1 day", $from_date + $staff_timezone) ;						
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$total_count=(int)($diff);
					
				}
                break;
            case 2: // week schedule
                if ($data['current_operation'] == '' || $data['current_operation'] == 'update') {
                    $from_date = strtotime($data['start_date']) - $staff_timezone;
                } else {
                    $from_date = $data['creation_date'] - $staff_timezone;
                }
                if(isset($data['vis_form']))
                {
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type'])
					{$to_date = $data['creation_date'] = strtotime("+1 week", $currentdate + $staff_timezone);}
					else{$to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])>= $currentdate && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type'])
					{$to_date =$data['creation_date'] = strtotime("+1 week", $from_date + $staff_timezone);	}
					else{$to_date = $data['creation_date'];}
				  
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type'])
					{
						$end_date=$data['end_date'];
						$diff = ($end_date- $currentdate)/24/3600; 
						$interval = $diff/7;
						$total_count=(int)($interval);
					}else if(strtotime($data['start_date'])>= $currentdate && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type'])
					{
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$interval = $diff/7;
						$total_count=(int)($interval);
					}
				}else
				{
					$to_date =$data['creation_date'] = strtotime("+1 week", $from_date + $staff_timezone);	
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$interval = $diff/7;
					$total_count=(int)($interval);
				}
			
                break;
            case 3: // month schedule
                if ($data['current_operation'] == '' || $data['current_operation'] == 'update') {
                    $from_date = strtotime($data['start_date']) - $staff_timezone;
                } else {
                    $from_date = $data['creation_date'] - $staff_timezone;
                }
                if(isset($data['vis_form']))
                {
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['export_type1']!=$data['export_type'])
					{ $to_date = $data['creation_date'] = strtotime("+1 month", $currentdate + $staff_timezone) ;	}
					else{$to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])>= $currentdate && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type'])
					{ $to_date =$data['creation_date'] = strtotime("+1 month", $from_date + $staff_timezone) ;	}
					else{$to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type'])
					{
					$end_date=$data['end_date'];
					$diff = ($end_date- $currentdate)/24/3600; 
					$interval = $diff/30;
					$total_count=(int)($interval);
					}else if(strtotime($data['start_date'])>= $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type'])				
					{
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$interval = $diff/30;
						$total_count=(int)($interval);
					}
				}else
				{
					$to_date =$data['creation_date'] = strtotime("+1 month", $from_date + $staff_timezone);
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$interval = $diff/30;
					$total_count=(int)($interval);	
				}
                //echo "month creation :  ".$to_date;
                break;
            case 4: // quarter schedule
                if ($data['current_operation'] == '' || $data['current_operation'] == 'update') {
                  $from_date = strtotime($data['start_date']) - $staff_timezone;
                } else {
                 $from_date = $data['creation_date'] - $staff_timezone;
                }
                if(isset($data['vis_form']))
                {
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type'])
					{$to_date = $data['creation_date'] = strtotime("+3 month", $currentdate + $staff_timezone) ;	}
					else{$to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])>=$currentdate  && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type'])
					{  $to_date =$data['creation_date'] = strtotime("+3 month", $from_date + $staff_timezone) ;	}
					else{$to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date']|| $data['export_type1']!=$data['export_type'])
					{
						$end_date=$data['end_date'];
						$diff = ($end_date- $currentdate)/24/3600; 
						$interval = $diff/30;
						$quater=$interval/3;
						$total_count=(int)($quater);
					}else if(strtotime($data['start_date'])>= $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date']|| $data['export_type1']!=$data['export_type'])
					{
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$interval = $diff/30;
						$quater=$interval/3;
						$total_count=(int)($quater);
					}
				}else
				{
					$to_date =$data['creation_date'] = strtotime("+3 month", $from_date + $staff_timezone);
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$interval = $diff/30;
					$quater=$interval/3;
					$total_count=(int)($quater);
					
				}
                break;
            case 5: // year schedule
                if ($data['current_operation'] == '' || $data['current_operation'] == 'update') {
                    $from_date = strtotime($data['start_date']) - $staff_timezone;
                } else {
                    $from_date = $data['creation_date'] - $staff_timezone;
                }
                 if(isset($data['vis_form']))
                {
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type'])
					{ $to_date = $data['creation_date'] = strtotime("+1 year", $currentdate + $staff_timezone) ;	}
					else{$to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])>=$currentdate  && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type'])
					{ $to_date =$data['creation_date'] = strtotime("+1 year", $from_date + $staff_timezone) ;	}
					else{$to_date = $data['creation_date'];}
					 
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date']|| $data['export_type1']!=$data['export_type'])
					{
						$end_date=$data['end_date'];
						$diff = ($end_date- $currentdate)/24/3600; 
						$interval = $diff/365;
						$total_count=(int)($interval);
					}else if(strtotime($data['start_date'])>=$currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date']|| $data['export_type1']!=$data['export_type'])
					{
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$interval = $diff/365;
						$total_count=(int)($interval);
					}
			    }else
			    {
					$to_date =$data['creation_date'] = strtotime("+1 year", $from_date + $staff_timezone) ;
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$interval = $diff/365;
					$total_count=(int)($interval);
				}
			
                break;
        }
         
        switch ($report_id) {
            case 1: // Work report
                $date_range_filter = 'entry_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = 'operation_id!=9 AND operation_id<100 and operator!=1 and operator_id=' . $data['staff_id'];
                
                break;
            case 2: // Department SLA
                $date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = 'operation_id<=2 and ' . VIS_TABLE_PREFIX . 'ticket.department_id=' . $data['department_id'];
                
                
                break;
            
            case 3: // response
                $date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = 'department_id=' . $data['department_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                
                break;
            case 4: // Response
                
                $date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = '(submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                
                break;
            case 6: //Client SLA Report
                $date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = 'operation_id<=2 and '. VIS_TABLE_PREFIX .'ticket.client_id=' . $data['vis_client_id'];
                
                break;
            case 7: // Billing Report	
				$filter = 'domain_id='.$data['domain_id'];
                $date_range_filter     = 'entry_date between ' . $from_date . ' AND ' . $to_date . '';
                $data['department_id'] = $data['domain_id'];
                break;
            case 8: // Rating Report per department 
                $date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = 'department_id=' . $data['department_id']. ' and avis_customfield_data.content!=" "';
                
                 
                break;
            case 9: // Time tracking per staff
                $date_range_filter = 'created_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = 'staff_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'domain.domain_id=' . $data['domain_id'];
				
				 $filter .= ' AND  avis_ticket.is_deleted=0 AND avis_ticket.is_spam=0 ';
                
                break;
            case 10: // Time tracking per department
                $date_range_filter = 'created_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = 'department_id=' . $data['department_id'];
                
                break;
            case 11: // Client Group Tickets
                if ($data['domain_id'] == 0)
                    $domainId = " ";
                else
                    $domainId = ' AND ' . VIS_TABLE_PREFIX . 'client.domain_id = ' . $data['domain_id'];
                
                $date_range_filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from_date . ' AND ' . $to_date . $domainId;
                $filter            = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'];
                
                break;
            case 12: //Survey
                
                $date_range_filter     = 'entry_date between ' . $from_date . ' AND ' . $to_date . '';
                $data['department_id'] = $data['survey_id'];
                break;
            case 13: //Client survey
                $filter                = VIS_TABLE_PREFIX . 'customfield_data.parent_id = ' . $data['vis_client_id'] . ' && ' . VIS_TABLE_PREFIX . 'customgroup.location = 4 group by ' . VIS_TABLE_PREFIX . 'customgroup.customgroup_id order by entry_date desc';
                $data['department_id'] = $data['vis_client_id'];
                break;
            case 14: // Ticket
																include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                $rep_object   = new class_report($database);
                include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
                $object   = new class_ticket($database);
				if(isset($data['date_range_filter']) && $data['date_range_filter']!=''){
					$filterid=$data['date_range_filter'];
				}else{
					$filterid = $data['vis_filter_id'];
					$data['date_range_filter']=$data['vis_filter_id'];
				}
                
                $filter   = $object->get_filter($filterid, VIS_STAFF_ID, VIS_LOCATION_AREA);
																$filterdt   = $rep_object->getcustomfilterdetail('filter_id='.$filterid.' and (base_criteria=16 or base_criteria=12)', VIS_STAFF_ID, VIS_LOCATION_AREA);
															
																if($filterdt!=-1){
																	list($filterfrom_date,$filterpto_date)=explode('=',$filterdt[0]['content']); 
																	$filterfrom_date=$filterfrom_date - VIS_TIMEZONE;
																	$filterpto_date= $filterpto_date - VIS_TIMEZONE;
																	
																	if($filterdt[0]['base_criteria']==16){
																				$filter   = str_replace($filterfrom_date,$from_date,$filter['filter']);
																				$filter   = str_replace($filterpto_date,$to_date,$filter);
																	}else{
																	$repfrom_date='unix_timestamp("'.date('Y-m-d H:i:s', $filterfrom_date).'")';
																	$repto_date='unix_timestamp("'.date('Y-m-d H:i:s', $filterpto_date).'")';
																	$from_date1='unix_timestamp("'.date('Y-m-d H:i:s', $from_date).'")';
																	$to_date1='unix_timestamp("'.date('Y-m-d H:i:s', $to_date).'")';
																	
																	$filter   = str_replace($repfrom_date,$from_date1,$filter['filter']);
																	 $filter   = str_replace($repto_date,$to_date1,$filter);
																	
																	}
																}else{
                $filter   = $filter['filter'];
																}
													   break;
            case 15: // client
                include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
                $object = new class_client($database);
                $filter = $object->get_client('', '', '15', 'report_type', VIS_STAFF_ID, VIS_LOCATION_AREA);
                break;
            case 16: // Rating Report per client
                $date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = 'avis_ticket.client_id=' . $data['vis_client_id'] . ' and  avis_ticket.domain_id=' . $data['domain_id']. ' and avis_customfield_data.content!=" " and avis_ticket.is_spam = 0 ';
                
                break;
            case 17: // Problem Report
                if ($data['department_id'] == 0) {
                    $department_Id = " ";
                } else
                    $department_Id = " AND FIND_IN_SET (" . $data['department_id'] . ", " . VIS_TABLE_PREFIX . "itil_problems.department_id)>0";
                
                $date_range_filter = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $from_date . ' AND ' . $to_date . $department_Id;
                
                break;
            case 18: // change report
                if ($data['department_id'] == 0) {
                    $department_Id = " ";
                } else
                    $department_Id = " AND FIND_IN_SET (" . $data['department_id'] . ", " . VIS_TABLE_PREFIX . "itil_changes.department_id)>0";
                
                $date_range_filter = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $from_date . ' AND ' . $to_date . $department_Id;
                
                break;
            case 19: // release report
                if ($data['department_id'] == 0) {
                    $department_Id = " ";
                } else
                    $department_Id = " AND FIND_IN_SET (" . $data['department_id'] . ", " . VIS_TABLE_PREFIX . "itil_releases.department_id)>0";
                
                $date_range_filter = VIS_TABLE_PREFIX . 'itil_releases.date_created between ' . $from_date . ' AND ' . $to_date . $department_Id;
                
                break;
            case 20: // Billing Report	
                $date_range_filter     = ' entry_date between' . $from_date . ' AND ' . $to_date . '';
                $data['department_id'] = $data['domain_id'];
                $filter = ' AND ' . VIS_TABLE_PREFIX . 'invoice.client_id=' . $data['vis_client_id'] . ' AND ' . VIS_TABLE_PREFIX . 'client.domain_id=' . $data['domain_id'];
                break;
            case 21: // Time tracking per Organization
			
                $date_range_filter = 'created_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            =  VIS_TABLE_PREFIX .'client.group_id=' . $data['group_id']. ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'];
                break;
            case 22: // Time tracking per client
                $date_range_filter = 'created_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter = VIS_TABLE_PREFIX . 'ticket.client_id=' . $data['vis_client_id'];
                break;
            case 23: //  domain_report
			 
                $date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
				$filter=' domain_id=' . $data['domain_id'].' and is_deleted=0 and is_spam=0 and draft_id=0';
                break;
            
            case 24: //first_response_report
                $date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter = ' ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1' ;
                $filter.=($data['department_id'] != 1) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                break;
            
            case 25: //Total_response_report
                $date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter = ' ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and ' . VIS_TABLE_PREFIX . 'ticket_post.is_visible=1 and ' . VIS_TABLE_PREFIX . 'ticket_post.reply_forward=1';
                $filter.=($data['department_id'] != 1) ? ' avis_ticket.department_id=' . $data['department_id'] : '';
                break;
            
            case 26: //billing_invoice_report
                $date_range_filter = VIS_TABLE_PREFIX . 'invoice.entry_date between  ' . $from_date . ' AND ' . $to_date;
                $filter = ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                $filter .= ($data['status_id'] == 3) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                break;
            
            case 27: //order_report
                $date_range_filter = VIS_TABLE_PREFIX . 'order.entry_date between  ' . $from_date . ' AND ' . $to_date;
                $filter = ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                break;
            
            case 28: //transaction_report
                $date_range_filter = VIS_TABLE_PREFIX . 'balance.entry_date between  ' . $from_date . ' AND ' . $to_date;
                $filter = ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                break;
            
            case 29: //client_order_report
                $date_range_filter = VIS_TABLE_PREFIX . 'invoice.entry_date between  ' . $from_date . ' AND ' . $to_date;
                $filter = ' ' . VIS_TABLE_PREFIX . 'client.client_id=' . $data['vis_client_id'];
                $filter .= ($data['status_id'] == 4) ? '' : ' and avis_invoice.invoice_status=' . $data['status_id'];
                break;
            
            case 30: //client_transaction_report
                $date_range_filter = VIS_TABLE_PREFIX . 'balance.entry_date between  ' . $from_date . ' AND ' . $to_date;
                $filter = ' ' . VIS_TABLE_PREFIX . 'client.client_id=' . $data['vis_client_id'];
                $filter .= ($data['status_id'] == 4) ? '' : ' and ' . VIS_TABLE_PREFIX . 'invoice.invoice_status=' . $data['status_id'];
                break;
            
            case 31: //staff_point_report
                $date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between  ' . $from_date . ' AND ' . $to_date;
                $filter = ($data['staff_id'] == 0) ? '' : 'staff_id=' . $data['staff_id'];
                break;
            
            case 32: //staff_bouns_point_report
                $date_range_filter = VIS_TABLE_PREFIX . 'selfhelp_article.entry_date between  ' . $from_date . ' AND ' . $to_date;
                $filter = ($data['staff_id'] == 0) ? '' : ' author_id=' . $data['staff_id'];
                break;
            
            case 33: //quest1_report
                include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
                $object = new class_setting($database);
				$currentdate=date('Y-m-d H:i:s');
                list($quest_info, $questDetails) = $object->get_quest_list('quest_status !=0', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
                foreach ($questDetails as $quest_details) {
                    $quest_start_date = $quest_details['quest_start_date'];
                    $quest_duration   = $quest_details['quest_duration'];
                    //$quest_end_date   = date('Y-m-d H:i:s', strtotime($quest_duration, $quest_start_date));
                }
				$quest_end_date   = strtotime($quest_duration,$quest_start_date);
                $date_range_filter = VIS_TABLE_PREFIX . 'quest.quest_start_date between  ' . $quest_start_date . ' AND ' .$quest_end_date;
                $filter = ' avis_quest.quest_id=' . $data['quest_id'] . ' and avis_staff.staff_id=' . $data['staff_id'];
                break;
            
            case 34: // Deleted Tickets Report
                if ($data['department_id'] != 0) {
                    $date_range_filter = 'entry_date between ' . $from_date . ' AND ' . $to_date . ' and a.department_id=' . $data['department_id'];
                } else {
                    $date_range_filter = 'entry_date between  ' . $from_date . ' AND ' . $to_date;
                }
                break;
            case 35: //merged tickets report
                if ($data['staff_id'] != 0) {
                    $filter = 'operator_id=' . $data['staff_id'];
                }
                break;
            
            case 36: //tickets grouped by channel report
                if ($data['department_id'] != 0) {
                    $filter = 'c.channel_id=' . $data['channel_id'] . ' and t.department_id=' . $data['department_id'];
                } else {
                    $filter = 'c.channel_id=' . $data['channel_id'] . ' and t.department_id in (' . $dept_id . ')';
                }
                break;
            case 37: //ITIL - Problems solved per staff report
                if ($data['staff_id'] != 0) {
                    $date_range_filter = 'a.entry_date between ' . $from_date . ' AND ' . $to_date . ' and operator_id =' . $data['staff_id'];
                } else {
                    $date_range_filter = 'a.entry_date between  ' . $from_date . ' AND ' . $to_date;
                }
                break;
            case 38: // get custom field data report
				$database = new class_database();
                include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
                $tkt_object = new class_ticket($database);                
                include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
                $object_staff = new class_staff($database);
                $staff_details = $object_staff->get_staff($staff_filter, $userid, $user);
                $departments   = $tkt_object->get_department(VIS_TABLE_PREFIX . 'department.is_enabled=1 and ' . VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
                $dept_ids    = '';
                for ($d = 0; $d < count($departments); $d++) {
                                                $dept_ids .= $departments[$d]['department_id'] . ',';
                }
                if ($dept_ids != '') {
                                                $dept_ids = substr($dept_ids, 0, -1);
                }
                $dept_id  = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
                $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
                
			
                if ($data['department_id'] != 0 && $data['field_type'] != 0) {
                    $filter = 't.receive_date between ' . $from_date . ' AND ' . $to_date . ' and t.department_id=' . $data['department_id'] . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';
                } else if ($data['department_id'] == 0 && $data['field_type'] != 0) {
                    $filter = 't.receive_date between ' . $from_date . ' AND ' . $to_date . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1 ';
                } else if ($data['department_id'] != 0 && $data['field_type'] == 0) {
                    $filter = 't.receive_date between ' . $from_date . ' AND ' . $to_date . ' and t.department_id=' . $data['department_id'].' and cf.is_enabled = 1 ';
                } else {
                    $filter = 't.receive_date between  ' . $from_date . ' AND ' . $to_date. ' and t.department_id in (' . $dept_id . ')'.' and cf.is_enabled = 1 ';
                }
                break;
            case 39: //customfield data report for user registration
                if ($data['userfield_name'] != 0) {

                    $filter = ' cf.field_group=' . $data['userfield_name'];
                }
                break;
            case 40: //Not answered ticket
                $date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = 'department_id=' . $data['department_id'];
                break;
            
            case 41: // Ticket escalation group by staff ownwer
                $date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = 'staff_id=' . $data['staff_id'];
                break;
            case 42: //Ticket escalation group by department
                $date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = VIS_TABLE_PREFIX . 'department.department_id=' . $data['department_id'];
                break;
		    case 43: //total tickets resolved
					if($data['department_id']!=0){
						$depfilter = ' and '.VIS_TABLE_PREFIX.'ticket.department_id='.$data['department_id'];
					}else{
						$depfilter = '';
					}
                $date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
                $filter            = ' operation_id<=2'.$depfilter;
                break;
		    case 44: //login activity
                $date_range_filter = VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from_date.' AND '.$to_date;
                $filter            = ' '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.module_id=4 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
                break;
		    case 45: //staff activities
                $date_range_filter = VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from_date.' AND '.$to_date;
                $filter            = ' '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
                break;
		    case 46: //staff activity search report
                $date_range_filter = VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from_date.' AND '.$to_date;
                $filter            = ' '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
                break;
			case 47: //staff response time report
                $date_range_filter = VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from_date.' AND '.$to_date;
                $filter            = ' '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.content like "%'.$data['vis_new_ticket_list_client'].'%" and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
                break;
			case 48:// Client with maximum ticket
				$date_range_filter='avis_ticket.receive_date between ' . $from_date . ' AND ' . $to_date;
				 
				 $filter    =' avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id group by avis_client.client_id order by ticket_count DESC limit '.$data['maxcount'];
				
				break;
			case 49:// Client with maximum ticket reply
				$date_range_filter='avis_ticket_post.receive_date between ' . $from_date . ' AND ' . $to_date;
				$filter = ' avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id and avis_ticket_post.reply_forward=1 group by avis_client.client_id order by total_ticket_reply_count DESC limit '.$data['maxcount'];
				break;
				
				case 50:// most_commented_article
				$date_range_filter= 'avis_selfhelp_comment.entry_date  between ' . $from_date . ' AND ' . $to_date; 
				$filter    = ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by article_count DESC limit '.$data['maxcount'];
				break;
			   case 51:// most_rated_article
			    $date_range_filter= 'avis_selfhelp_article.entry_date  between ' . $from_date . ' AND ' . $to_date;
				
				$filter = ' avis_selfhelp_category.domain_id=' . $data['domain_id']. ' and avis_selfhelp_article.art_likes!=0 and avis_selfhelp_article.is_enabled=1 group by avis_selfhelp_article.article_id  limit '.$data['maxcount'];
				
			  break;
			 case 52:// most_view_article
				$date_range_filter= 'avis_selfhelp_article.entry_date  between ' . $from_date . ' AND ' . $to_date;
			$filter = ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '    group by avis_selfhelp_article.article_id order by view_count DESC limit '.$data['maxcount'];
			  break;
			 case 53: // itil problems grouped by status 
			  $date_range_filter= 'date_created between ' . $from_date . ' AND ' . $to_date;
			  if($data['vis_status_condition']==0)
				{
			     $filter = VIS_TABLE_PREFIX.'itil_problems.status_id='.$data['vis_status'];
				}
				else{
				$filter = VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
				}
			break;
			 case 54: // itil problems grouped by priority
			  $date_range_filter= 'date_created between ' . $from_date . ' AND ' . $to_date;
			  if($data['vis_priority_condition']==0)
				{
			     $filter = VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
				}
				else{
				$filter = VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
				}
			break;
			 case 55: // itil problems grouped by impact
			 $date_range_filter= 'date_created between ' . $from_date . ' AND ' . $to_date;
			  if($data['vis_impact_condition']==0)
				{
			     $filter = VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
				}
				else{
				$filter = VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
				}
					break;
			 case 56:// assign_staff_task_report
				 
				$date_range_filter= 'avis_task.startdate > ' . $from_date ;
				$filter =  'avis_task_assign.owner_id=' . $data['staff_id'];
			  break;
			  case 57:// overdue_task
			   
			   
				$date_range_filter= 'avis_task.startdate between ' . $from_date . ' AND ' . $to_date;
				$filter =($data['staff_id'] == -2) ? ' INNER JOIN avis_task_assign on avis_task_assign.task_id!=avis_task.task_id ' : ' INNER JOIN avis_task_assign on avis_task_assign.task_id=avis_task.task_id ';
				$filter .= ($data['staff_id'] != 0) ? ' and avis_task_assign.owner_id=' . $data['staff_id'] : '';
				$filter.=" and (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ;
				$filter .=($data['staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM avis_task_assign  where avis_task_assign.task_id = avis_task.task_id)' : '';
             
			  break;
			 case 58:// assets used by client
				
				$client_email = str_replace("%40","@",$data['vis_usedby']);
				
			if ($data['asset_name'] != '' && $client_email != '' && $data['vis_ci_type'] != '') {
                     $filter = 'cmast.name like "%' . $data['asset_name'].'%" and cmast.usedby like "%'.$client_email.'%" and cmast.ci_type_id = '.$data['vis_ci_type'];
					$filter1 =' where avis_customfield.customgroup_id ='.$data['vis_ci_type']. ' and  avis_itil_cmdb_assets.name="'.$data['asset_name'].'"';
                }
				 
            
			 break;
			 case 59://assets managed by staff
			  
			  	if($data['staff_id'] != 0 && $data['vis_ci_type'] != '') {
                    if($data['staff_id'] == -2){
						$filter = ' cmast.staff_id = "" and cmast.ci_type_id = '.$data['vis_ci_type'];
					}else{
						$filter = ' cmast.staff_id = '.$data['staff_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'];
					}
                }
				else 
				{
					if($data['staff_id'] == -2){
						$filter = ' cmast.staff_id = "" and cmast.ci_type_id = '.$data['vis_ci_type'];
					}else{
						$filter = ' cmast.ci_type_id = '.$data['vis_ci_type'];
					}
				}
				
				if($data['staff_id'] == -2){
					$filter1 =' where avis_customfield.customgroup_id ='.$data['vis_ci_type']. ' and  avis_itil_cmdb_assets.staff_id=""';
				}else{
					$filter1 =' where avis_customfield.customgroup_id ='.$data['vis_ci_type']. ' and  avis_itil_cmdb_assets.staff_id='.$data['staff_id'];
				}					
			break;
			case 60: //ticket_linking
					$date_range_filter= 'receive_date between ' .  $from_date . ' AND ' . $to_date . '';
					$filter=  VIS_TABLE_PREFIX . 'ticket_link.link_type=' . $data['vis_link_type'] . ' and ' . VIS_TABLE_PREFIX . 'ticket.domain_id=' . $data['domain_id'];
			  break;
			  case 61://task_commented_report
			  $date_range_filter= 'avis_task_comment.entry_date between ' .  $from_date . ' AND ' . $to_date . '';
			   $filter    =  'avis_task_comment.owner=' .$data['staff_id'];
			   break;
			 case 62:// assets linked to tickets report
				if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != '') {
                    $filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 0 and cmast.ci_type_id = '.$data['vis_ci_type'];
                }
			 break;
			 case 63://ticket_activity
			 $date_range_filter= 'avis_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date . '';
			 $filter    =  ' avis_auditlog.ticket_hash='.'"' .$data['vis_new_ticket_list_client1'].'"';
			 $filter .= " and avis_auditlog.access_id!=1 and avis_auditlog.access_id!=2 and avis_auditlog.access_id!=3";
			 break;
			 case 64:// releases_linkedto_changes_report
			 $date_range_filter= 'avis_itil_changes.date_created between ' .  $from_date . ' AND ' . $to_date . '';
			 $filter = 'AND '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 ';
			 break;
			 
			 case 65:// changes resolved by staff report
			 if ($data['staff_id'] != 0) {
                    $date_range_filter = 'date_created between ' . $from_date . ' AND ' . $to_date . ' and c.staff_id=' . $data['staff_id'];
               } else {
             $date_range_filter = 'date_created between  ' . $from_date . ' AND ' . $to_date.' and c.department_id in'.'('.$dept_id.')';
                }
			break;
			case 66:// staff leaderboard report
			$date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from_date . ' AND ' .$to_date;
			$filter        = ' and avis_ticket.domain_id = ' . $data['domain_id'];
			break;
			case 67:// ticket_replied_by_staff_report
			$date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from_date . ' AND ' .$to_date;
			$filter        = ' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=1';
			break;
			case 68:// ticket_forwarded_by_staff_report
			$date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from_date . ' AND ' .$to_date;
			$filter        = ' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=2';
			break;
			case 69:// ticket_viewed_by_staff_report
			$date_range_filter = VIS_TABLE_PREFIX . 'auditlog.entry_date between ' . $from_date . ' AND ' .$to_date;
			$filter        = ' and '.VIS_TABLE_PREFIX.'auditlog.operation_id=52 and '.VIS_TABLE_PREFIX.'auditlog.operator_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'auditlog.operator=2';
			break;
			case 70:// assets_linkedto_problems_report
			      if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != '') {
                    $filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 4 and cmast.ci_type_id = '.$data['vis_ci_type'];
                }
		 break;
		 case 71:// assets_groupby_status_report
			
			if ($data['status_id'] != -1 && $data['vis_ci_type'] != '') {
								$filter = $data['status_id'].' and '.$data['vis_ci_type']; 
					}		
		 break;
			case 72:// assets_groupby_location_report
			  if ($data['location_id'] != -1 && $data['vis_ci_type'] != '') {
						if($data['location_id']!=0){
								$filter = 'cmast.location_id='.$data['location_id'].' and cmast.ci_type_id = '.$data['vis_ci_type']; 
						}else{
								$filter = 'cmast.location_id!='.$data['location_id'].' and cmast.ci_type_id = '.$data['vis_ci_type']; 
						}
					}
					
		 break;
 
		 
 
				case 73: //THIS ONE  FOR STATUS BY REPORT
					if ($data['vis_status'] == 1){
																$filter = VIS_TABLE_PREFIX.'task.task_status=1 and ('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) > 0 ';
													}elseif ($data['vis_status'] == 2){
															$filter = '('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) <= 0 and ('.VIS_TABLE_PREFIX.'task.task_status!=3 and '.VIS_TABLE_PREFIX.'task.task_status!=4)';
													}elseif ($data['vis_status'] == 3){
															$filter = VIS_TABLE_PREFIX.'task.task_status=3';
													}elseif ($data['vis_status'] == 4){
															$filter = VIS_TABLE_PREFIX.'task.task_status=4';
													}elseif ($data['vis_status'] == 5){
															$filter = '('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) > 0 and '.VIS_TABLE_PREFIX.'task.task_status=5';
													} 
													$filter=($filter!='')?$filter.' and '.VIS_TABLE_PREFIX.'task.staff_id='.$data['staff_id']:' '.VIS_TABLE_PREFIX.'task.staff_id='.$data['staff_id'];
		
				break;
				case 74:// assets_by_type_report
			if ($data['location_id'] != -1) {
				$filter = 'cmast.ci_type_id='.$data['location_id']; 
				$filter1 =' where  avis_customfield_data.parent_id ='.$data['location_id'];	
				}
				 		
				$filter=$filter.'#'.$filter1;
		 break;
		 case 75: //assets_by_asset_product_report
					 if ($data['product_id'] != -1 && $data['vendor_id']!=-1 ) {
						 
							  $filter = 'cmast.product_id='.$data['product_id']. ' and cmast.vendor_id='.$data['vendor_id']; 
						
					} 
					break;
		case 76: //hardware_assets_by_state_report
			if ($data['asset_id'] != -1) {
						 
							  $filter = 'cmast.assets_state='.$data['asset_id'].' and cmast.ci_type_id=2 '; 
						
					} break;
		case 77: //assets_depreciation_report
						if ($data['depr_type_id'] != -1 && $data['depr_type_id'] != 0) {
						 
					 $filter = ' cmast.depreciation_type='.$data['depr_type_id'].' and cmast.ci_type_id=2 '; 
					}
				if ($data['depr_type_id'] == 0) {
						 
					 $filter = ' cmast.depreciation_type!=0 and cmast.ci_type_id=2 '; 
					} break;
		case 78: //assets_depreciation_notification_report
						if ($data['depr_type_id'] != -1 && $data['depr_type_id'] != 0) {
						 
					 $filter = ' cmast.depreciation_type='.$data['depr_type_id'].' and cmast.ci_type_id=2 '; 
					}
				if ($data['depr_type_id'] == 0) {
						 
					 $filter = ' cmast.depreciation_type!=0 and cmast.ci_type_id=2 '; 
					} break;
					
						case 80: //client_report
						if ($data['vis_client_start'] != '') {
											if ($data['domain_id'] != '') {
												$filter = '(email like "' . $data['vis_client_start'] . '%" or first_name like "' . $data['vis_client_start'] . '%") and domain_id=' . $data['domain_id'] . ' and is_spam=0 and is_banned=0 ';
											}else{
												$filter = ' domain_id=' . $data['domain_id'] . ' and is_spam=0 and is_banned=0 '; 
											}
					  }else{
							$filter = ' (email like "%" or first_name like "%") and domain_id=1 and is_spam=0 and is_banned=0 '; 
						}
						
				    break;
							case 81: // Clients by organization
							
							 	if ($data['domain_id'] == 0) {
                    $filter = "";
                } else{
                    $filter = ' (' . VIS_TABLE_PREFIX . 'client.domain_id = ' . $data['domain_id'].' or ' . VIS_TABLE_PREFIX . 'client.optionB_domain_id = ' . $data['domain_id'].')';
																}
								
					if ($data['group_id'] != ''){
						$filter   .= ($filter!='')?' and '.VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id']:VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'];
					}else{
						$filter    .= "";
					} 
					break;
					 case 82: // invoices by organization
                    
   					 $domainId = ' AND ' . VIS_TABLE_PREFIX . 'client.domain_id = ' . $data['domain_id'];
                     
					 if ($data['group_id'] == '0' || $data['group_id'] == ''){
					 $groupId    = "";
				     }else{
					 $groupId   = VIS_TABLE_PREFIX . 'client.group_id = ' . $data['group_id'].' AND ';
				      }
					  
                     $date_range_filter = VIS_TABLE_PREFIX . 'invoice.entry_date between ' . $from_date . ' AND ' . $to_date . $domainId;
                     $filter       = $groupId;
                
                break;
				
				case 83:// staff leaderboard report
			$date_range_filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from_date . ' AND ' .$to_date;
			$filter        = ' and avis_ticket.domain_id = ' . $data['domain_id'];
			break;
			
			case 84:// staff_leaderboard_first_avgresponse_report
			$date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from_date . ' AND ' .$to_date;
			$filter        = ' and avis_ticket.domain_id = ' . $data['domain_id'];
			break;
			case 85:// staff_leaderboard_first_avgresponse_report
			$date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from_date . ' AND ' .$to_date;
			$filter        = ' and avis_ticket.domain_id = ' . $data['domain_id'];
			break;
				
			case 86: // Overdue Tickets
			$date_range_filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from_date . ' AND ' . $to_date ;
			if ($data['department_id'] != 0){
				$filter = ' and d.department_id=' . $data['department_id'].' and is_spam=0 and is_deleted=0 and due_time!=0 and due_time-unix_timestamp() and user_replied = 1';
			}else{
				$filter = ' and is_spam=0 and is_deleted=0 and due_time!=0 and due_time-unix_timestamp() and user_replied = 1';
			}
			break;
					
			case 87: //total undue ticket report
			$date_range_filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from_date . ' AND ' .$to_date;
			if($data['department_id']!='' && $data['department_id']!=0){
			$filter        = ' and '.VIS_TABLE_PREFIX.'ticket.department_id='.$data['department_id'];
			}else{ 
			$filter        = '';
			}
			break;
					case 88:// ticket_activity_by_department_report
					 
						$date_range_filter = VIS_TABLE_PREFIX . 'auditlog.entry_date between ' . $from_date . ' AND ' .$to_date;
						$filter        = ' and avis_auditlog.department_id=' .$data['department_id'];
						$filter .= " and avis_auditlog.access_id!=1 and avis_auditlog.access_id!=2 and avis_auditlog.access_id!=3";
						break;
					case 89://ticket_ci_relation_report
					   $date_range_filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from_date . ' AND ' .$to_date;
					
					 $filter        = ' and '. VIS_TABLE_PREFIX .'ticket.department_id=' . $data['department_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket.draft_id = 0 and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=0 ';
					
					break;
					
					case 90: // problems ci relation report
					$date_range_filter = VIS_TABLE_PREFIX . 'itil_problems.date_created between ' . $from_date . ' AND ' .$to_date;
					
					 $filter        = ' and '. VIS_TABLE_PREFIX .'itil_problems.department_id=' . $data['department_id'] .' and '.VIS_TABLE_PREFIX . 'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=4 ';
 					break;
					
					case 91: // changes ci relation report
					$date_range_filter = VIS_TABLE_PREFIX . 'itil_changes.date_created between ' . $from_date . ' AND ' .$to_date;
					
					 $filter        = ' and '. VIS_TABLE_PREFIX .'itil_changes.department_id=' . $data['department_id'] .' and '.VIS_TABLE_PREFIX . 'itil_changes.status_id!=3 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=9 ';
 					break;
					case 92: // ticket task relation report
					$date_range_filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from_date . ' AND ' .$to_date;
					$filter    =   ' and '. VIS_TABLE_PREFIX .'ticket.department_id=' . $data['department_id'];	 
 					break;
					 case 93:
                                        $database = new class_database();
                                        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
                                        $tkt_object = new class_ticket($database);
                                        $staff_details= $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);                                       
                                        for ($d = 0; $d < count($staff_details); $d++) {

                                                                        $dept_ids .= $staff_details[$d]['staff_id'] . ',';

                                        }

                                        if ($dept_ids != '') {

                                                                        $dept_ids = substr($dept_ids, 0, -1);                                        
                                        }                                        
                                        $dept_id  = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];                                          
                                    
                                      
                                         if ($data['staff_id'] == 0 && $data['field_type'] == 0) 
                                         {
                                            $date_range_filter =  't.receive_date between ' . $from_date . ' AND ' .$to_date;
                                            $filter    ='  cf.is_enabled = 1';
                                         }
                                         else if ($data['staff_id'] != 0 && $data['field_type'] != 0) 
                                         {
                                                $date_range_filter =  't.receive_date between ' . $from_date . ' AND ' .$to_date;
                                            $filter    =' st.staff_id in ' . '(' . $dept_id . ')' . ' and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1';       
                                         }
                                            else  if ($data['staff_id']!= 0 && $data['field_type'] == 0) 
                                         {
                                            $date_range_filter =  't.receive_date between ' . $from_date . ' AND ' .$to_date;
                                            $filter    =' st.staff_id in ' . '(' . $dept_id . ')' .' and cf.is_enabled = 1';
                                         }
                                         else if ($data['staff_id'] == 0 && $data['field_type'] != 0) 
                                         {
                                                $date_range_filter =  't.receive_date between ' . $from_date . ' AND ' .$to_date;
                                            $filter    ='  and cf.field_group=' . $data['field_type'].' and cf.is_enabled = 1';       
                                         }
                                         break;
							case 94: 							
									if ($data['userfield_name'] != 0) {

										$filter = ' cf.field_group=' . $data['userfield_name'];
									}
									break;
						   case 95: //total ticket closed by staff
					if ($data['duration'] == 1) //if select Last 30 days duration
						{
						$monthDate = strtotime(date('Y-m-d h:i:s', $currentdate) . '-1 month') - VIS_TIMEZONE;
						$filter    = 'avis_ticket.receive_date between ' . $monthDate . ' AND ' . $currentdate . ' and avis_ticket.status_id=3  and '.VIS_TABLE_PREFIX.'auditlog.operator_id='.$data['staff_id'].' and  avis_ticket.department_id=' . $data['department_id'];

					} else if ($data['duration'] == 2) //if select Last 7 days duration
						{
						$weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
						$filter   = 'avis_ticket.receive_date between ' . $weekDate . ' AND ' . $currentdate . ' and avis_ticket.status_id=3 and '.VIS_TABLE_PREFIX.'auditlog.operator_id='.$data['staff_id'].' and avis_ticket.department_id=' . $data['department_id'];
					} else if ($data['duration'] == 3) //if select Last 24 hours duration
						{
						$hour   = strtotime("-1 day ") - VIS_TIMEZONE;
						$filter = 'avis_ticket.receive_date between ' . $hour . ' AND ' . $currentdate . ' and avis_ticket.status_id=3 and '.VIS_TABLE_PREFIX.'auditlog.operator_id='.$data['staff_id'].' and avis_ticket.department_id=' . $data['department_id'];
					} else if ($data['duration'] == 4) //if select Custom duration
						{
						$from   = $data['from_date'] - VIS_TIMEZONE;
						$to     = $data['to_date'] - VIS_TIMEZONE;
						$filter = 'avis_ticket.receive_date between ' . $from . ' AND ' . $to . '  and avis_ticket.status_id=3 and '.VIS_TABLE_PREFIX.'auditlog.operator_id='.$data['staff_id'].' and avis_ticket.department_id=' . $data['department_id'];
					}
					
					break;				
			case 96: 	
					if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
					$flag_id = ($data['flag_id'] == 0) ? '' : $data['flag_id'];
                    $monthDate     = strtotime(date('Y-m-d h:i:s', $currentdate) . '-1 month') - VIS_TIMEZONE;
                    $filter        = 'receive_date between ' . $monthDate . ' AND ' . $currentdate .' and avis_staff.staff_id='.$data['staff_id'];
                    $filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
                    $filter .= ($data['flag_id'] != 0) ? ' and avis_ticket.flag_id=' . $data['flag_id'] : '';
					
					} else if ($data['duration'] == 2) //if select Last 7 days duration
						{
						$department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
						$flag_id = ($data['flag_id'] == 0) ? '' : $data['flag_id'];
						$weekDate      = strtotime("-1 week ") - VIS_TIMEZONE;
						$filter        = 'receive_date between ' . $weekDate . ' AND ' . $currentdate .' and avis_staff.staff_id='.$data['staff_id'];
						$filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
						$filter .= ($data['flag_id'] != 0) ? ' and avis_ticket.flag_id=' . $data['flag_id'] : '';						
						
					} else if ($data['duration'] == 3) //if select Last 24 hours duration
						{
						$department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
						$flag_id = ($data['flag_id'] == 0) ? '' : $data['flag_id'];
						$hour          = strtotime("-1 day ") - VIS_TIMEZONE;
						$filter        = 'receive_date between ' . $hour . ' AND ' . $currentdate .' and avis_staff.staff_id='.$data['staff_id'];
						$filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
						$filter .= ($data['flag_id'] != 0) ? ' and avis_ticket.flag_id=' . $data['flag_id'] : '';								
						
					} else if ($data['duration'] == 4) //if select Custom duration
						{
						$department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
						$flag_id = ($data['flag_id'] == 0) ? '' : $data['flag_id'];
						$from          = $data['from_date'] - VIS_TIMEZONE;
						$to            = $data['to_date'] - VIS_TIMEZONE;
						$filter        = 'receive_date between ' . $from . ' AND ' . $to .' and avis_staff.staff_id='.$data['staff_id'];
						$filter .= ($data['department_id'] != 0) ? ' and avis_ticket.department_id=' . $data['department_id'] : '';
						$filter .= ($data['flag_id'] != 0) ? ' and avis_ticket.flag_id=' . $data['flag_id'] : '';							
						
					}	
				break;
			 
     }  
       $data['total_recurrence']=$total_count;
       $data['report_filter']     = $filter;
	   if($data['report_type']==14){$data['date_range_filter'] = $data['date_range_filter'];
	   }else{
		   $data['date_range_filter'] = $date_range_filter;
	   }
       $data['start_date']        = strtotime($data['start_date']);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        
        $object_staff = new class_staff($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        
        $object = new class_setting($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $report_object = new class_report($database);
		
		 
        if ($data['current_operation'] == '') {
			
            $staff_filter        = "staff_id =" . VIS_STAFF_ID;
            $staff_details       = $object_staff->get_staff($staff_filter, $userid, $user);
            $data['staff_email'] = $staff_details[0]['email'];
            
            list($dpinf, $domain_details) = $object->get_domain(VIS_TABLE_PREFIX . 'domain.domain_id=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $data['domain'] = $domain_details[0]['domain'];
           
         
            $result = $report_object->insert_schedule_report($data);  
            
        } else {
			
             if($data['vis_static_area']!='update_list'){
				
            $result = $report_object->update_schedule_report($data);}
            else if($data['vis_static_area']=='update_list'){ $result=$report_object->update_schedule_report_list($data);}
            
        }
        $database->database_disconnect();
        if (!$result) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROR'] . '");</script>';
            return false;
        }
         
        else {
             if($data['vis_static_area']!='update_list'){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");$(".modal").modal("toggle");$("#vis_workpanel_div").visExecution("load_module","' . $vis_language['TXTREPORTS'] . '",{"vis_module":"report", "vis_operation":"schedule_queue_list"});</script>';}
            else
            {echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");$(".modal").modal("toggle");$("#vis_workpanel_div").visExecution("load_module","' . $vis_language['TXTREPORTS'] . '",{"vis_module":"report", "vis_operation":"schedule_queue_list"}); </script>';}
        }
        return true;
    }

    function execute_schedule_report()
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        
        $report_object = new class_report($database);
       
        $currentdate   = strtotime(date('M-jS, Y G:i'));
		
        $filter        = $currentdate;
        
        $rows = $report_object->get_schedule_report_list($filter, $userid, $user);
        
        
        if ($rows != -1) {
            
            for ($i = 0; $i < count($rows); $i++) {
                if($rows[$i]['report_type']!=14){
                if($rows[$i]['report_filter']!='' && $rows[$i]['date_range_filter']!='' )
                $reportfilter = $rows[$i]['date_range_filter'] . ' and ' . $rows[$i]['report_filter'] ;
                else $reportfilter = $rows[$i]['report_filter'] . $rows[$i]['date_range_filter'];
				}else{
					$reportfilter = $rows[$i]['report_filter'];
				}
                $datefilter   = $rows[$i]['date_range_filter'];
                $result       = $report_object->insert_report($rows[$i]['report_title'], $rows[$i]['domain'], $reportfilter, $rows[$i]['department_id'], '', '', '', $rows[$i]['report_type'], $rows[$i]['staff_email'], '', $rows[$i]['export_type'], $rows[$i]['send_email'], $rows[$i]['email_id'], $rows[$i]['staff_id']);
                
                if ($result == 1) {
                    
                    $data                      = $rows[$i];
                    $data['current_operation'] = 'vis_update';
                    $this->request_schedule_report($data);
                }
                
            }
        }
        $report_object->delete_schedule_report($data);
        
    }
    function schedule_queue_list($operation) //schedule list below download queue
    {
		
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $database = new class_database();
        $object   = new class_setting($database);
        list($info, $modules) = $object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        foreach ($modules as $var)
            $module[$var['module']] = 1;
        //include('../slaveconfig.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $report_object = new class_report($database);
        if (isset($operation['vis_page']))
            $page = $operation['vis_page'];
        else
            $page = 0;
        $view_info['page_count'] = 10;
        $limit                   = ' limit ' . ($page * $view_info['page_count']) . ',' . $view_info['page_count'];
        list($report_count, $download_list) = $report_object->schedule_queue_list($limit);
        $view_info['page_count'] = ($report_count == 0) ? 0 : ceil($report_count / $view_info['page_count']);
        $view_info['page']       = $page;
        if (!isset($operation['vis_change']))
            include(VIS_PATH_TEMPLATE . 'schedule_report.php');
        else
            include(VIS_PATH_TEMPLATE . 'schedule_report_list.php');
        
    }
    
    function delete_schedule_queue_link($operation)
    {
        $message_info['vis_form_title'] = 'Delete Schedule List';
        $message_info['vis_message']    = 'Are you sure you want to delete?';
        $message_info['vis_event']      = "$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'report', 'vis_operation':'delete_schedule_queue', 'vis_rschedule_id':" . $operation['vis_rschedule_id'] . "})";
        include(VIS_PATH_TEMPLATE . 'confirm_delete.php');
        return true;
    }
    
    function delete_schedule_queue($operation)
    {
        global $vis_language;
        $database = new class_database();
        //include('../slaveconfig.php');
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $report_object = new class_report($database);
        $delete_report = $report_object->delete_schedule_queue($operation['vis_rschedule_id']);
        if ($delete_report)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");$("#vis_workpanel_div").visExecution("load_module","' . $vis_language['TXTREPORTS'] . '",{"vis_module":"report", "vis_operation":"schedule_queue_list"}); </script>';
        
    }
    function edit_schedule_report_inqueue($operation)
    {
		global $vis_language;
		
        $message_info['vis_form_title'] = 'Edit Schedule List';
        $message_info['vis_message']    = $vis_language['MSGSURE'];
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $report_object = new class_report($database);
        list($report_count, $download_list)= $report_object->edit_schedule_report($operation['vis_rschedule_id']);
        include(VIS_PATH_TEMPLATE . 'edit_schedule_report.php');
        return true;
	}
	

    
    function login_act_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTLOGINACTIVITY'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $staff      = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.module_id=4 and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.module_id=4 and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.module_id=4 and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $from . ' AND ' . $to . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.module_id=4 and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                    
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            $report = $object->get_login_report($filter, $staff_id, VIS_LOCATION_AREA);
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                
                if ($report != -1) {
                    for ($i = 0; $i < count($report); $i++) {
                        foreach ($report[$i] as $key => $val) {
                            if ($key == 'first_name' || $key == 'content')
                                $report_exp[$i][$key] = $val;
                            elseif ($key == 'activity_date')
                                $report_exp[$i][$key] = format_datetime_rpt($val,$staff_id);
                        }
					 $report_exp1[$i]['name'] =  $report_exp[$i]['first_name'].' '.$report_exp[$i]['last_name'];
                     $report_exp1[$i]['content'] =  $report_exp[$i]['content'];
					 $report_exp1[$i]['date'] =  $report_exp[$i]['activity_date'];
					 $j++;
                    }
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                 if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'login_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function staff_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTSTAFFACTIVITIES'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $staff      = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $from . ' AND ' . $to . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            $report = $object->get_staff_activities_report($filter, $staff_id, VIS_LOCATION_AREA);
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                
                if ($report != -1) {
                    for ($i = 0; $i < count($report); $i++) {
                        foreach ($report[$i] as $key => $val) {
                            if ($key == 'first_name' || $key == 'last_name' || $key == 'content')
                                $report_exp[$i][$key] = $val;
                            elseif ($key == 'activity_date')
                                $report_exp[$i][$key] = format_datetime_rpt($val,$staff_id);
                        }
					 $report_exp1[$i]['name'] =  $report_exp[$i]['first_name'].' '.$report_exp[$i]['last_name'];
                     $report_exp1[$i]['content'] =  $report_exp[$i]['content'];
					 $report_exp1[$i]['date'] =  $report_exp[$i]['activity_date'];
					 $j++;
                    }
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'staff_activities_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function staff_activity_search_list($operation)
    {
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
        $object = new class_report($database);
        $filter = ' ' . VIS_TABLE_PREFIX . 'activitylog.content like "%' . $operation['vis_data'] . '%"';
        if (isset($operation['vis_staff_id']) && $operation['vis_staff_id'] != '' && $operation['vis_staff_id'] != 0) {
            $vis_staff = (VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3) ? 1 : $operation['vis_staff_id'];
            $filter .= ' and ' . VIS_TABLE_PREFIX . 'staff.staff_id = ' . $vis_staff;
        }
        $report = $object->get_staff_activities_list($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if ($report == -1) {
            if (VIS_LOCATION_AREA == 0)
                echo 'No data found';
            else
                echo '{}';
            return false;
        }
        $count  = count($report);
        $result = '[';
        if ($report != -1)
            for ($i = 0; $i < $count; $i++) {
                $staff_id = ($report[$i]['staff_id'] == '' && $report[$i]['content'] != '') ? $report[$i]['content'] : $report[$i]['staff_id'];
                $result .= '{"id":"' . $report[$i]['activity_id'] . '","content":"' . $report[$i]['content'] . '","staff_id":"' . addslashes($staff_id) . '"},';
            }
        $result = substr($result, 0, -1);
        if ($result == '')
            return false;
        $result .= ']';
        echo $result;
        return true;
    }
    
    function staff_activity_search_report($operation)
    {
	    global $vis_language;
        $report_title = $vis_language['TXTACTIVITYTRACKING'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $staff      = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
                
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
                //echo "<pre>"; print_r($data); die;
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                
               /* if ($data['duration'] == 0 &&  $data['staff_id']==0 && $data['vis_new_ticket_list_client'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '"); </script>';
                    return false;
                } else if ($data['duration'] != 0 &&  $data['staff_id']==0 && $data['vis_new_ticket_list_client'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 0 &&  $data['staff_id']!=0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    return false;
                }*/
				 if ($data['duration'] == 0 && $data['staff_id'] == 0 && $data['vis_new_ticket_list_client'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == 0 && $data['vis_new_ticket_list_client'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == 0 && $data['vis_new_ticket_list_client'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['staff_id'] == 0 && $data['vis_new_ticket_list_client'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['staff_id'] != 0 && $data['vis_new_ticket_list_client'] != "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['staff_id'] != 0 && $data['vis_new_ticket_list_client'] == "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] != 0 && $data['vis_new_ticket_list_client'] == "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECT'] ." ".$vis_language['TXTACTIVITY']. '" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == 0 && $data['vis_new_ticket_list_client'] == "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message","' . $vis_language['TXTSELECT'] ." ".$vis_language['TXTACTIVITY']. '" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }	
                
                
                //echo "<pre>"; print_r($data); die;
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.content like "%' . $data['vis_new_ticket_list_client'] . '%" and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.content like "%' . $data['vis_new_ticket_list_client'] . '%" and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.content like "%' . $data['vis_new_ticket_list_client'] . '%" and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = ' ' . VIS_TABLE_PREFIX . 'activitylog.activity_date between ' . $from . ' AND ' . $to . ' AND ' . strtotime($currentdate) . ' and ' . VIS_TABLE_PREFIX . 'activitylog.is_client=0 and ' . VIS_TABLE_PREFIX . 'activitylog.content like "%' . $data['vis_new_ticket_list_client'] . '%" and ' . VIS_TABLE_PREFIX . 'activitylog.user_id=' . $data['staff_id'];
                }
                
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object = new class_report($database);
            $report = $object->get_staff_activities_report($filter, $staff_id, VIS_LOCATION_AREA);
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
               
                if ($report != -1) {
                    for ($i = 0; $i < count($report); $i++) {
                        foreach ($report[$i] as $key => $val) {
                            if ($key == 'first_name' || $key == 'last_name' || $key == 'content')
                                $report_exp[$i][$key] = $val;
                            elseif ($key == 'activity_date')
                                $report_exp[$i][$key] = format_datetime_rpt($val,$staff_id);
                        }
				     $report_exp1[$i]['name'] =  $report_exp[$i]['first_name'].' '.$report_exp[$i]['last_name'];
                     $report_exp1[$i]['content'] =  $report_exp[$i]['content'];
					 $report_exp1[$i]['date'] =  $report_exp[$i]['activity_date'];
					 $j++;
                    }
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
																
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'staff_activities_search_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
    
    function staff_response_time_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTAVGRESPONSETIMEGROUPBYSTAFF'];
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        $export = 1;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object       = new class_ticket($database);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        $staff            = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '"); </script>';
                    return false;
                }
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '"); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    return false;
                }
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                } else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour   = strtotime("-1 day ") - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and is_visible=1';
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object       = new class_report($database);
            $total_post   = 0;
            $total_ticket = array();
            $total_time   = 0;
            $filter .= ' and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1';
            $post_details = $object->get_performance_report($filter, $staff_id, VIS_LOCATION_AREA);
          
            if ($post_details != -1)
                for ($i = 0; $i < count($post_details); $i++) {
                    if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
                        $report[$post_details[$i]['ticket_id']]['ticket_hash']  = $post_details[$i]['ticket_hash'];
                        $report[$post_details[$i]['ticket_id']]['subject']      = $post_details[$i]['subject'];
                        $report[$post_details[$i]['ticket_id']]['ticket_entry'] = $post_details[$i]['ticket_entry'];
                        $report[$post_details[$i]['ticket_id']]['start_time']   = $post_details[$i]['receive_date'];
                        $report[$post_details[$i]['ticket_id']]['timestamp']    = 0;
                        //$post_details[$i]['receive_date']-$post_details[$i]['ticket_entry'];                    
                        $report[$post_details[$i]['ticket_id']]['ticket_id']    = $post_details[$i]['ticket_id'];
                        $report[$post_details[$i]['ticket_id']]['count']        = 0;
                        if ($post_details[$i]['submitter'] == 1)
                            $report[$post_details[$i]['ticket_id']]['is_posted'] = false;
                        else {
                            $report[$post_details[$i]['ticket_id']]['is_posted'] = true;
                            $total_post++;
                            $total_ticket[$post_details[$i]['ticket_id']] = $post_details[$i]['ticket_id'];
                            $total_time += $post_details[$i]['receive_date'] - $report[$post_details[$i]['ticket_id']]['start_time'];
                        }
                    } elseif ($post_details[$i]['submitter'] == 1) {
                        $report[$post_details[$i]['ticket_id']]['start_time'] = $post_details[$i]['receive_date'];
                    } else {
                        $report[$post_details[$i]['ticket_id']]['timestamp'] += $post_details[$i]['receive_date'] - $report[$post_details[$i]['ticket_id']]['start_time'];
                        $report[$post_details[$i]['ticket_id']]['count']++;
                        $report[$post_details[$i]['ticket_id']]['is_posted'] = true;
                        $total_post++;
                        $total_ticket[$post_details[$i]['ticket_id']] = $post_details[$i]['ticket_id'];
                        $total_time += $post_details[$i]['receive_date'] - $report[$post_details[$i]['ticket_id']]['start_time'];
                    }
                } else
                $report = -1;
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                $j      = 0;
                foreach ($report as $i) {
                    if (!$i['is_posted'])
                        continue;
                    foreach ($i as $key => $val) {
                        if ($key == 'ticket_hash' || $key == 'subject')
                            $report_exp[$j][$key] = $val;
                        elseif ($key == 'ticket_entry')
                          {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);}
                        elseif ($key == 'count')
                            $report_exp[$j]['post_count'] = $val;
                        elseif ($key == 'is_posted')
                            $report_exp[$j]['is_replied'] = $val;
                        elseif ($key == 'timestamp')
                            if ($val != 0 || $i['count'] != 0)
                            $report_exp[$j]['avg_response_time'] = count_remain_time($val / $i['count']);
                            else
                            $report_exp[$j]['avg_response_time'] = "0S";
                    }
					$report_exp1[$j]['ticket_hash'] =  $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] =  $report_exp[$j]['subject'];
					$report_exp1[$j]['creation_date'] =  $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['avg_response_time'] =  $report_exp[$j]['avg_response_time'];
                    $j++;
                }

                $completed_date = date('Y-m-d H:i:s');
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
                
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'staff_response_time_report.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        return true;
    }
	
	   
	 function client_with_maximum_ticket_report($operation)
    {
        global $vis_language;
		 
        $report_title = $vis_language['TXTCLIENTWITHMAXTICKET'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $filter     = VIS_TABLE_PREFIX . 'domain.is_enabled=1 ';
        $domain     = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                }
                
                else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] != 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTTOP'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTTOP'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }			
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . "-1 month ") - VIS_TIMEZONE;
					 
                    $filter    = 'avis_ticket.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id group by avis_client.client_id order by ticket_count DESC limit '.$data['maxcount'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'avis_ticket.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id group by avis_client.client_id order by ticket_count DESC limit '.$data['maxcount'];
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
                    $filter = ' avis_ticket.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id group by avis_client.client_id order by ticket_count DESC limit '.$data['maxcount'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = 'avis_ticket.receive_date between ' . $from . ' AND ' . $to . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id group by avis_client.client_id order by ticket_count DESC limit '.$data['maxcount'];
                    
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php'); 
           $object = new class_report($database);
           $report = $object->get_client_with_maximum_ticket($filter,VIS_STAFF_ID, VIS_LOCATION_AREA);  
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                
                $j = 0;
                foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'first_name') {
                            $report_exp[$j][$key] = $val;
                        }
                        elseif ($key == 'last_name') {
                            $report_exp[$j][$key] = $val;
                        }  elseif ($key == 'client_type') {
                            $report_exp[$j][$key] = $val;
 
                        } elseif ($key == 'email') {
                            $report_exp[$j][$key] = $val;
                        }elseif ($key == 'contact_number') {
                            $report_exp[$j][$key] = $val; 
																								}elseif ($key == 'organizations') {
                            $report_exp[$j][$key] = $val; 
																								}elseif ($key == 'openc') {
                            $report_exp[$j][$key] = $val; 
                        }   elseif ($key == 'ticket_count') {
                            $report_exp[$j][$key] = $val;
                        } 
                       
                        
                    }
					 $report_exp1[$j]['client'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					 $report_exp1[$j]['client_type'] = ($report_exp[$j]['client_type']==0)?$vis_language['TXTEMAILCLIENT']:$vis_language['TXTCALLCLIENT'];
					 $report_exp1[$j]['email'] = $report_exp[$j]['email'];
					 $report_exp1[$j]['contact_number'] = $report_exp[$j]['contact_number'];
						$report_exp1[$j]['organizations'] = $report_exp[$j]['organizations'];
						$report_exp1[$j]['total_open_ticket'] = $report_exp[$j]['openc'];
					 $report_exp1[$j]['total_ticket'] = $report_exp[$j]['ticket_count'];
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
                
                $filename = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }
            
            else
                include(VIS_PATH_TEMPLATE . 'client_with_maximum_ticket.php');
            
            
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        
        return true; 
        
        
    }
	
	
	 function client_with_maximum_reply_ticket_report($operation)
    {
        global $vis_language;
		
        $report_title = $vis_language['TXTCLIENTWITHMAXREPLYTICKET'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $filter     = VIS_TABLE_PREFIX . 'domain.is_enabled=1 ';
        $domain     = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
             
				
				
				 if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] != 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTTOP'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTTOP'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }			
				
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'avis_ticket_post.receive_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id  and avis_ticket_post.reply_forward=1 group by avis_client.client_id order by total_ticket_reply_count DESC limit '.$data['maxcount'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'avis_ticket_post.receive_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id  and avis_ticket_post.reply_forward=1 group by avis_client.client_id order by total_ticket_reply_count DESC limit '.$data['maxcount'];
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
                    $filter = ' avis_ticket_post.receive_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id and avis_ticket_post.reply_forward=1 group by avis_client.client_id order by total_ticket_reply_count DESC limit '.$data['maxcount'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = 'avis_ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and avis_ticket.domain_id=' . $data['domain_id']. ' and avis_client.client_id = avis_ticket.client_id and avis_ticket_post.reply_forward=1 group by avis_client.client_id order by total_ticket_reply_count DESC limit '.$data['maxcount'];
                    
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
             
           $object = new class_report($database);
            //$report=$object->get_ticket_count_by_department($filter, $staff_id, VIS_LOCATION_AREA);  print_r($report);
			 
            
           $report = $object->get_client_with_maximum_reply_ticket($filter,VIS_STAFF_ID, VIS_LOCATION_AREA);  
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                
                $j = 0;
               foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'first_name') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'last_name') {
                            $report_exp[$j][$key] = $val; 
                        } elseif ($key == 'email') {
                            $report_exp[$j][$key] = $val; 
                        } elseif ($key == 'group_name') {
                            $report_exp[$j][$key] = $val; 
                        } 
						elseif ($key == 'contact_number') {
                            $report_exp[$j][$key] = $val; 
                        }elseif ($key == 'total_ticket_reply_count') {
                            $report_exp[$j][$key] = $val;
                        }  elseif ($key == 'client_type') {
                            $report_exp[$j][$key] = $val;
 
                        }  
                        
                    }
					 $report_exp1[$j]['client'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					 $report_exp1[$j]['client_type'] = ($report_exp[$j]['client_type']==0)?$vis_language['TXTEMAILCLIENT']:$vis_language['TXTCALLCLIENT'];
					 $report_exp1[$j]['email'] = $report_exp[$j]['email'];
					 $report_exp1[$j]['contact_number'] = $report_exp[$j]['contact_number'];
					  $report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					 $report_exp1[$j]['total_ticket_reply_count'] = $report_exp[$j]['total_ticket_reply_count'];
					 
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				 
                $filename = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }
            
            else
                include(VIS_PATH_TEMPLATE . 'client_with_maximum_reply_ticket.php');
            
            
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        
        return true; 
        
        
    }
	function graphical_domain_report($operation) {
		global $vis_language;
        $report_title=$vis_language['TXTDOMAINREPORT'];
        $database=new class_database();
		$export=1;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $tkt_object=new class_ticket($database);
        $getPdf = 1;
        $canvasDiv = "#channel_report";
        $pdfTitle = $vis_language['TXTDOMAINREPORT'];
        $toDisplay = $vis_language['TXTDOMAINREPORT'];
        $graphicalReport = 1;
         $tkt_object=new class_ticket($database);
		 $filter     = VIS_TABLE_PREFIX . 'domain.is_enabled=1 ';
        $domain     = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
       if(isset($operation['vis_action']) && $operation['vis_action']!='') {
            if(isset($operation['vis_submit']) && $operation['vis_submit']!='') $data=$operation;
            else $data=parse_form_array($operation['vis_action']); 
             if(count($data)==0) {
                include(VIS_PATH_TEMPLATE.'report_form.php');
                return true;
            }			 
             $currentdate = date('Y-m-d h:i:s');
			if(($data['from_date'] == '' && $data['to_date'] == '' && $data['duration']==4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration']==4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration']==4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDATE'].'"); </script>';
                    return false;
            }
			if($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if(!$ret){
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$msg.'"); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '"); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    return false;
                }	
			  $currentdate = date('Y-m-d h:i:s');
			  if($data['duration'] == 1) //if select Last 30 days duration
			 {  
					 $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month')- VIS_TIMEZONE;
					 $filter =  ' receive_date between '.$monthDate.' AND '.strtotime($currentdate).' and domain_id='.$data['domain_id'];
			 }    
			 else if($data['duration'] == 2)//if select Last 7 days duration
			 {
					$weekDate =strtotime("-1 week ")- VIS_TIMEZONE;
				  $filter = ' receive_date between '.$weekDate.' AND '.strtotime($currentdate).' and domain_id='.$data['domain_id']; 
			 }
			 else if($data['duration'] == 3)//if select Last 24 hours duration
			 {
					 $hour=strtotime("-1 day ")- VIS_TIMEZONE;
					  $filter = ' receive_date between '.$hour.' AND '.strtotime($currentdate).' and domain_id='.$data['domain_id'];
			 }
			 else if($data['duration'] == 4)//if select Custom duration
			 {
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to = strtotime($data['to_date']) - VIS_TIMEZONE;
				    $filter =  ' receive_date between '.$from.' AND '.$to.' and domain_id='.$data['domain_id'];  
			 } 
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'report.php');
            $object=new class_report($database);
            $report=$object->get_graphical_domain_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);  
            include(VIS_PATH_TEMPLATE.'graphical_domain_report.php');
        }
        else include(VIS_PATH_TEMPLATE.'report_form.php');
        $database->database_disconnect();
        return true;
    }
				
	function most_commented_article_report($operation)
		{
        global $vis_language;
		 
        $report_title = $vis_language['TXTMOSTCOMMETEDARTICLE'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $filter     = VIS_TABLE_PREFIX . 'domain.is_enabled=1 ';
        $domain     = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;

        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                }
                
                else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] != 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTTOP'] . '" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTTOP'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }			
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                     $filter    = 'avis_selfhelp_comment.entry_date  between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by article_count DESC limit '.$data['maxcount'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'avis_selfhelp_comment.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by article_count DESC limit '.$data['maxcount'];
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
                    $filter = ' avis_selfhelp_comment.entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by article_count DESC limit '.$data['maxcount'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = 'avis_selfhelp_comment.entry_date between  ' . $from . ' AND ' . $to . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '    group by avis_selfhelp_article.article_id order by article_count DESC limit '.$data['maxcount'];
                    
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
             
           $object = new class_report($database);
             
			 
            
          $report = $object->most_commented_article($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);   
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                
                $j = 0;
                foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                        if ($key == 'article_title') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'article_entry_date') {
                            $report_exp[$j][$key] =format_datetime_rpt($val,$staff_id);
                        }   elseif ($key == 'selfhelp_title') {
                            $report_exp[$j][$key] = $val;
                        }  elseif ($key == 'article_count') {
                            $report_exp[$j][$key] = $val;
                        } 
                        $report_exp1[$j]['article'] = $report_exp[$j]['article_title'];
						$report_exp1[$j]['create_date'] = $report_exp[$j]['article_entry_date'];					
						$report_exp1[$j]['category'] = $report_exp[$j]['selfhelp_title'];
						$report_exp1[$j]['comment_count'] = $report_exp[$j]['article_count'];
                    }
                    $j++;
                }
				 
                $completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
                
                $filename = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
				 
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }
            
            else
                include(VIS_PATH_TEMPLATE . 'most_commented_article.php');
            
            
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        
        return true; 
        
        
    }
	  function most_rated_articles_report($operation)
		{
        global $vis_language;
		 
        $report_title = $vis_language['TXTMOSTRAREDARTICLE'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $filter     = VIS_TABLE_PREFIX . 'domain.is_enabled=1 ';
        $domain     = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);

                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] != 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTTOP'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTTOP'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>'; 
                    return false;
                }			
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    
					$filter    = 'avis_selfhelp_article.entry_date  between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '  and avis_selfhelp_article.art_likes!=0 and avis_selfhelp_article.is_enabled=1 group by avis_selfhelp_article.article_id  limit '.$data['maxcount'];
				
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                  
				  
					$filter   = 'avis_selfhelp_article.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '  and avis_selfhelp_article.art_likes!=0 and avis_selfhelp_article.is_enabled=1 group by avis_selfhelp_article.article_id  limit '.$data['maxcount'];
				  
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                 
				  $filter = ' avis_selfhelp_article.entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '  and avis_selfhelp_article.art_likes!=0 and avis_selfhelp_article.is_enabled=1 group by avis_selfhelp_article.article_id  limit '.$data['maxcount'];
				  
				  
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
					
                  				
				   $filter = 'avis_selfhelp_article.entry_date between ' . $from . ' AND ' . $to . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '    and avis_selfhelp_article.art_likes!=0 and avis_selfhelp_article.is_enabled=1 group by avis_selfhelp_article.article_id  limit '.$data['maxcount'];
				   
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
             
           $object = new class_report($database);
             
			 
            
          $report = $object->most_rated_articles($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);   
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                
                $j = 0;
                foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                         if ($key == 'article_title') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'entry_date') {
                            $report_exp[$j][$key] =format_datetime_rpt($val,$staff_id);
                        }   elseif ($key == 'selfhelp_title') {
                            $report_exp[$j][$key] = $val;
                        }  elseif ($key == 'like_count') {
                            $report_exp[$j][$key] = $val;
                        } 
                        
                        
                    }
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
                
                $filename = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }
            
            else
                include(VIS_PATH_TEMPLATE . 'most_rated_articles.php');
            
            
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        
        return true; 
        
        
    }
	
	
	function most_view_articles_report($operation)
		{
        global $vis_language;
		 
        $report_title = $vis_language['TXTMOSTVIEWEDARTICLE'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $filter     = VIS_TABLE_PREFIX . 'domain.is_enabled=1 ';
        $domain     = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] == 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['maxcount'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    
                    return false;
                } else if ($data['duration'] == 0 && $data['domain_id'] != 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>'; 
                    
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] != 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTTOP'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['domain_id'] == 0 && $data['maxcount'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTTOP'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }			
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                     $filter    = 'avis_selfhelp_article.entry_date  between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by view_count DESC limit '.$data['maxcount'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                    $filter   = 'avis_selfhelp_article.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by view_count DESC limit '.$data['maxcount'];
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
                    $filter = ' avis_selfhelp_article.entry_date between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '   group by avis_selfhelp_article.article_id order by view_count DESC limit '.$data['maxcount'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                    $filter = 'avis_selfhelp_article.entry_date between ' . $from . ' AND ' . $to . ' and avis_selfhelp_category.domain_id=' . $data['domain_id']. '    group by avis_selfhelp_article.article_id order by view_count DESC limit '.$data['maxcount'];
                    
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
             
           $object = new class_report($database);
             
			 
            
          $report = $object->most_view_articles($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);   
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                
                $j = 0;
                foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                         if ($key == 'article_title') {
                            $report_exp[$j][$key] = $val;
                        } elseif ($key == 'entry_date') {
                            $report_exp[$j][$key] =format_datetime_rpt($val,$staff_id);
                        }   elseif ($key == 'selfhelp_title') {
                            $report_exp[$j][$key] = $val;
                        }  elseif ($key == 'view_count') {
                            $report_exp[$j][$key] = $val;
                        } 
                        
                    }
                    $j++;
                }
                $completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				
                $filename = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
																if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }
            
            else
                include(VIS_PATH_TEMPLATE . 'most_view_article.php');
            
            
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        
        return true; 
        
        
    }
				


	function assign_staff_task_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTASSIGNSTAFFTASKREPORT'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
           $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $staff      = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
	    $citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
	  
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
        
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }    
                
                $currentdate = date('Y-m-d h:i:s');
                /*if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'avis_task.startdate between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_task_assign.owner_id=' .$data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                     $filter    = 'avis_task.startdate between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_task_assign.owner_id=' .$data['staff_id'];
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
                    $filter    = 'avis_task.startdate between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_task_assign.owner_id=' .$data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                     $filter = 'avis_task.startdate between ' . $from . ' AND ' . $to . ' and avis_task_assign.owner_id=' .$data['staff_id'];
                }*/
				 $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
				$filter = 'avis_task.startdate  >' . $from . ' and avis_task_assign.owner_id=' .$data['staff_id'];
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            
            $object = new class_report($database);
             
             
             $report = $object->assign_staff_task_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);  
            
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
                $filtern=VIS_TABLE_PREFIX.'customgroup.location = 13';
				$custom_fields_details=$object->task_custom_field($filtern);
				
				//start custom data
				 $temp=array();
         $temp1=array();		
         $temp2=array();	 
		 $a=0;
		  
		for($i=0;$i<count($custom_fields_details);$i++) 
		{
			$a=$custom_fields_details[$i]['task_id'];
			if($custom_fields_details[$i]['task_id']!=$temp1[$a]['task_id'])
			{$temp['task_id']=$custom_fields_details[$i]['task_id'];
		    $a=$custom_fields_details[$i]['task_id'];
			}
			$temp[$custom_fields_details[$i]['field_name']]=$custom_fields_details[$i]['content'];
			
			$temp1[$a]=$temp;
			 	
		}
 
			$temp2=reset($temp1);
		     
			foreach($report as $key => $csm)
			{
				if(in_array($report[$key]['task_id'],$temp1[$csm['task_id']])){
					foreach($temp1[$csm['task_id']] as $keys=>$val){
					if($keys !='task_id')
				   $report[$key][$keys]=$val;
			    
				}
			}else{
  
					foreach($temp2 as $keys=>$val){
					if($keys!='task_id')
					$report[$key][$keys]="";
					}
				}
				 
			} 
			 
				// get custom filed data loop done
				
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                
                $j = 0;
              	foreach ($report as $i)
				{
                    foreach ($i as $key => $val) {
                        if ($key == 'task_title') {
                            $report_exp[$j][$key] = $val;
                        }   elseif ($key == 'startdate') {
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        }elseif ($key == 'enddate') {
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        }  elseif ($key == 'title') {
                            $report_exp[$j][$key] = $val;
                        }  
						elseif ($key == 'task_status') {
							  
							if($report[$j]['enddate_diff']<=0){
								if($val!=3 && $val!=4 ){
									$report_exp[$j][$key] =$vis_language['TXTOVERDUE']; 
								}else{
									if($val==1) {
										$report_exp[$j][$key] =$vis_language['TXTINPROGRESS']; 
									}else if($val==3){
										$report_exp[$j][$key] =$vis_language['TXTCOMPLETED']; 
									}else if($val==4){ 
										$report_exp[$j][$key] =$vis_language['TXTCANCELED'];  
									}else if($val==5){ 
										$report_exp[$j][$key] =$vis_language['TXTNOTSTARTED'];  
									}
								} 
							}else{ 
								if($val==1) {
									$report_exp[$j][$key] =$vis_language['TXTINPROGRESS']; 
								}else if($val==3){
									$report_exp[$j][$key] =$vis_language['TXTCOMPLETED'];  
								}else if($val==4){ 
									$report_exp[$j][$key] =$vis_language['TXTCANCELED']; 
								 }else if($val==5){ 
									$report_exp[$j][$key] =$vis_language['TXTNOTSTARTED']; 
								 }
							  } 
							  
						} 
						elseif($key!='task_title' && $key!='startdate' && $key!='enddate' && $key!='title' && $key!='task_status' && $key!='enddate_diff' && $key!='priority' && $key!='owner_id'){
							$report_exp[$j][$key] = $val;
						}
					} 
					 
					
					// If custom field is present then create column form them
					 
					// Custom field column creation ends here
					 
					$j++;
        		}
				 	 
                $completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				 
                $filename = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }
            
            else
                include(VIS_PATH_TEMPLATE . 'staff_task_assign_report.php');
            
            
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        
        return true;
        
        
    }
	
	function overdue_task_report($operation){
		 global $vis_language;
		 
        $report_title = $vis_language['TXTOVERDUETASK'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
             $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $staff      = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;

        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
               if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['staff_id'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['staff_id'] != -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }	
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $staff_id = ($data['staff_id'] == 0) ? '':$data['staff_id'] ;
				  	$filter =($data['staff_id'] == -2) ? ' INNER JOIN avis_task_assign on avis_task_assign.task_id!=avis_task.task_id ' : ' INNER JOIN avis_task_assign on avis_task_assign.task_id=avis_task.task_id ';
					 $filter .= ' where  avis_task.startdate between ' . $monthDate . ' AND ' . strtotime($currentdate);
					$filter .= ($data['staff_id'] != 0 && $data['staff_id'] != -2) ? ' and avis_task_assign.owner_id=' . $data['staff_id'] : ' ';
					 
					$filter .=" and (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ;
					$filter .=($data['staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM avis_task_assign  where avis_task_assign.task_id = avis_task.task_id)' : '';
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
					$staff_id = ($data['staff_id'] == 0) ? '':$data['staff_id'] ;
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
					$filter =($data['staff_id'] == -2) ? ' INNER JOIN avis_task_assign on avis_task_assign.task_id!=avis_task.task_id ' : ' INNER JOIN avis_task_assign on avis_task_assign.task_id=avis_task.task_id ';
                    $filter  .= ' where avis_task.startdate between ' . $weekDate . ' AND ' . strtotime($currentdate) ;
					$filter .= ($data['staff_id'] != 0 && $data['staff_id'] != -2) ? ' and avis_task_assign.owner_id=' . $data['staff_id'] : ' ';
					$filter.=" and (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ;
					$filter .=($data['staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM avis_task_assign  where avis_task_assign.task_id = avis_task.task_id)' : '';
			   }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    $staff_id = ($data['staff_id'] == 0) ? '':$data['staff_id'] ;
					$filter =($data['staff_id'] == -2) ? ' INNER JOIN avis_task_assign on avis_task_assign.task_id!=avis_task.task_id ' : ' INNER JOIN avis_task_assign on avis_task_assign.task_id=avis_task.task_id ';
                    $filter  .= ' where  avis_task.startdate between ' . $hour . ' AND ' . strtotime($currentdate) ;
					$filter .= ($data['staff_id'] != 0 && $data['staff_id'] != -2) ? ' and avis_task_assign.owner_id=' . $data['staff_id'] : ' ';
					$filter.=" and (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ;
					$filter .=($data['staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM avis_task_assign  where avis_task_assign.task_id = avis_task.task_id)' : '';
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
					$staff_id = ($data['staff_id'] == 0) ? '':$data['staff_id'] ;
					$filter =($data['staff_id'] == -2) ? ' INNER JOIN avis_task_assign on avis_task_assign.task_id!=avis_task.task_id ' : ' INNER JOIN avis_task_assign on avis_task_assign.task_id=avis_task.task_id ';
                   $filter  .= ' where  avis_task.startdate between ' . $from . ' AND ' . $to ;
                   $filter .= ($data['staff_id'] != 0 && $data['staff_id'] != -2) ? ' and avis_task_assign.owner_id=' . $data['staff_id'] : ' ';
				   $filter.=" and (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ; 
				   $filter .=($data['staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM avis_task_assign  where avis_task_assign.task_id = avis_task.task_id)' : '';
                }
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
             
           $object = new class_report($database);
             
			 
            
          $report = $object->assign_staff_overdue_task_report($unassign,$filter, VIS_STAFF_ID, VIS_LOCATION_AREA);  
         
			 
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                
				$filtern=VIS_TABLE_PREFIX.'customgroup.location = 13';
				$custom_fields_details=$object->task_custom_field($filtern);
				
				//start custom data
				 $temp=array();
         $temp1=array();		
         $temp2=array();	 
		 $a=0;
		  
		for($i=0;$i<count($custom_fields_details);$i++) 
		{
			$a=$custom_fields_details[$i]['task_id'];
			if($custom_fields_details[$i]['task_id']!=$temp1[$a]['task_id'])
			{$temp['task_id']=$custom_fields_details[$i]['task_id'];
		    $a=$custom_fields_details[$i]['task_id'];
			}
			$temp[$custom_fields_details[$i]['field_name']]=$custom_fields_details[$i]['content'];
			
			$temp1[$a]=$temp;
			 	
		}
 
			$temp2=reset($temp1);
		     
			foreach($report as $key => $csm)
			{
				if(in_array($report[$key]['task_id'],$temp1[$csm['task_id']])){
					foreach($temp1[$csm['task_id']] as $keys=>$val){
					if($keys !='task_id')
				   $report[$key][$keys]=$val;
			    
				}
			}else{
  
					foreach($temp2 as $keys=>$val){
					if($keys!='task_id')
					$report[$key][$keys]="";
					}
				}
				 
			} 
				// get custom filed data loop done
                
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export = new export();
                
                $j = 0;
                foreach ($report as $i) {
                    foreach ($i as $key => $val) {
                          if ($key == 'task_title') {
                            $report_exp[$j][$key] = $val;
                        }   elseif ($key == 'startdate') {
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        }elseif ($key == 'enddate') {
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        }  elseif ($key == 'title') {
                            $report_exp[$j][$key] = $val;
                        }  
						elseif ($key == 'task_status') {
							if($report[$j]['enddate_diff']<=0){
							if($val!=3 && $val!=4){
								$report_exp[$j][$key] =$vis_language['TXTOVERDUE']; 
							}else{
								if($val==1) {
									$report_exp[$j][$key] =$vis_language['TXTINPROGRESS']; 
								}else if($val==3){
									$report_exp[$j][$key] =$vis_language['TXTCOMPLETED']; 
								}else if($val==4){ 
									$report_exp[$j][$key] =$vis_language['TXTCANCELED'];  
								}
							} 
							}else{ 
								if($val==1) {
									$report_exp[$j][$key] =$vis_language['TXTINPROGRESS']; 
								}else if($val==3){
									$report_exp[$j][$key] =$vis_language['TXTCOMPLETED'];  
								}else if($val==4){ 
									$report_exp[$j][$key] =$vis_language['TXTCANCELED']; 
								}
							}
						} elseif($key!='task_title' && $key!='startdate' && $key!='enddate' && $key!='title' && $key!='enddate_diff' && $key!='task_status' && $key!='priority' && $key!='owner_id'){
							$report_exp[$j][$key] = $val;
						}
					}
					// If custom field is present then create column form them
					 
					// Custom field column creation ends here 
					 
					$j++;
                }
				
                $completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				 
                $filename = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }
            
            else
                include(VIS_PATH_TEMPLATE . 'overdue.php'); 
            
            
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        
        return true; 
        
		
	}
	function task_commented_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTCOMMENTEDREPORT'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
           $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $tkt_object = new class_ticket($database);
        $staff      = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;

        
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
                if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTDATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                /***** date difference ****/
                if ($data['duration'] == 4) {
                    list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
                    if (!$ret) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                        return false;
                    }
                }
                if ($data['duration'] == 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELSTAFFFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                
                $currentdate = date('Y-m-d h:i:s');
                if ($data['duration'] == 1) //if select Last 30 days duration
                    {
                    $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month') - VIS_TIMEZONE;
                    $filter    = 'avis_task_comment.entry_date between ' . $monthDate . ' AND ' . strtotime($currentdate) . ' and avis_task_comment.owner=' .$data['staff_id'];
                } else if ($data['duration'] == 2) //if select Last 7 days duration
                    {
                    $weekDate = strtotime("-1 week ") - VIS_TIMEZONE;
                     $filter    = 'avis_task_comment.entry_date between ' . $weekDate . ' AND ' . strtotime($currentdate) . ' and avis_task_comment.owner=' .$data['staff_id'];
                }
                
                else if ($data['duration'] == 3) //if select Last 24 hours duration
                    {
                    $hour = strtotime("-1 day ") - VIS_TIMEZONE;
                    
                    $filter    = 'avis_task_comment.entry_date  between ' . $hour . ' AND ' . strtotime($currentdate) . ' and avis_task_comment.owner=' .$data['staff_id'];
                } else if ($data['duration'] == 4) //if select Custom duration
                    {
                    $from   = strtotime($data['from_date']) - VIS_TIMEZONE;
                    $to     = strtotime($data['to_date']) - VIS_TIMEZONE;
                     $filter = 'avis_task_comment.entry_date  between ' . $from . ' AND ' . $to . ' and avis_task_comment.owner=' .$data['staff_id'];
                }
            }
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			
			$object = new class_report($database);
			$report = $object->task_commented_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);   
            if(isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				
				$filtern=VIS_TABLE_PREFIX.'customgroup.location = 13';
				$custom_fields_details=$object->get_custom_fields_data($filtern);
				
				//start custom data
				$temp=array();
         $temp1=array();		
         $temp2=array();	 
		 $a=0;
		  
		for($i=0;$i<count($custom_fields_details);$i++) 
		{
			$a=$custom_fields_details[$i]['task_id'];
			if($custom_fields_details[$i]['task_id']!=$temp1[$a]['task_id'])
			{$temp['task_id']=$custom_fields_details[$i]['task_id'];
		    $a=$custom_fields_details[$i]['task_id'];
			}
			$temp[$custom_fields_details[$i]['field_name']]=$custom_fields_details[$i]['content'];
			$temp1[$a]=$temp;			 
		}
 
			$temp2=reset($temp1);
		     
			foreach($report as $key => $csm)
			{
				if(in_array($report[$key]['task_id'],$temp1[$csm['task_id']])){

					foreach($temp1[$csm['task_id']] as $keys=>$val){
					if($keys!='task_id')
					$report[$key][$keys]=$val;
				}
			}else{

					foreach($temp2 as $keys=>$val){
					if($keys!='task_id')
					$report[$key][$keys]=$val;
					}
				}
		   
			
																									
			}
				// get custom filed data loop done
			
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j = 0;
              	foreach ($report as $i)
				{
					foreach ($i as $key => $val) {
                    	if ($key == 'task_title') {
                            $report_exp[$j][$key] = $val;
                        }   elseif ($key == 'entry_date') {
                            $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                        } elseif($key=='content'){
							$report_exp[$j][$key] = $val;
						} 
						elseif ($key == 'task_status') {
							if($report[$j]['enddate_diff']<=0){
								if($val!=3 && $val!=4 && $val!=5 && $val!=1){
									$report_exp[$j][$key] =$vis_language['TXTOVERDUE']; 
								}else{
									if($val==1) {
										$report_exp[$j][$key] =$vis_language['TXTINPROGRESS']; 
									}else if($val==3){
										$report_exp[$j][$key] =$vis_language['TXTCOMPLETED']; 
									}else if($val==4){ 
										$report_exp[$j][$key] =$vis_language['TXTCANCELED'];  
									}else if($val==5){ 
										$report_exp[$j][$key] =$vis_language['TXTNOTSTARTED'];  
									}
								} 
							}else{ 
								if($val==1) {
									$report_exp[$j][$key] =$vis_language['TXTINPROGRESS']; 
								}else if($val==3){
									$report_exp[$j][$key] =$vis_language['TXTCOMPLETED'];  
								}else if($val==4){ 
									$report_exp[$j][$key] =$vis_language['TXTCANCELED']; 
								}
								else if($val==5){ 
									$report_exp[$j][$key] =$vis_language['TXTNOTSTARTED'];  
								}
							} 
						} elseif($key!='task_title' && $key!='enddate_diff' && $key!='startdate' && $key!='entry_date' && $key!='content' && $key!='enddate' && $key!='task_status' && $key!='priority'){
							$report_exp[$j][$key] = $val;
						}
					} 
					 
					
					// If custom field is present then create column form them
					 
					// Custom field column creation ends here
					
					$j++;
                }
				 	 
                $completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				 
                $filename = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
				    if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            }
            
            else
                include(VIS_PATH_TEMPLATE . 'task_commented_report.php');
            
            
            
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
        $database->database_disconnect();
        
        return true;
        
        
    }
	
	function strip_html_tags( $text )
    {
     // Remove invisible content
     $text = preg_replace(
        array(
            //ADD a (') before @<head ON NEXT LINE. Why? see below
            '@<head[^>]*?>.*?</head>@siu',
            '@<style[^>]*?>.*?</style>@siu',
            '@<script[^>]*?.*?</script>@siu',
            '@<object[^>]*?.*?</object>@siu',
            '@<embed[^>]*?.*?</embed>@siu',
            '@<applet[^>]*?.*?</applet>@siu',
            '@<noframes[^>]*?.*?</noframes>@siu',
            '@<noscript[^>]*?.*?</noscript>@siu',
            '@<noembed[^>]*?.*?</noembed>@siu',
          // Add line breaks before and after blocks
            '@</?((address)|(blockquote)|(center)|(del))@iu',
            '@</?((div)|(h[1-9])|(ins)|(isindex)|(p)|(pre))@iu',
            '@</?((dir)|(dl)|(dt)|(dd)|(li)|(menu)|(ol)|(ul))@iu',
            '@</?((table)|(th)|(td)|(caption))@iu',
            '@</?((form)|(button)|(fieldset)|(legend)|(input))@iu',
            '@</?((label)|(select)|(optgroup)|(option)|(textarea))@iu',
            '@</?((frameset)|(frame)|(iframe))@iu',
        ),
        array(
            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
            "\$0", "\$0", "\$0", "\$0", "\$0", "\$0",
            "\$0", "\$0",
        ),
        $text );
    return strip_tags( $text );
} 

function graphical_status_change_report($operation) {
		global $vis_language;
        $report_title=$vis_language['TXTSTATUSCHANGEREPORT'];
        $database=new class_database();
		$export=1;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $tkt_object=new class_ticket($database);
        $getPdf = 1;
        $canvasDiv = "#channel_report";
        $pdfTitle = $vis_language['TXTSTATUSCHANGEREPORT'];
        $toDisplay = $vis_language['TXTSTATUSCHANGEREPORT'];
        $graphicalReport = 1;
         $tkt_object=new class_ticket($database);
		 $filter     = VIS_TABLE_PREFIX . 'staff.is_enabled=1 ';
       

           $staff       = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);

        // $domain     = $tkt_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
       if(isset($operation['vis_action']) && $operation['vis_action']!='') {
            if(isset($operation['vis_submit']) && $operation['vis_submit']!='') $data=$operation;
            else $data=parse_form_array($operation['vis_action']); 
             if(count($data)==0) {
                include(VIS_PATH_TEMPLATE.'report_form.php');
                return true;
            }			 
             $currentdate = date('Y-m-d h:i:s');
			if(($data['from_date'] == '' && $data['to_date'] == '' && $data['duration']==4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration']==4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration']==4)) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDATE'].'"); </script>';
                    return false;
            }
			if($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if(!$ret){
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$msg.'"); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '"); </script>';
                    return false;
                } else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDOMAINFORRES'] . '"); </script>';
                    return false;
                } else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELDURATIONFORGEN'] . '"); </script>';
                    return false;
                }	
			  $currentdate = date('Y-m-d h:i:s');
			  if($data['duration'] == 1) //if select Last 30 days duration
			 {  
					 $monthDate = strtotime(date('Y-m-d h:i:s', strtotime($currentdate)) . '-1 month')- VIS_TIMEZONE;
					 $filter =  ' entry_date between '.$monthDate.' AND '.strtotime($currentdate).' and operator_id='.$data['staff_id'];
			 }    
			 else if($data['duration'] == 2)//if select Last 7 days duration
			 {
					$weekDate =strtotime("-1 week ")- VIS_TIMEZONE;
				  $filter = ' entry_date between '.$weekDate.' AND '.strtotime($currentdate).' and operator_id='.$data['staff_id']; 
			 }
			 else if($data['duration'] == 3)//if select Last 24 hours duration
			 {
					 $hour=strtotime("-1 day ")- VIS_TIMEZONE;
					  $filter = ' entry_date between '.$hour.' AND '.strtotime($currentdate).' and operator_id='.$data['staff_id'];
			 }
			 else if($data['duration'] == 4)//if select Custom duration
			 {
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to = strtotime($data['to_date']) - VIS_TIMEZONE;
				    $filter =  ' entry_date between '.$from.' AND '.$to.' and operator_id='.$data['staff_id'];  
			 } 
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'report.php');
            $object=new class_report($database);
            $report=$object->get_graphical_status_change_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);  
		
		   
            include(VIS_PATH_TEMPLATE.'graphical_status_change_report.php');
        }
        else include(VIS_PATH_TEMPLATE.'report_form.php');
        $database->database_disconnect();
        return true;
    }
	
	function customfield_data_orgreg_report($operation)
    {
        global $vis_language;
        $report_title = $vis_language['TXTCSTRPTORGREG'];
        $export       = 1;
        if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
            $database = new class_database('mysql', 1);
        else
            $database = new class_database();
			
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        $object_staff = new class_staff($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $object_setting   = new class_setting($database);
        $filter1           = 'location=12';
        $custom_grouplist = $object_setting->get_custom_group_list($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA);
        for ($i = 0; $i < count($custom_grouplist); $i++) {
            $filter1 = ' ' . VIS_TABLE_PREFIX . 'customfield.customgroup_id=' . $custom_grouplist[$i]['customgroup_id'] . ' and ' . VIS_TABLE_PREFIX . 'customfield.is_enabled=1 ';
            list($customfield_info, $customfield_details) = $object_setting->get_customfield(0, $filter1, '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
            $customfield_orgreg_array[] = $customfield_details;
        }
       // echo '<pre>';
      //  print_r($customfield_orgreg_array);echo '</pre>';
        
        if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1)
                $filter = $operation['filter'];
            else {
                if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
                    $data = $operation;
                else
                    $data = parse_form_array($operation['vis_action']);
                if (count($data) == 0) {
                    include(VIS_PATH_TEMPLATE . 'report_form.php');
                    return true;
                }
				if ($data['userfield_name'] == "") {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['TXTSELECTFORGENERATE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
                    return false;
                }
                if ($data['userfield_name'] != 0) {
                    $filter = 'cf.field_group=' . $data['userfield_name'].' and cg.location=12';
                }	
				 if ($data['userfield_name'] == 0) {
                    $filter = ' cg.location=12';
                }	
            }
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
            $object      = new class_report($database);			
			
            $report      = $object->get_customfield_data_report_for_orgreg($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
            $custFilter1 = ' (location in (12))  and is_enabled=1 ';
            $custom_grouplist = $object_setting->get_custom_group_list($custFilter1, VIS_STAFF_ID, VIS_LOCATION_AREA);
            if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
                $export         = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'group_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'office_email'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'domain_name'){
						$report_exp[$j][$key] = $val;
						}						
						elseif($key == 'field_name'){
						$report_exp[$j][$key] = $val;
						}
						elseif($key == 'content'){
						$report_exp[$j][$key] = $val;
						}
						
					}
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['office_email'];
					$report_exp1[$j]['domain_name'] = $report_exp[$j]['domain_name'];				
					$report_exp1[$j]['field_name'] = $report_exp[$j]['field_name']; 
					$report_exp1[$j]['field_value'] = $report_exp[$j]['content']; 
					
                    $j++;
                }
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				
                $filename       = $operation['export_name'].'_'.rand(strtotime($completed_date), strtotime($s_request_date));
                if ($operation['export_type'] == 1) {
                    $export->export_csv($report_exp1, $filename, '', VIS_SLAVE_DB);
                    if (file_exists('../downloads/' . $filename . '.csv')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 2) {
                    $export->export_html($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.html')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                } else if ($operation['export_type'] == 3) {
                    
                    
                    $export->export_xlsx($report_exp1, $filename, '', VIS_SLAVE_DB);
                    
                    if (file_exists('../downloads/' . $filename . '.xls')) {
                        $filename = $filename;
                    } else {
                        $filename = '';
                    }
                }
																
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
                    $database->database_disconnect();
                    $database = new class_database();
                    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
                    $object = new class_report($database);
                    
                }
                $result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
                if (!$result)
                    return false;
                $this->email_send_download($operation);
                return true;
            } else
                include(VIS_PATH_TEMPLATE . 'customfield_data_report_for_orgreg.php');
        } else
            include(VIS_PATH_TEMPLATE . 'report_form.php');
			
        $database->database_disconnect();
        return true;

	}

}
?>
